/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.zoo.model;

import java.util.Arrays;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ActivationLayer;
import org.deeplearning4j.nn.conf.layers.BatchNormalization;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.OutputLayer;
import org.deeplearning4j.nn.conf.layers.PoolingType;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.zoo.ModelMetaData;
import org.deeplearning4j.zoo.PretrainedType;
import org.deeplearning4j.zoo.ZooModel;
import org.deeplearning4j.zoo.ZooType;
import org.deeplearning4j.zoo.model.helper.NASNetHelper;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.learning.config.AdaDelta;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class NASNet
extends ZooModel {
    private long seed;
    private int[] inputShape;
    private int numClasses;
    private WeightInit weightInit;
    private IUpdater updater;
    private CacheMode cacheMode;
    private WorkspaceMode workspaceMode;
    private ConvolutionLayer.AlgoMode cudnnAlgoMode;
    private int numBlocks;
    private int penultimateFilters;
    private int stemFilters;
    private int filterMultiplier;
    private boolean skipReduction;

    private NASNet() {
    }

    @Override
    public String pretrainedUrl(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return DL4JResources.getURLString((String)"models/nasnetmobile_dl4j_inference.v1.zip");
        }
        if (pretrainedType == PretrainedType.IMAGENETLARGE) {
            return DL4JResources.getURLString((String)"models/nasnetlarge_dl4j_inference.v1.zip");
        }
        return null;
    }

    @Override
    public long pretrainedChecksum(PretrainedType pretrainedType) {
        if (pretrainedType == PretrainedType.IMAGENET) {
            return 3082463801L;
        }
        if (pretrainedType == PretrainedType.IMAGENETLARGE) {
            return 321395591L;
        }
        return 0L;
    }

    @Override
    public Class<? extends Model> modelType() {
        return ComputationGraph.class;
    }

    public ComputationGraph init() {
        ComputationGraphConfiguration.GraphBuilder graph = this.graphBuilder();
        graph.addInputs(new String[]{"input"}).setInputTypes(new InputType[]{InputType.convolutional((long)this.inputShape[2], (long)this.inputShape[1], (long)this.inputShape[0])});
        ComputationGraphConfiguration conf = graph.build();
        ComputationGraph model = new ComputationGraph(conf);
        model.init();
        return model;
    }

    public ComputationGraphConfiguration.GraphBuilder graphBuilder() {
        Pair<String, String> block;
        int i;
        if (this.penultimateFilters % 24 != 0) {
            throw new IllegalArgumentException("For NASNet-A models penultimate filters must be divisible by 24. Current value is " + this.penultimateFilters);
        }
        int filters = (int)Math.floor(this.penultimateFilters / 24);
        ComputationGraphConfiguration.GraphBuilder graph = new NeuralNetConfiguration.Builder().seed(this.seed).optimizationAlgo(OptimizationAlgorithm.STOCHASTIC_GRADIENT_DESCENT).updater(this.updater).weightInit(this.weightInit).l2(5.0E-5).miniBatch(true).cacheMode(this.cacheMode).trainingWorkspaceMode(this.workspaceMode).inferenceWorkspaceMode(this.workspaceMode).cudnnAlgoMode(this.cudnnAlgoMode).convolutionMode(ConvolutionMode.Truncate).graphBuilder();
        if (!this.skipReduction) {
            graph.addLayer("stem_conv1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{2, 2}).nOut(this.stemFilters)).hasBias(false)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"input"});
        } else {
            graph.addLayer("stem_conv1", (Layer)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)((ConvolutionLayer.Builder)new ConvolutionLayer.Builder(new int[]{3, 3}).stride(new int[]{1, 1}).nOut(this.stemFilters)).hasBias(false)).cudnnAlgoMode(this.cudnnAlgoMode)).build(), new String[]{"input"});
        }
        graph.addLayer("stem_bn1", (Layer)new BatchNormalization.Builder().eps(0.001).gamma(0.9997).build(), new String[]{"stem_conv1"});
        String inputX = "stem_bn1";
        String inputP = null;
        if (!this.skipReduction) {
            Pair<String, String> stem1 = NASNetHelper.reductionA(graph, (int)Math.floor((double)this.stemFilters / Math.pow(this.filterMultiplier, 2.0)), "stem1", "stem_conv1", inputP);
            Pair<String, String> stem2 = NASNetHelper.reductionA(graph, (int)Math.floor(this.stemFilters / this.filterMultiplier), "stem2", (String)stem1.getFirst(), (String)stem1.getSecond());
            inputX = (String)stem2.getFirst();
            inputP = (String)stem2.getSecond();
        }
        for (int i2 = 0; i2 < this.numBlocks; ++i2) {
            Pair<String, String> block2 = NASNetHelper.normalA(graph, filters, String.valueOf(i2), inputX, inputP);
            inputX = (String)block2.getFirst();
            inputP = (String)block2.getSecond();
        }
        Pair<String, String> reduce = NASNetHelper.reductionA(graph, filters * this.filterMultiplier, "reduce" + this.numBlocks, inputX, inputP);
        inputX = (String)reduce.getFirst();
        String inputP0 = (String)reduce.getSecond();
        if (!this.skipReduction) {
            inputP = inputP0;
        }
        for (i = 0; i < this.numBlocks; ++i) {
            block = NASNetHelper.normalA(graph, filters * this.filterMultiplier, String.valueOf(i + this.numBlocks + 1), inputX, inputP);
            inputX = (String)block.getFirst();
            inputP = (String)block.getSecond();
        }
        reduce = NASNetHelper.reductionA(graph, filters * (int)Math.pow(this.filterMultiplier, 2.0), "reduce" + 2 * this.numBlocks, inputX, inputP);
        inputX = (String)reduce.getFirst();
        inputP0 = (String)reduce.getSecond();
        if (!this.skipReduction) {
            inputP = inputP0;
        }
        for (i = 0; i < this.numBlocks; ++i) {
            block = NASNetHelper.normalA(graph, filters * (int)Math.pow(this.filterMultiplier, 2.0), String.valueOf(i + 2 * this.numBlocks + 1), inputX, inputP);
            inputX = (String)block.getFirst();
            inputP = (String)block.getSecond();
        }
        graph.addLayer("act", (Layer)new ActivationLayer(Activation.RELU), new String[]{inputX}).addLayer("avg_pool", (Layer)new GlobalPoolingLayer.Builder(PoolingType.AVG).build(), new String[]{"act"}).addLayer("output", (Layer)((OutputLayer.Builder)new OutputLayer.Builder(LossFunctions.LossFunction.MCXENT).activation(Activation.SOFTMAX)).build(), new String[]{"avg_pool"}).setOutputs(new String[]{"output"});
        return graph;
    }

    @Override
    public ModelMetaData metaData() {
        return new ModelMetaData(new int[][]{this.inputShape}, 1, ZooType.CNN);
    }

    @Override
    public void setInputShape(int[][] inputShape) {
        this.inputShape = inputShape[0];
    }

    private static long $default$seed() {
        return 1234L;
    }

    private static int[] $default$inputShape() {
        return new int[]{3, 224, 224};
    }

    private static int $default$numClasses() {
        return 0;
    }

    private static WeightInit $default$weightInit() {
        return WeightInit.RELU;
    }

    private static IUpdater $default$updater() {
        return new AdaDelta();
    }

    private static CacheMode $default$cacheMode() {
        return CacheMode.DEVICE;
    }

    private static WorkspaceMode $default$workspaceMode() {
        return WorkspaceMode.ENABLED;
    }

    private static ConvolutionLayer.AlgoMode $default$cudnnAlgoMode() {
        return ConvolutionLayer.AlgoMode.PREFER_FASTEST;
    }

    private static int $default$numBlocks() {
        return 6;
    }

    private static int $default$penultimateFilters() {
        return 1056;
    }

    private static int $default$stemFilters() {
        return 96;
    }

    private static int $default$filterMultiplier() {
        return 2;
    }

    private static boolean $default$skipReduction() {
        return true;
    }

    public static NASNetBuilder builder() {
        return new NASNetBuilder();
    }

    public NASNet(long seed, int[] inputShape, int numClasses, WeightInit weightInit, IUpdater updater, CacheMode cacheMode, WorkspaceMode workspaceMode, ConvolutionLayer.AlgoMode cudnnAlgoMode, int numBlocks, int penultimateFilters, int stemFilters, int filterMultiplier, boolean skipReduction) {
        this.seed = seed;
        this.inputShape = inputShape;
        this.numClasses = numClasses;
        this.weightInit = weightInit;
        this.updater = updater;
        this.cacheMode = cacheMode;
        this.workspaceMode = workspaceMode;
        this.cudnnAlgoMode = cudnnAlgoMode;
        this.numBlocks = numBlocks;
        this.penultimateFilters = penultimateFilters;
        this.stemFilters = stemFilters;
        this.filterMultiplier = filterMultiplier;
        this.skipReduction = skipReduction;
    }

    public static class NASNetBuilder {
        private boolean seed$set;
        private long seed$value;
        private boolean inputShape$set;
        private int[] inputShape$value;
        private boolean numClasses$set;
        private int numClasses$value;
        private boolean weightInit$set;
        private WeightInit weightInit$value;
        private boolean updater$set;
        private IUpdater updater$value;
        private boolean cacheMode$set;
        private CacheMode cacheMode$value;
        private boolean workspaceMode$set;
        private WorkspaceMode workspaceMode$value;
        private boolean cudnnAlgoMode$set;
        private ConvolutionLayer.AlgoMode cudnnAlgoMode$value;
        private boolean numBlocks$set;
        private int numBlocks$value;
        private boolean penultimateFilters$set;
        private int penultimateFilters$value;
        private boolean stemFilters$set;
        private int stemFilters$value;
        private boolean filterMultiplier$set;
        private int filterMultiplier$value;
        private boolean skipReduction$set;
        private boolean skipReduction$value;

        NASNetBuilder() {
        }

        public NASNetBuilder seed(long seed) {
            this.seed$value = seed;
            this.seed$set = true;
            return this;
        }

        public NASNetBuilder inputShape(int[] inputShape) {
            this.inputShape$value = inputShape;
            this.inputShape$set = true;
            return this;
        }

        public NASNetBuilder numClasses(int numClasses) {
            this.numClasses$value = numClasses;
            this.numClasses$set = true;
            return this;
        }

        public NASNetBuilder weightInit(WeightInit weightInit) {
            this.weightInit$value = weightInit;
            this.weightInit$set = true;
            return this;
        }

        public NASNetBuilder updater(IUpdater updater) {
            this.updater$value = updater;
            this.updater$set = true;
            return this;
        }

        public NASNetBuilder cacheMode(CacheMode cacheMode) {
            this.cacheMode$value = cacheMode;
            this.cacheMode$set = true;
            return this;
        }

        public NASNetBuilder workspaceMode(WorkspaceMode workspaceMode) {
            this.workspaceMode$value = workspaceMode;
            this.workspaceMode$set = true;
            return this;
        }

        public NASNetBuilder cudnnAlgoMode(ConvolutionLayer.AlgoMode cudnnAlgoMode) {
            this.cudnnAlgoMode$value = cudnnAlgoMode;
            this.cudnnAlgoMode$set = true;
            return this;
        }

        public NASNetBuilder numBlocks(int numBlocks) {
            this.numBlocks$value = numBlocks;
            this.numBlocks$set = true;
            return this;
        }

        public NASNetBuilder penultimateFilters(int penultimateFilters) {
            this.penultimateFilters$value = penultimateFilters;
            this.penultimateFilters$set = true;
            return this;
        }

        public NASNetBuilder stemFilters(int stemFilters) {
            this.stemFilters$value = stemFilters;
            this.stemFilters$set = true;
            return this;
        }

        public NASNetBuilder filterMultiplier(int filterMultiplier) {
            this.filterMultiplier$value = filterMultiplier;
            this.filterMultiplier$set = true;
            return this;
        }

        public NASNetBuilder skipReduction(boolean skipReduction) {
            this.skipReduction$value = skipReduction;
            this.skipReduction$set = true;
            return this;
        }

        public NASNet build() {
            long seed$value = this.seed$value;
            if (!this.seed$set) {
                seed$value = NASNet.$default$seed();
            }
            int[] inputShape$value = this.inputShape$value;
            if (!this.inputShape$set) {
                inputShape$value = NASNet.$default$inputShape();
            }
            int numClasses$value = this.numClasses$value;
            if (!this.numClasses$set) {
                numClasses$value = NASNet.$default$numClasses();
            }
            WeightInit weightInit$value = this.weightInit$value;
            if (!this.weightInit$set) {
                weightInit$value = NASNet.$default$weightInit();
            }
            IUpdater updater$value = this.updater$value;
            if (!this.updater$set) {
                updater$value = NASNet.$default$updater();
            }
            CacheMode cacheMode$value = this.cacheMode$value;
            if (!this.cacheMode$set) {
                cacheMode$value = NASNet.$default$cacheMode();
            }
            WorkspaceMode workspaceMode$value = this.workspaceMode$value;
            if (!this.workspaceMode$set) {
                workspaceMode$value = NASNet.$default$workspaceMode();
            }
            ConvolutionLayer.AlgoMode cudnnAlgoMode$value = this.cudnnAlgoMode$value;
            if (!this.cudnnAlgoMode$set) {
                cudnnAlgoMode$value = NASNet.$default$cudnnAlgoMode();
            }
            int numBlocks$value = this.numBlocks$value;
            if (!this.numBlocks$set) {
                numBlocks$value = NASNet.$default$numBlocks();
            }
            int penultimateFilters$value = this.penultimateFilters$value;
            if (!this.penultimateFilters$set) {
                penultimateFilters$value = NASNet.$default$penultimateFilters();
            }
            int stemFilters$value = this.stemFilters$value;
            if (!this.stemFilters$set) {
                stemFilters$value = NASNet.$default$stemFilters();
            }
            int filterMultiplier$value = this.filterMultiplier$value;
            if (!this.filterMultiplier$set) {
                filterMultiplier$value = NASNet.$default$filterMultiplier();
            }
            boolean skipReduction$value = this.skipReduction$value;
            if (!this.skipReduction$set) {
                skipReduction$value = NASNet.$default$skipReduction();
            }
            return new NASNet(seed$value, inputShape$value, numClasses$value, weightInit$value, updater$value, cacheMode$value, workspaceMode$value, cudnnAlgoMode$value, numBlocks$value, penultimateFilters$value, stemFilters$value, filterMultiplier$value, skipReduction$value);
        }

        public String toString() {
            return "NASNet.NASNetBuilder(seed$value=" + this.seed$value + ", inputShape$value=" + Arrays.toString(this.inputShape$value) + ", numClasses$value=" + this.numClasses$value + ", weightInit$value=" + this.weightInit$value + ", updater$value=" + this.updater$value + ", cacheMode$value=" + this.cacheMode$value + ", workspaceMode$value=" + this.workspaceMode$value + ", cudnnAlgoMode$value=" + this.cudnnAlgoMode$value + ", numBlocks$value=" + this.numBlocks$value + ", penultimateFilters$value=" + this.penultimateFilters$value + ", stemFilters$value=" + this.stemFilters$value + ", filterMultiplier$value=" + this.filterMultiplier$value + ", skipReduction$value=" + this.skipReduction$value + ")";
        }
    }
}

