/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator;

import java.util.Iterator;
import java.util.List;
import lombok.NonNull;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;

public class ExistingDataSetIterator
implements DataSetIterator {
    private DataSetPreProcessor preProcessor;
    private transient Iterable<org.nd4j.linalg.dataset.DataSet> iterable;
    private transient Iterator<org.nd4j.linalg.dataset.DataSet> iterator;
    private int totalExamples = 0;
    private int numFeatures = 0;
    private int numLabels = 0;
    private List<String> labels;

    public ExistingDataSetIterator(@NonNull Iterator<org.nd4j.linalg.dataset.DataSet> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        this.iterator = iterator;
    }

    public ExistingDataSetIterator(@NonNull Iterator<org.nd4j.linalg.dataset.DataSet> iterator, @NonNull List<String> labels) {
        this(iterator);
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        if (labels == null) {
            throw new NullPointerException("labels is marked non-null but is null");
        }
        this.labels = labels;
    }

    public ExistingDataSetIterator(@NonNull Iterable<org.nd4j.linalg.dataset.DataSet> iterable) {
        if (iterable == null) {
            throw new NullPointerException("iterable is marked non-null but is null");
        }
        this.iterable = iterable;
        this.iterator = iterable.iterator();
    }

    public ExistingDataSetIterator(@NonNull Iterable<org.nd4j.linalg.dataset.DataSet> iterable, @NonNull List<String> labels) {
        this(iterable);
        if (iterable == null) {
            throw new NullPointerException("iterable is marked non-null but is null");
        }
        if (labels == null) {
            throw new NullPointerException("labels is marked non-null but is null");
        }
        this.labels = labels;
    }

    public ExistingDataSetIterator(@NonNull Iterable<org.nd4j.linalg.dataset.DataSet> iterable, int totalExamples, int numFeatures, int numLabels) {
        this(iterable);
        if (iterable == null) {
            throw new NullPointerException("iterable is marked non-null but is null");
        }
        this.totalExamples = totalExamples;
        this.numFeatures = numFeatures;
        this.numLabels = numLabels;
    }

    public org.nd4j.linalg.dataset.DataSet next(int num) {
        throw new UnsupportedOperationException("next(int) isn't supported");
    }

    public int inputColumns() {
        return this.numFeatures;
    }

    public int totalOutcomes() {
        if (this.labels != null) {
            return this.labels.size();
        }
        return this.numLabels;
    }

    public boolean resetSupported() {
        return this.iterable != null;
    }

    public boolean asyncSupported() {
        return false;
    }

    public void reset() {
        if (this.iterable == null) {
            throw new IllegalStateException("To use reset() method you need to provide Iterable<DataSet>, not Iterator");
        }
        this.iterator = this.iterable.iterator();
    }

    public int batch() {
        return 0;
    }

    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public boolean hasNext() {
        if (this.iterator != null) {
            return this.iterator.hasNext();
        }
        return false;
    }

    public org.nd4j.linalg.dataset.DataSet next() {
        if (this.preProcessor != null) {
            org.nd4j.linalg.dataset.DataSet ds = this.iterator.next();
            if (!ds.isPreProcessed()) {
                this.preProcessor.preProcess((DataSet)ds);
                ds.markAsPreProcessed();
            }
            return ds;
        }
        return this.iterator.next();
    }

    public void remove() {
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }
}

