/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.ui.stats.sbe;

import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.deeplearning4j.ui.stats.sbe.GroupSizeEncodingDecoder;
import org.deeplearning4j.ui.stats.sbe.InitFieldsPresentDecoder;
import org.deeplearning4j.ui.stats.sbe.MetaAttribute;

public class StaticInfoDecoder {
    public static final int BLOCK_LENGTH = 40;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    private final StaticInfoDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;
    private final InitFieldsPresentDecoder fieldsPresent = new InitFieldsPresentDecoder();
    private final HwDeviceInfoGroupDecoder hwDeviceInfoGroup = new HwDeviceInfoGroupDecoder();
    private final SwEnvironmentInfoDecoder swEnvironmentInfo = new SwEnvironmentInfoDecoder();
    private final ModelParamNamesDecoder modelParamNames = new ModelParamNamesDecoder();

    public int sbeBlockLength() {
        return 40;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public int offset() {
        return this.offset;
    }

    public StaticInfoDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        this.buffer = buffer;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int timeId() {
        return 1;
    }

    public static String timeMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static long timeNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timeMinValue() {
        return -9223372036854775807L;
    }

    public static long timeMaxValue() {
        return Long.MAX_VALUE;
    }

    public long time() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int fieldsPresentId() {
        return 2;
    }

    public static String fieldsPresentMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public InitFieldsPresentDecoder fieldsPresent() {
        this.fieldsPresent.wrap(this.buffer, this.offset + 8);
        return this.fieldsPresent;
    }

    public static int hwJvmProcessorsId() {
        return 3;
    }

    public static String hwJvmProcessorsMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int hwJvmProcessorsNullValue() {
        return 65535;
    }

    public static int hwJvmProcessorsMinValue() {
        return 0;
    }

    public static int hwJvmProcessorsMaxValue() {
        return 65534;
    }

    public int hwJvmProcessors() {
        return this.buffer.getShort(this.offset + 9, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int hwNumDevicesId() {
        return 4;
    }

    public static String hwNumDevicesMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static short hwNumDevicesNullValue() {
        return 255;
    }

    public static short hwNumDevicesMinValue() {
        return 0;
    }

    public static short hwNumDevicesMaxValue() {
        return 254;
    }

    public short hwNumDevices() {
        return (short)(this.buffer.getByte(this.offset + 11) & 0xFF);
    }

    public static int hwJvmMaxMemoryId() {
        return 5;
    }

    public static String hwJvmMaxMemoryMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static long hwJvmMaxMemoryNullValue() {
        return Long.MIN_VALUE;
    }

    public static long hwJvmMaxMemoryMinValue() {
        return -9223372036854775807L;
    }

    public static long hwJvmMaxMemoryMaxValue() {
        return Long.MAX_VALUE;
    }

    public long hwJvmMaxMemory() {
        return this.buffer.getLong(this.offset + 12, ByteOrder.LITTLE_ENDIAN);
    }

    public static int hwOffheapMaxMemoryId() {
        return 6;
    }

    public static String hwOffheapMaxMemoryMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static long hwOffheapMaxMemoryNullValue() {
        return Long.MIN_VALUE;
    }

    public static long hwOffheapMaxMemoryMinValue() {
        return -9223372036854775807L;
    }

    public static long hwOffheapMaxMemoryMaxValue() {
        return Long.MAX_VALUE;
    }

    public long hwOffheapMaxMemory() {
        return this.buffer.getLong(this.offset + 20, ByteOrder.LITTLE_ENDIAN);
    }

    public static int modelNumLayersId() {
        return 7;
    }

    public static String modelNumLayersMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int modelNumLayersNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int modelNumLayersMinValue() {
        return -2147483647;
    }

    public static int modelNumLayersMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int modelNumLayers() {
        return this.buffer.getInt(this.offset + 28, ByteOrder.LITTLE_ENDIAN);
    }

    public static int modelNumParamsId() {
        return 8;
    }

    public static String modelNumParamsMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static long modelNumParamsNullValue() {
        return Long.MIN_VALUE;
    }

    public static long modelNumParamsMinValue() {
        return -9223372036854775807L;
    }

    public static long modelNumParamsMaxValue() {
        return Long.MAX_VALUE;
    }

    public long modelNumParams() {
        return this.buffer.getLong(this.offset + 32, ByteOrder.LITTLE_ENDIAN);
    }

    public static long hwDeviceInfoGroupDecoderId() {
        return 9L;
    }

    public HwDeviceInfoGroupDecoder hwDeviceInfoGroup() {
        this.hwDeviceInfoGroup.wrap(this.parentMessage, this.buffer);
        return this.hwDeviceInfoGroup;
    }

    public static long swEnvironmentInfoDecoderId() {
        return 12L;
    }

    public SwEnvironmentInfoDecoder swEnvironmentInfo() {
        this.swEnvironmentInfo.wrap(this.parentMessage, this.buffer);
        return this.swEnvironmentInfo;
    }

    public static long modelParamNamesDecoderId() {
        return 11L;
    }

    public ModelParamNamesDecoder modelParamNames() {
        this.modelParamNames.wrap(this.parentMessage, this.buffer);
        return this.modelParamNames;
    }

    public static int sessionIDId() {
        return 100;
    }

    public static String sessionIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String sessionIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int sessionIDHeaderLength() {
        return 4;
    }

    public int sessionIDLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getSessionID(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSessionID(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String sessionID() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int typeIDId() {
        return 101;
    }

    public static String typeIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String typeIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int typeIDHeaderLength() {
        return 4;
    }

    public int typeIDLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getTypeID(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getTypeID(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String typeID() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int workerIDId() {
        return 102;
    }

    public static String workerIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String workerIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int workerIDHeaderLength() {
        return 4;
    }

    public int workerIDLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getWorkerID(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getWorkerID(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String workerID() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int swArchId() {
        return 201;
    }

    public static String swArchCharacterEncoding() {
        return "UTF-8";
    }

    public static String swArchMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swArchHeaderLength() {
        return 4;
    }

    public int swArchLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getSwArch(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSwArch(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String swArch() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int swOsNameId() {
        return 202;
    }

    public static String swOsNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String swOsNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swOsNameHeaderLength() {
        return 4;
    }

    public int swOsNameLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getSwOsName(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSwOsName(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String swOsName() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int swJvmNameId() {
        return 203;
    }

    public static String swJvmNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String swJvmNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swJvmNameHeaderLength() {
        return 4;
    }

    public int swJvmNameLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getSwJvmName(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSwJvmName(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String swJvmName() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int swJvmVersionId() {
        return 204;
    }

    public static String swJvmVersionCharacterEncoding() {
        return "UTF-8";
    }

    public static String swJvmVersionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swJvmVersionHeaderLength() {
        return 4;
    }

    public int swJvmVersionLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getSwJvmVersion(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSwJvmVersion(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String swJvmVersion() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int swJvmSpecVersionId() {
        return 205;
    }

    public static String swJvmSpecVersionCharacterEncoding() {
        return "UTF-8";
    }

    public static String swJvmSpecVersionMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swJvmSpecVersionHeaderLength() {
        return 4;
    }

    public int swJvmSpecVersionLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getSwJvmSpecVersion(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSwJvmSpecVersion(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String swJvmSpecVersion() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int swNd4jBackendClassId() {
        return 206;
    }

    public static String swNd4jBackendClassCharacterEncoding() {
        return "UTF-8";
    }

    public static String swNd4jBackendClassMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swNd4jBackendClassHeaderLength() {
        return 4;
    }

    public int swNd4jBackendClassLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getSwNd4jBackendClass(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSwNd4jBackendClass(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String swNd4jBackendClass() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int swNd4jDataTypeNameId() {
        return 207;
    }

    public static String swNd4jDataTypeNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String swNd4jDataTypeNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swNd4jDataTypeNameHeaderLength() {
        return 4;
    }

    public int swNd4jDataTypeNameLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getSwNd4jDataTypeName(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSwNd4jDataTypeName(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String swNd4jDataTypeName() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int swHostNameId() {
        return 208;
    }

    public static String swHostNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String swHostNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swHostNameHeaderLength() {
        return 4;
    }

    public int swHostNameLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getSwHostName(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSwHostName(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String swHostName() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int swJvmUIDId() {
        return 209;
    }

    public static String swJvmUIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String swJvmUIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int swJvmUIDHeaderLength() {
        return 4;
    }

    public int swJvmUIDLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getSwJvmUID(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getSwJvmUID(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String swJvmUID() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int hwHardwareUIDId() {
        return 300;
    }

    public static String hwHardwareUIDCharacterEncoding() {
        return "UTF-8";
    }

    public static String hwHardwareUIDMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int hwHardwareUIDHeaderLength() {
        return 4;
    }

    public int hwHardwareUIDLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getHwHardwareUID(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getHwHardwareUID(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String hwHardwareUID() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int modelConfigClassNameId() {
        return 400;
    }

    public static String modelConfigClassNameCharacterEncoding() {
        return "UTF-8";
    }

    public static String modelConfigClassNameMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int modelConfigClassNameHeaderLength() {
        return 4;
    }

    public int modelConfigClassNameLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getModelConfigClassName(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getModelConfigClassName(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String modelConfigClassName() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public static int modelConfigJsonId() {
        return 401;
    }

    public static String modelConfigJsonCharacterEncoding() {
        return "UTF-8";
    }

    public static String modelConfigJsonMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
        }
        return "";
    }

    public static int modelConfigJsonHeaderLength() {
        return 4;
    }

    public int modelConfigJsonLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
    }

    public int getModelConfigJson(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getModelConfigJson(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public String modelConfigJson() {
        String value;
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        try {
            value = new String(tmp, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return value;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[StaticInfo](sbeTemplateId=");
        builder.append(1);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.actingVersion != 0) {
            builder.append(this.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 40) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(40);
        builder.append("):");
        builder.append("time=");
        builder.append(this.time());
        builder.append('|');
        builder.append("fieldsPresent=");
        builder.append(this.fieldsPresent());
        builder.append('|');
        builder.append("hwJvmProcessors=");
        builder.append(this.hwJvmProcessors());
        builder.append('|');
        builder.append("hwNumDevices=");
        builder.append(this.hwNumDevices());
        builder.append('|');
        builder.append("hwJvmMaxMemory=");
        builder.append(this.hwJvmMaxMemory());
        builder.append('|');
        builder.append("hwOffheapMaxMemory=");
        builder.append(this.hwOffheapMaxMemory());
        builder.append('|');
        builder.append("modelNumLayers=");
        builder.append(this.modelNumLayers());
        builder.append('|');
        builder.append("modelNumParams=");
        builder.append(this.modelNumParams());
        builder.append('|');
        builder.append("hwDeviceInfoGroup=[");
        HwDeviceInfoGroupDecoder hwDeviceInfoGroup = this.hwDeviceInfoGroup();
        if (hwDeviceInfoGroup.count() > 0) {
            while (hwDeviceInfoGroup.hasNext()) {
                hwDeviceInfoGroup.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("swEnvironmentInfo=[");
        SwEnvironmentInfoDecoder swEnvironmentInfo = this.swEnvironmentInfo();
        if (swEnvironmentInfo.count() > 0) {
            while (swEnvironmentInfo.hasNext()) {
                swEnvironmentInfo.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("modelParamNames=[");
        ModelParamNamesDecoder modelParamNames = this.modelParamNames();
        if (modelParamNames.count() > 0) {
            while (modelParamNames.hasNext()) {
                modelParamNames.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append('|');
        builder.append("sessionID=");
        builder.append(this.sessionID());
        builder.append('|');
        builder.append("typeID=");
        builder.append(this.typeID());
        builder.append('|');
        builder.append("workerID=");
        builder.append(this.workerID());
        builder.append('|');
        builder.append("swArch=");
        builder.append(this.swArch());
        builder.append('|');
        builder.append("swOsName=");
        builder.append(this.swOsName());
        builder.append('|');
        builder.append("swJvmName=");
        builder.append(this.swJvmName());
        builder.append('|');
        builder.append("swJvmVersion=");
        builder.append(this.swJvmVersion());
        builder.append('|');
        builder.append("swJvmSpecVersion=");
        builder.append(this.swJvmSpecVersion());
        builder.append('|');
        builder.append("swNd4jBackendClass=");
        builder.append(this.swNd4jBackendClass());
        builder.append('|');
        builder.append("swNd4jDataTypeName=");
        builder.append(this.swNd4jDataTypeName());
        builder.append('|');
        builder.append("swHostName=");
        builder.append(this.swHostName());
        builder.append('|');
        builder.append("swJvmUID=");
        builder.append(this.swJvmUID());
        builder.append('|');
        builder.append("hwHardwareUID=");
        builder.append(this.hwHardwareUID());
        builder.append('|');
        builder.append("modelConfigClassName=");
        builder.append(this.modelConfigClassName());
        builder.append('|');
        builder.append("modelConfigJson=");
        builder.append(this.modelConfigJson());
        this.limit(originalLimit);
        return builder;
    }

    public static class ModelParamNamesDecoder
    implements Iterable<ModelParamNamesDecoder>,
    Iterator<ModelParamNamesDecoder> {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
        private StaticInfoDecoder parentMessage;
        private DirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(StaticInfoDecoder parentMessage, DirectBuffer buffer) {
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.blockLength = this.dimensions.blockLength();
            this.count = this.dimensions.numInGroup();
            this.index = -1;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<ModelParamNamesDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public ModelParamNamesDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int modelParamNamesId() {
            return 53;
        }

        public static String modelParamNamesCharacterEncoding() {
            return "UTF-8";
        }

        public static String modelParamNamesMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int modelParamNamesHeaderLength() {
            return 4;
        }

        public int modelParamNamesLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int getModelParamNames(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getModelParamNames(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public String modelParamNames() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("modelParamNames=");
            builder.append(this.modelParamNames());
            builder.append(')');
            return builder;
        }
    }

    public static class SwEnvironmentInfoDecoder
    implements Iterable<SwEnvironmentInfoDecoder>,
    Iterator<SwEnvironmentInfoDecoder> {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
        private StaticInfoDecoder parentMessage;
        private DirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(StaticInfoDecoder parentMessage, DirectBuffer buffer) {
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.blockLength = this.dimensions.blockLength();
            this.count = this.dimensions.numInGroup();
            this.index = -1;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 0;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<SwEnvironmentInfoDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public SwEnvironmentInfoDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int envKeyId() {
            return 51;
        }

        public static String envKeyCharacterEncoding() {
            return "UTF-8";
        }

        public static String envKeyMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int envKeyHeaderLength() {
            return 4;
        }

        public int envKeyLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int getEnvKey(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getEnvKey(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public String envKey() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public static int envValueId() {
            return 52;
        }

        public static String envValueCharacterEncoding() {
            return "UTF-8";
        }

        public static String envValueMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int envValueHeaderLength() {
            return 4;
        }

        public int envValueLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int getEnvValue(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getEnvValue(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public String envValue() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("envKey=");
            builder.append(this.envKey());
            builder.append('|');
            builder.append("envValue=");
            builder.append(this.envValue());
            builder.append(')');
            return builder;
        }
    }

    public static class HwDeviceInfoGroupDecoder
    implements Iterable<HwDeviceInfoGroupDecoder>,
    Iterator<HwDeviceInfoGroupDecoder> {
        private static final int HEADER_SIZE = 4;
        private final GroupSizeEncodingDecoder dimensions = new GroupSizeEncodingDecoder();
        private StaticInfoDecoder parentMessage;
        private DirectBuffer buffer;
        private int blockLength;
        private int actingVersion;
        private int count;
        private int index;
        private int offset;

        public void wrap(StaticInfoDecoder parentMessage, DirectBuffer buffer) {
            this.parentMessage = parentMessage;
            this.buffer = buffer;
            this.dimensions.wrap(buffer, parentMessage.limit());
            this.blockLength = this.dimensions.blockLength();
            this.count = this.dimensions.numInGroup();
            this.index = -1;
            parentMessage.limit(parentMessage.limit() + 4);
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 8;
        }

        public int actingBlockLength() {
            return this.blockLength;
        }

        public int count() {
            return this.count;
        }

        @Override
        public Iterator<HwDeviceInfoGroupDecoder> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index + 1 < this.count;
        }

        @Override
        public HwDeviceInfoGroupDecoder next() {
            if (this.index + 1 >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + this.blockLength);
            ++this.index;
            return this;
        }

        public static int deviceMemoryMaxId() {
            return 10;
        }

        public static String deviceMemoryMaxMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static long deviceMemoryMaxNullValue() {
            return Long.MIN_VALUE;
        }

        public static long deviceMemoryMaxMinValue() {
            return -9223372036854775807L;
        }

        public static long deviceMemoryMaxMaxValue() {
            return Long.MAX_VALUE;
        }

        public long deviceMemoryMax() {
            return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
        }

        public static int deviceDescriptionId() {
            return 50;
        }

        public static String deviceDescriptionCharacterEncoding() {
            return "UTF-8";
        }

        public static String deviceDescriptionMetaAttribute(MetaAttribute metaAttribute) {
            switch (metaAttribute) {
                case EPOCH: {
                    return "unix";
                }
                case TIME_UNIT: {
                    return "nanosecond";
                }
                case SEMANTIC_TYPE: {
                    return "";
                }
            }
            return "";
        }

        public static int deviceDescriptionHeaderLength() {
            return 4;
        }

        public int deviceDescriptionLength() {
            int limit = this.parentMessage.limit();
            return (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
        }

        public int getDeviceDescription(MutableDirectBuffer dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public int getDeviceDescription(byte[] dst, int dstOffset, int length) {
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            int bytesCopied = Math.min(length, dataLength);
            this.parentMessage.limit(limit + 4 + dataLength);
            this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
            return bytesCopied;
        }

        public String deviceDescription() {
            String value;
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            int dataLength = (int)((long)this.buffer.getInt(limit, ByteOrder.LITTLE_ENDIAN) & 0xFFFFFFFFL);
            this.parentMessage.limit(limit + 4 + dataLength);
            byte[] tmp = new byte[dataLength];
            this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
            try {
                value = new String(tmp, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            return value;
        }

        public String toString() {
            return this.appendTo(new StringBuilder(100)).toString();
        }

        public StringBuilder appendTo(StringBuilder builder) {
            builder.append('(');
            builder.append("deviceMemoryMax=");
            builder.append(this.deviceMemoryMax());
            builder.append('|');
            builder.append("deviceDescription=");
            builder.append(this.deviceDescription());
            builder.append(')');
            return builder;
        }
    }
}

