/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.parallelism.parameterserver;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.parallelism.ParallelWrapper;
import org.deeplearning4j.parallelism.trainer.DefaultTrainer;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.parameterserver.client.ParameterServerClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterServerTrainer
extends DefaultTrainer {
    private static final Logger log = LoggerFactory.getLogger(ParameterServerTrainer.class);
    private ParameterServerClient parameterServerClient;

    public void feedMultiDataSet(@NonNull MultiDataSet dataSet, long time) {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        if (!(this.getModel() instanceof ComputationGraph)) {
            throw new IllegalArgumentException("MultiLayerNetworks can't fit multi datasets");
        }
        ComputationGraph computationGraph = (ComputationGraph)this.getModel();
        computationGraph.fit(dataSet);
        log.info("Sending parameters");
        this.parameterServerClient.pushNDArray(this.getModel().params());
    }

    public void feedDataSet(@NonNull DataSet dataSet, long time) {
        if (dataSet == null) {
            throw new NullPointerException("dataSet is marked non-null but is null");
        }
        if (this.getModel() instanceof ComputationGraph) {
            ComputationGraph computationGraph = (ComputationGraph)this.getModel();
            computationGraph.fit(dataSet);
        } else {
            MultiLayerNetwork multiLayerNetwork = (MultiLayerNetwork)this.getModel();
            log.info("Calling fit on multi layer network");
            multiLayerNetwork.fit(dataSet);
        }
        log.info("About to send params in");
        this.parameterServerClient.pushNDArray(this.getModel().params());
        log.info("Sent params");
    }

    public Model getModel() {
        return super.getModel();
    }

    public void updateModel(@NonNull Model model) {
        if (model == null) {
            throw new NullPointerException("model is marked non-null but is null");
        }
        super.updateModel(model);
    }

    public static ParameterServerTrainerBuilder builder() {
        return new ParameterServerTrainerBuilder();
    }

    public ParameterServerTrainer(ParameterServerClient parameterServerClient) {
        this.parameterServerClient = parameterServerClient;
    }

    public ParameterServerTrainer() {
    }

    public static class ParameterServerTrainerBuilder
    extends DefaultTrainer.DefaultTrainerBuilder {
        private ParameterServerClient parameterServerClient;

        public ParameterServerTrainerBuilder originalModel(Model originalModel) {
            return (ParameterServerTrainerBuilder)super.originalModel(originalModel);
        }

        public ParameterServerTrainerBuilder replicatedModel(Model replicatedModel) {
            return (ParameterServerTrainerBuilder)super.replicatedModel(replicatedModel);
        }

        public ParameterServerTrainerBuilder queue(LinkedBlockingQueue<DataSet> queue) {
            return (ParameterServerTrainerBuilder)super.queue(queue);
        }

        public ParameterServerTrainerBuilder queueMDS(LinkedBlockingQueue<MultiDataSet> queueMDS) {
            return (ParameterServerTrainerBuilder)super.queueMDS(queueMDS);
        }

        public ParameterServerTrainerBuilder running(AtomicInteger running) {
            return (ParameterServerTrainerBuilder)super.running(running);
        }

        public ParameterServerTrainerBuilder threadId(int threadId) {
            return (ParameterServerTrainerBuilder)super.threadId(threadId);
        }

        public ParameterServerTrainerBuilder shouldUpdate(AtomicBoolean shouldUpdate) {
            return (ParameterServerTrainerBuilder)super.shouldUpdate(shouldUpdate);
        }

        public ParameterServerTrainerBuilder shouldStop(AtomicBoolean shouldStop) {
            return (ParameterServerTrainerBuilder)super.shouldStop(shouldStop);
        }

        public ParameterServerTrainerBuilder thrownException(Exception thrownException) {
            return (ParameterServerTrainerBuilder)super.thrownException(thrownException);
        }

        public ParameterServerTrainerBuilder useMDS(boolean useMDS) {
            return (ParameterServerTrainerBuilder)super.useMDS(useMDS);
        }

        public ParameterServerTrainerBuilder onRootModel(boolean onRootModel) {
            return (ParameterServerTrainerBuilder)super.onRootModel(onRootModel);
        }

        public ParameterServerTrainerBuilder parallelWrapper(ParallelWrapper parallelWrapper) {
            return (ParameterServerTrainerBuilder)super.parallelWrapper(parallelWrapper);
        }

        public ParameterServerTrainerBuilder averagingFrequency(int frequency) {
            return (ParameterServerTrainerBuilder)super.averagingFrequency(frequency);
        }

        ParameterServerTrainerBuilder() {
        }

        public ParameterServerTrainerBuilder parameterServerClient(ParameterServerClient parameterServerClient) {
            this.parameterServerClient = parameterServerClient;
            return this;
        }

        public ParameterServerTrainer build() {
            return new ParameterServerTrainer(this.parameterServerClient);
        }

        public String toString() {
            return "ParameterServerTrainer.ParameterServerTrainerBuilder(parameterServerClient=" + this.parameterServerClient + ")";
        }
    }
}

