/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.solvers.accumulation;

import lombok.NonNull;
import org.deeplearning4j.optimize.solvers.accumulation.GradientsAccumulator;
import org.deeplearning4j.optimize.solvers.accumulation.MessageHandler;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class LocalHandler
implements MessageHandler {
    protected transient GradientsAccumulator accumulator;

    @Override
    public void initialize(@NonNull GradientsAccumulator accumulator) {
        if (accumulator == null) {
            throw new NullPointerException("accumulator is marked non-null but is null");
        }
        this.accumulator = accumulator;
    }

    @Override
    public boolean broadcastUpdates(INDArray updates, int iterationNumber, int epochNumber) {
        this.accumulator.receiveUpdate(updates);
        updates.assign((Number)0.0);
        Nd4j.getExecutioner().commit();
        return true;
    }
}

