/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.eval.Evaluation;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.api.layers.IOutputLayer;
import org.deeplearning4j.nn.conf.CNN2DFormat;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.util.ConvolutionUtils;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.lossfunctions.ILossFunction;

public class CnnLossLayer
extends BaseLayer<org.deeplearning4j.nn.conf.layers.CnnLossLayer>
implements IOutputLayer {
    protected INDArray labels;

    public CnnLossLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        if (this.input.rank() != 4) {
            throw new UnsupportedOperationException("Input is not rank 4. Got input with rank " + this.input.rank() + " " + this.layerId() + " with shape " + Arrays.toString(this.input.shape()) + " - expected shape " + ((org.deeplearning4j.nn.conf.layers.CnnLossLayer)this.layerConf()).getFormat().dimensionNames());
        }
        if (this.labels == null) {
            throw new IllegalStateException("Labels are not set (null)");
        }
        Preconditions.checkState((boolean)this.input.equalShapes(this.labels), (String)"Input and label arrays do not have same shape: %ndShape vs. %ndShape", (Object)this.input, (Object)this.labels);
        CNN2DFormat format = ((org.deeplearning4j.nn.conf.layers.CnnLossLayer)this.layerConf()).getFormat();
        INDArray input2d = ConvolutionUtils.reshape4dTo2d(this.input, format, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray labels2d = ConvolutionUtils.reshape4dTo2d(this.labels, format, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray maskReshaped = ConvolutionUtils.reshapeMaskIfRequired(this.maskArray, this.input, format, workspaceMgr, ArrayType.FF_WORKING_MEM);
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.CnnLossLayer)this.layerConf()).getLossFn();
        INDArray delta2d = lossFunction.computeGradient(labels2d, input2d.dup(input2d.ordering()), ((org.deeplearning4j.nn.conf.layers.CnnLossLayer)this.layerConf()).getActivationFn(), maskReshaped);
        delta2d = workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, delta2d);
        INDArray delta4d = ConvolutionUtils.reshape2dTo4d(delta2d, this.input.shape(), format, workspaceMgr, ArrayType.ACTIVATION_GRAD);
        DefaultGradient gradient = new DefaultGradient();
        return new Pair((Object)gradient, (Object)delta4d);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double f1Score(DataSet data) {
        return 0.0;
    }

    @Override
    public double f1Score(INDArray examples, INDArray labels) {
        INDArray out = this.activate(examples, false, null);
        Evaluation eval = new Evaluation();
        eval.evalTimeSeries(labels, out, this.maskArray);
        return eval.f1();
    }

    @Override
    public int numLabels() {
        return (int)this.labels.size(1);
    }

    @Override
    public void fit(DataSetIterator iter) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int[] predict(INDArray examples) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public List<String> predict(DataSet dataSet) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void fit(INDArray examples, INDArray labels) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void fit(DataSet data) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void fit(INDArray examples, int[] labels) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        if (this.input.rank() != 4) {
            throw new UnsupportedOperationException("Input must be rank 4 with shape " + ((org.deeplearning4j.nn.conf.layers.CnnLossLayer)this.layerConf()).getFormat().dimensionNames() + ". Got input with rank " + this.input.rank() + " " + this.layerId());
        }
        CNN2DFormat format = ((org.deeplearning4j.nn.conf.layers.CnnLossLayer)this.layerConf()).getFormat();
        INDArray in = workspaceMgr.dup(ArrayType.ACTIVATIONS, this.input, this.input.ordering());
        INDArray input2d = ConvolutionUtils.reshape4dTo2d(in, format, workspaceMgr, ArrayType.ACTIVATIONS);
        INDArray out2d = ((org.deeplearning4j.nn.conf.layers.CnnLossLayer)this.layerConf()).getActivationFn().getActivation(input2d, training);
        return ConvolutionUtils.reshape2dTo4d(out2d, this.input.shape(), format, workspaceMgr, ArrayType.ACTIVATIONS);
    }

    @Override
    public void setMaskArray(INDArray maskArray) {
        this.maskArray = maskArray;
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        this.maskArray = maskArray;
        return null;
    }

    @Override
    public boolean needsLabels() {
        return true;
    }

    @Override
    public double computeScore(double fullNetRegTerm, boolean training, LayerWorkspaceMgr workspaceMgr) {
        INDArray input2d = ConvolutionUtils.reshape4dTo2d(this.input, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray labels2d = ConvolutionUtils.reshape4dTo2d(this.labels, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray maskReshaped = ConvolutionUtils.reshapeMaskIfRequired(this.maskArray, this.input, ((org.deeplearning4j.nn.conf.layers.CnnLossLayer)this.layerConf()).getFormat(), workspaceMgr, ArrayType.FF_WORKING_MEM);
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.CnnLossLayer)this.layerConf()).getLossFn();
        double score = lossFunction.computeScore(labels2d, input2d.dup(), ((org.deeplearning4j.nn.conf.layers.CnnLossLayer)this.layerConf()).getActivationFn(), maskReshaped, false);
        score /= (double)this.getInputMiniBatchSize();
        this.score = score += fullNetRegTerm;
        return score;
    }

    @Override
    public INDArray computeScoreForExamples(double fullNetRegTerm, LayerWorkspaceMgr workspaceMgr) {
        if (this.input == null || this.labels == null) {
            throw new IllegalStateException("Cannot calculate score without input and labels " + this.layerId());
        }
        CNN2DFormat format = ((org.deeplearning4j.nn.conf.layers.CnnLossLayer)this.layerConf()).getFormat();
        INDArray input2d = ConvolutionUtils.reshape4dTo2d(this.input, format, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray labels2d = ConvolutionUtils.reshape4dTo2d(this.labels, format, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray maskReshaped = ConvolutionUtils.reshapeMaskIfRequired(this.maskArray, this.input, format, workspaceMgr, ArrayType.FF_WORKING_MEM);
        ILossFunction lossFunction = ((org.deeplearning4j.nn.conf.layers.CnnLossLayer)this.layerConf()).getLossFn();
        INDArray scoreArray = lossFunction.computeScoreArray(labels2d, input2d, ((org.deeplearning4j.nn.conf.layers.CnnLossLayer)this.layerConf()).getActivationFn(), maskReshaped);
        long[] newShape = (long[])this.input.shape().clone();
        newShape[1] = 1L;
        INDArray scoreArrayTs = ConvolutionUtils.reshape2dTo4d(scoreArray, newShape, format, workspaceMgr, ArrayType.FF_WORKING_MEM);
        INDArray summedScores = scoreArrayTs.sum(new int[]{1, 2, 3}).reshape(scoreArrayTs.size(0), 1L);
        if (fullNetRegTerm != 0.0) {
            summedScores.addi((Number)fullNetRegTerm);
        }
        return workspaceMgr.leverageTo(ArrayType.ACTIVATIONS, summedScores);
    }

    @Override
    public void setLabels(INDArray labels) {
        this.labels = labels;
    }

    @Override
    public INDArray getLabels() {
        return this.labels;
    }
}

