/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.api.TrainingConfig;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.LayerHelper;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public abstract class AbstractLayer<LayerConfT extends Layer>
implements org.deeplearning4j.nn.api.Layer {
    protected INDArray input;
    protected INDArray preOutput;
    protected NeuralNetConfiguration conf;
    protected boolean dropoutApplied = false;
    protected Collection<TrainingListener> trainingListeners = new ArrayList<TrainingListener>();
    protected int index = 0;
    protected INDArray maskArray;
    protected MaskState maskState;
    protected CacheMode cacheMode = CacheMode.NONE;
    protected boolean inputModificationAllowed = false;
    protected DataType dataType;
    protected int iterationCount;
    protected int epochCount;

    public AbstractLayer(NeuralNetConfiguration conf, DataType dataType) {
        this.conf = conf;
        if (conf != null) {
            this.cacheMode = conf.getCacheMode();
        }
        this.dataType = dataType;
    }

    @Override
    public void setCacheMode(CacheMode mode) {
        if (mode == null) {
            mode = CacheMode.NONE;
        }
        this.cacheMode = mode;
    }

    public LayerConfT layerConf() {
        return (LayerConfT)this.conf.getLayer();
    }

    @Override
    public TrainingConfig getConfig() {
        return this.conf.getLayer();
    }

    protected String layerId() {
        String name = this.conf().getLayer().getLayerName();
        return "(layer name: " + (name == null ? "\"\"" : name) + ", layer index: " + this.index + ", layer type: " + this.getClass().getSimpleName() + ")";
    }

    public INDArray getInput() {
        return this.input;
    }

    @Override
    public int getEpochCount() {
        return this.epochCount;
    }

    @Override
    public void setEpochCount(int epochCount) {
        this.epochCount = epochCount;
    }

    @Override
    public void init() {
    }

    @Override
    public void setInput(INDArray input, LayerWorkspaceMgr workspaceMgr) {
        this.input = workspaceMgr.leverageTo(ArrayType.INPUT, input);
        this.dropoutApplied = false;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Collection<TrainingListener> getListeners() {
        return this.trainingListeners;
    }

    @Override
    public void setListeners(Collection<TrainingListener> listeners) {
        this.trainingListeners = listeners != null ? listeners : new ArrayList();
    }

    @Override
    public void addListeners(TrainingListener ... listeners) {
        if (this.trainingListeners == null) {
            this.setListeners(listeners);
            return;
        }
        Collections.addAll(this.trainingListeners, listeners);
    }

    @Override
    public void setListeners(TrainingListener ... listeners) {
        this.setListeners(Arrays.asList(listeners));
    }

    @Override
    public void computeGradientAndScore(LayerWorkspaceMgr workspaceMgr) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void update(Gradient gradient) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(INDArray gradient, String paramType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConvexOptimizer getOptimizer() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setConf(NeuralNetConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setParam(String key, INDArray val) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setParams(INDArray params) {
        if (params != null) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    protected void setParams(INDArray params, char order) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setParamsViewArray(INDArray params) {
        if (params != null) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    @Override
    public INDArray getGradientsViewArray() {
        return null;
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray gradients) {
        if (gradients != null) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    @Override
    public void setParamTable(Map<String, INDArray> paramTable) {
        if (paramTable != null && !paramTable.isEmpty()) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    @Override
    public Map<String, INDArray> paramTable() {
        return this.paramTable(false);
    }

    @Override
    public Map<String, INDArray> paramTable(boolean backpropParamsOnly) {
        return Collections.emptyMap();
    }

    protected void applyMask(INDArray to) {
        to.muliColumnVector(this.maskArray.castTo(to.dataType()));
    }

    @Override
    public INDArray activate(INDArray input, boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.setInput(input, workspaceMgr);
        return this.activate(training, workspaceMgr);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public int batchSize() {
        return (int)this.input.size(0);
    }

    @Override
    public NeuralNetConfiguration conf() {
        return this.conf;
    }

    @Override
    public void clear() {
        this.input = null;
        this.maskArray = null;
        this.maskState = null;
        if (((Layer)this.layerConf()).getIDropout() != null) {
            ((Layer)this.layerConf()).getIDropout().clear();
        }
    }

    protected void applyDropOutIfNecessary(boolean training, LayerWorkspaceMgr workspaceMgr) {
        if (training && !this.dropoutApplied && ((Layer)this.layerConf()).getIDropout() != null) {
            INDArray result = this.inputModificationAllowed ? this.input : workspaceMgr.createUninitialized(ArrayType.INPUT, this.input.dataType(), this.input.shape(), this.input.ordering());
            this.input = ((Layer)this.layerConf()).getIDropout().applyDropout(this.input, result, this.getIterationCount(), this.getEpochCount(), workspaceMgr);
            this.dropoutApplied = true;
        }
    }

    protected INDArray backpropDropOutIfPresent(INDArray epsilon) {
        if (((Layer)this.layerConf()).getIDropout() != null) {
            ((Layer)this.layerConf()).getIDropout().backprop(epsilon, epsilon, this.getIterationCount(), this.getEpochCount());
        }
        return epsilon;
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.FEED_FORWARD;
    }

    @Override
    public long numParams() {
        return 0L;
    }

    @Override
    public long numParams(boolean backwards) {
        return this.numParams();
    }

    @Override
    public void fit(INDArray input, LayerWorkspaceMgr workspaceMgr) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        return new Pair((Object)this.gradient(), (Object)this.score());
    }

    @Override
    public INDArray input() {
        return this.input;
    }

    @Override
    public void setInputMiniBatchSize(int size) {
    }

    @Override
    public int getInputMiniBatchSize() {
        return (int)this.input.size(0);
    }

    @Override
    public void setMaskArray(INDArray maskArray) {
        this.maskArray = maskArray;
    }

    @Override
    public INDArray getMaskArray() {
        return this.maskArray;
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        this.maskArray = maskArray;
        this.maskState = currentMaskState;
        return new Pair((Object)maskArray, (Object)currentMaskState);
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported for this layer, or should be overridden for layers requiring it");
    }

    @Override
    public void fit() {
        throw new UnsupportedOperationException("Not supported for this layer, or should be overridden for layers requiring it");
    }

    @Override
    public double score() {
        throw new UnsupportedOperationException("Not supported for this layer, or should be overridden for layers requiring it");
    }

    @Override
    public void applyConstraints(int iteration, int epoch) {
        if (((Layer)this.layerConf()).getConstraints() != null) {
            for (LayerConstraint lc : ((Layer)this.layerConf()).getConstraints()) {
                lc.applyConstraint(this, iteration, epoch);
            }
        }
    }

    public void assertInputSet(boolean backprop) {
        if (this.input == null) {
            if (backprop) {
                throw new IllegalStateException("Cannot perform backprop in layer " + this.getClass().getSimpleName() + ": layer input field is not set");
            }
            throw new IllegalStateException("Cannot perform forward pass in layer " + this.getClass().getSimpleName() + ": layer input field is not set");
        }
    }

    @Override
    public void allowInputModification(boolean allow) {
        this.inputModificationAllowed = allow;
    }

    @Override
    public LayerHelper getHelper() {
        return null;
    }

    @Override
    public boolean updaterDivideByMinibatch(String paramName) {
        return true;
    }

    @Override
    public void close() {
    }

    public INDArray getPreOutput() {
        return this.preOutput;
    }

    public NeuralNetConfiguration getConf() {
        return this.conf;
    }

    public boolean isDropoutApplied() {
        return this.dropoutApplied;
    }

    public Collection<TrainingListener> getTrainingListeners() {
        return this.trainingListeners;
    }

    public MaskState getMaskState() {
        return this.maskState;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public boolean isInputModificationAllowed() {
        return this.inputModificationAllowed;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public int getIterationCount() {
        return this.iterationCount;
    }

    public void setPreOutput(INDArray preOutput) {
        this.preOutput = preOutput;
    }

    public void setDropoutApplied(boolean dropoutApplied) {
        this.dropoutApplied = dropoutApplied;
    }

    public void setTrainingListeners(Collection<TrainingListener> trainingListeners) {
        this.trainingListeners = trainingListeners;
    }

    public void setMaskState(MaskState maskState) {
        this.maskState = maskState;
    }

    public void setInputModificationAllowed(boolean inputModificationAllowed) {
        this.inputModificationAllowed = inputModificationAllowed;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractLayer)) {
            return false;
        }
        AbstractLayer other = (AbstractLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDropoutApplied() != other.isDropoutApplied()) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.isInputModificationAllowed() != other.isInputModificationAllowed()) {
            return false;
        }
        if (this.getIterationCount() != other.getIterationCount()) {
            return false;
        }
        if (this.getEpochCount() != other.getEpochCount()) {
            return false;
        }
        INDArray this$input = this.getInput();
        INDArray other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        INDArray this$preOutput = this.getPreOutput();
        INDArray other$preOutput = other.getPreOutput();
        if (this$preOutput == null ? other$preOutput != null : !this$preOutput.equals(other$preOutput)) {
            return false;
        }
        NeuralNetConfiguration this$conf = this.getConf();
        NeuralNetConfiguration other$conf = other.getConf();
        if (this$conf == null ? other$conf != null : !((Object)this$conf).equals(other$conf)) {
            return false;
        }
        Collection<TrainingListener> this$trainingListeners = this.getTrainingListeners();
        Collection<TrainingListener> other$trainingListeners = other.getTrainingListeners();
        if (this$trainingListeners == null ? other$trainingListeners != null : !((Object)this$trainingListeners).equals(other$trainingListeners)) {
            return false;
        }
        INDArray this$maskArray = this.getMaskArray();
        INDArray other$maskArray = other.getMaskArray();
        if (this$maskArray == null ? other$maskArray != null : !this$maskArray.equals(other$maskArray)) {
            return false;
        }
        MaskState this$maskState = this.getMaskState();
        MaskState other$maskState = other.getMaskState();
        if (this$maskState == null ? other$maskState != null : !((Object)((Object)this$maskState)).equals((Object)other$maskState)) {
            return false;
        }
        CacheMode this$cacheMode = this.getCacheMode();
        CacheMode other$cacheMode = other.getCacheMode();
        if (this$cacheMode == null ? other$cacheMode != null : !((Object)((Object)this$cacheMode)).equals((Object)other$cacheMode)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        return !(this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractLayer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDropoutApplied() ? 79 : 97);
        result = result * 59 + this.getIndex();
        result = result * 59 + (this.isInputModificationAllowed() ? 79 : 97);
        result = result * 59 + this.getIterationCount();
        result = result * 59 + this.getEpochCount();
        INDArray $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        INDArray $preOutput = this.getPreOutput();
        result = result * 59 + ($preOutput == null ? 43 : $preOutput.hashCode());
        NeuralNetConfiguration $conf = this.getConf();
        result = result * 59 + ($conf == null ? 43 : ((Object)$conf).hashCode());
        Collection<TrainingListener> $trainingListeners = this.getTrainingListeners();
        result = result * 59 + ($trainingListeners == null ? 43 : ((Object)$trainingListeners).hashCode());
        INDArray $maskArray = this.getMaskArray();
        result = result * 59 + ($maskArray == null ? 43 : $maskArray.hashCode());
        MaskState $maskState = this.getMaskState();
        result = result * 59 + ($maskState == null ? 43 : ((Object)((Object)$maskState)).hashCode());
        CacheMode $cacheMode = this.getCacheMode();
        result = result * 59 + ($cacheMode == null ? 43 : ((Object)((Object)$cacheMode)).hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractLayer(input=" + this.getInput() + ", preOutput=" + this.getPreOutput() + ", conf=" + this.getConf() + ", dropoutApplied=" + this.isDropoutApplied() + ", trainingListeners=" + this.getTrainingListeners() + ", index=" + this.getIndex() + ", maskArray=" + this.getMaskArray() + ", maskState=" + (Object)((Object)this.getMaskState()) + ", cacheMode=" + (Object)((Object)this.getCacheMode()) + ", inputModificationAllowed=" + this.isInputModificationAllowed() + ", dataType=" + this.getDataType() + ", iterationCount=" + this.getIterationCount() + ", epochCount=" + this.getEpochCount() + ")";
    }

    public AbstractLayer() {
    }
}

