/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.ocnn;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.BaseOutputLayer;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.layers.ocnn.OCNNParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationIdentity;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.regularization.Regularization;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.shade.jackson.annotation.JsonCreator;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"lossFn"})
public class OCNNOutputLayer
extends BaseOutputLayer {
    private int hiddenSize;
    private double nu = 0.04;
    private int windowSize = 10000;
    private double initialRValue = 0.1;
    private boolean configureR = true;
    private int lastEpochSinceRUpdated = 0;

    public OCNNOutputLayer(Builder builder) {
        super(builder);
        this.hiddenSize = builder.hiddenLayerSize;
        this.nu = builder.nu;
        this.activationFn = builder.activation;
        this.windowSize = builder.windowSize;
        this.initialRValue = builder.initialRValue;
        this.configureR = builder.configureR;
    }

    @JsonCreator
    public OCNNOutputLayer(@JsonProperty(value="hiddenSize") int hiddenSize, @JsonProperty(value="nu") double nu, @JsonProperty(value="activation") IActivation activation, @JsonProperty(value="windowSize") int windowSize, @JsonProperty(value="initialRValue") double initialRValue, @JsonProperty(value="configureR") boolean configureR) {
        this.hiddenSize = hiddenSize;
        this.nu = nu;
        this.activationFn = activation;
        this.windowSize = windowSize;
        this.initialRValue = initialRValue;
        this.configureR = configureR;
    }

    @Override
    public ILossFunction getLossFn() {
        return this.lossFn;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> trainingListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        LayerValidation.assertNInNOutSet("OCNNOutputLayer", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        org.deeplearning4j.nn.layers.ocnn.OCNNOutputLayer ret = new org.deeplearning4j.nn.layers.ocnn.OCNNOutputLayer(conf, networkDataType);
        ret.setListeners(trainingListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        ret.setActivation(this.activationFn);
        if (this.lastEpochSinceRUpdated == 0 && this.configureR) {
            paramTable.get("r").putScalar(0L, this.initialRValue);
        }
        return ret;
    }

    @Override
    public long getNOut() {
        return 1L;
    }

    @Override
    public ParamInitializer initializer() {
        return OCNNParamInitializer.getInstance();
    }

    @Override
    public List<Regularization> getRegularizationByParam(String paramName) {
        return null;
    }

    public int getHiddenSize() {
        return this.hiddenSize;
    }

    public double getNu() {
        return this.nu;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public double getInitialRValue() {
        return this.initialRValue;
    }

    public boolean isConfigureR() {
        return this.configureR;
    }

    public int getLastEpochSinceRUpdated() {
        return this.lastEpochSinceRUpdated;
    }

    public void setHiddenSize(int hiddenSize) {
        this.hiddenSize = hiddenSize;
    }

    public void setNu(double nu) {
        this.nu = nu;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    public void setInitialRValue(double initialRValue) {
        this.initialRValue = initialRValue;
    }

    public void setConfigureR(boolean configureR) {
        this.configureR = configureR;
    }

    public void setLastEpochSinceRUpdated(int lastEpochSinceRUpdated) {
        this.lastEpochSinceRUpdated = lastEpochSinceRUpdated;
    }

    public OCNNOutputLayer() {
    }

    @Override
    public String toString() {
        return "OCNNOutputLayer(super=" + super.toString() + ", hiddenSize=" + this.getHiddenSize() + ", nu=" + this.getNu() + ", windowSize=" + this.getWindowSize() + ", initialRValue=" + this.getInitialRValue() + ", configureR=" + this.isConfigureR() + ", lastEpochSinceRUpdated=" + this.getLastEpochSinceRUpdated() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OCNNOutputLayer)) {
            return false;
        }
        OCNNOutputLayer other = (OCNNOutputLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getHiddenSize() != other.getHiddenSize()) {
            return false;
        }
        if (Double.compare(this.getNu(), other.getNu()) != 0) {
            return false;
        }
        if (this.getWindowSize() != other.getWindowSize()) {
            return false;
        }
        if (Double.compare(this.getInitialRValue(), other.getInitialRValue()) != 0) {
            return false;
        }
        if (this.isConfigureR() != other.isConfigureR()) {
            return false;
        }
        return this.getLastEpochSinceRUpdated() == other.getLastEpochSinceRUpdated();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OCNNOutputLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getHiddenSize();
        long $nu = Double.doubleToLongBits(this.getNu());
        result = result * 59 + (int)($nu >>> 32 ^ $nu);
        result = result * 59 + this.getWindowSize();
        long $initialRValue = Double.doubleToLongBits(this.getInitialRValue());
        result = result * 59 + (int)($initialRValue >>> 32 ^ $initialRValue);
        result = result * 59 + (this.isConfigureR() ? 79 : 97);
        result = result * 59 + this.getLastEpochSinceRUpdated();
        return result;
    }

    public static class Builder
    extends BaseOutputLayer.Builder<Builder> {
        protected int hiddenLayerSize;
        protected double nu = 0.04;
        protected int windowSize = 10000;
        protected IActivation activation = new ActivationIdentity();
        protected double initialRValue = 0.1;
        protected boolean configureR = true;

        public Builder configureR(boolean configureR) {
            this.setConfigureR(configureR);
            return this;
        }

        public Builder initialRValue(double initialRValue) {
            this.setInitialRValue(initialRValue);
            return this;
        }

        public Builder windowSize(int windowSize) {
            this.setWindowSize(windowSize);
            return this;
        }

        public Builder nu(double nu) {
            this.setNu(nu);
            return this;
        }

        @Override
        public Builder activation(IActivation activation) {
            this.setActivation(activation);
            return this;
        }

        public Builder hiddenLayerSize(int hiddenLayerSize) {
            this.setHiddenLayerSize(hiddenLayerSize);
            return this;
        }

        @Override
        public Builder nOut(int nOut) {
            throw new UnsupportedOperationException("Unable to specify number of outputs with ocnn. Outputs are fixed to 1.");
        }

        @Override
        public void setNOut(long nOut) {
            throw new UnsupportedOperationException("Unable to specify number of outputs with ocnn. Outputs are fixed to 1.");
        }

        @Override
        public OCNNOutputLayer build() {
            return new OCNNOutputLayer(this);
        }

        public int getHiddenLayerSize() {
            return this.hiddenLayerSize;
        }

        public double getNu() {
            return this.nu;
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public IActivation getActivation() {
            return this.activation;
        }

        public double getInitialRValue() {
            return this.initialRValue;
        }

        public boolean isConfigureR() {
            return this.configureR;
        }

        public void setHiddenLayerSize(int hiddenLayerSize) {
            this.hiddenLayerSize = hiddenLayerSize;
        }

        public void setNu(double nu) {
            this.nu = nu;
        }

        public void setWindowSize(int windowSize) {
            this.windowSize = windowSize;
        }

        public void setActivation(IActivation activation) {
            this.activation = activation;
        }

        public void setInitialRValue(double initialRValue) {
            this.initialRValue = initialRValue;
        }

        public void setConfigureR(boolean configureR) {
            this.configureR = configureR;
        }
    }
}

