/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.api.TrainingConfig;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.dropout.Dropout;
import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.regularization.Regularization;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public abstract class Layer
implements TrainingConfig,
Serializable,
Cloneable {
    protected String layerName;
    protected IDropout iDropout;
    protected List<LayerConstraint> constraints;

    public Layer(Builder builder) {
        this.layerName = builder.layerName;
        this.iDropout = builder.iDropout;
    }

    protected void initializeConstraints(Builder<?> builder) {
        LayerConstraint c2;
        ArrayList<LayerConstraint> allConstraints = new ArrayList<LayerConstraint>();
        if (builder.allParamConstraints != null && !this.initializer().paramKeys(this).isEmpty()) {
            for (LayerConstraint c : builder.allParamConstraints) {
                c2 = c.clone();
                c2.setParams(new HashSet<String>(this.initializer().paramKeys(this)));
                allConstraints.add(c2);
            }
        }
        if (builder.weightConstraints != null && !this.initializer().weightKeys(this).isEmpty()) {
            for (LayerConstraint c : builder.weightConstraints) {
                c2 = c.clone();
                c2.setParams(new HashSet<String>(this.initializer().weightKeys(this)));
                allConstraints.add(c2);
            }
        }
        if (builder.biasConstraints != null && !this.initializer().biasKeys(this).isEmpty()) {
            for (LayerConstraint c : builder.biasConstraints) {
                c2 = c.clone();
                c2.setParams(new HashSet<String>(this.initializer().biasKeys(this)));
                allConstraints.add(c2);
            }
        }
        this.constraints = !allConstraints.isEmpty() ? allConstraints : null;
        this.iDropout = builder.iDropout;
    }

    public void resetLayerDefaultConfig() {
        this.iDropout = null;
        this.constraints = null;
    }

    public Layer clone() {
        try {
            Layer ret = (Layer)super.clone();
            for (Class<?> c = this.getClass(); c != Object.class; c = c.getSuperclass()) {
                Field[] fields;
                for (Field f : fields = c.getDeclaredFields()) {
                    INDArray toClone;
                    if (f.getType() != INDArray.class) continue;
                    f.setAccessible(true);
                    try {
                        toClone = (INDArray)f.get(this);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    if (toClone == null) continue;
                    try {
                        f.set(this, toClone.dup());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract org.deeplearning4j.nn.api.Layer instantiate(NeuralNetConfiguration var1, Collection<TrainingListener> var2, int var3, INDArray var4, boolean var5, DataType var6);

    public abstract ParamInitializer initializer();

    public abstract InputType getOutputType(int var1, InputType var2);

    public abstract void setNIn(InputType var1, boolean var2);

    public abstract InputPreProcessor getPreProcessorForInputType(InputType var1);

    @Override
    public abstract List<Regularization> getRegularizationByParam(String var1);

    @Override
    public abstract boolean isPretrainParam(String var1);

    @Override
    public IUpdater getUpdaterByParam(String paramName) {
        throw new UnsupportedOperationException("Not supported: all layers with parameters should override this method");
    }

    @Override
    public void setDataType(DataType dataType) {
    }

    public abstract LayerMemoryReport getMemoryReport(InputType var1);

    @Override
    public String getLayerName() {
        return this.layerName;
    }

    public IDropout getIDropout() {
        return this.iDropout;
    }

    public List<LayerConstraint> getConstraints() {
        return this.constraints;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public void setIDropout(IDropout iDropout) {
        this.iDropout = iDropout;
    }

    public void setConstraints(List<LayerConstraint> constraints) {
        this.constraints = constraints;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Layer)) {
            return false;
        }
        Layer other = (Layer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$layerName = this.getLayerName();
        String other$layerName = other.getLayerName();
        if (this$layerName == null ? other$layerName != null : !this$layerName.equals(other$layerName)) {
            return false;
        }
        IDropout this$iDropout = this.getIDropout();
        IDropout other$iDropout = other.getIDropout();
        if (this$iDropout == null ? other$iDropout != null : !this$iDropout.equals(other$iDropout)) {
            return false;
        }
        List<LayerConstraint> this$constraints = this.getConstraints();
        List<LayerConstraint> other$constraints = other.getConstraints();
        return !(this$constraints == null ? other$constraints != null : !((Object)this$constraints).equals(other$constraints));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Layer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $layerName = this.getLayerName();
        result = result * 59 + ($layerName == null ? 43 : $layerName.hashCode());
        IDropout $iDropout = this.getIDropout();
        result = result * 59 + ($iDropout == null ? 43 : $iDropout.hashCode());
        List<LayerConstraint> $constraints = this.getConstraints();
        result = result * 59 + ($constraints == null ? 43 : ((Object)$constraints).hashCode());
        return result;
    }

    public String toString() {
        return "Layer(layerName=" + this.getLayerName() + ", iDropout=" + this.getIDropout() + ", constraints=" + this.getConstraints() + ")";
    }

    public Layer() {
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String layerName = null;
        protected List<LayerConstraint> allParamConstraints;
        protected List<LayerConstraint> weightConstraints;
        protected List<LayerConstraint> biasConstraints;
        protected IDropout iDropout;

        public T name(String layerName) {
            this.setLayerName(layerName);
            return (T)this;
        }

        public T dropOut(double inputRetainProbability) {
            if (inputRetainProbability == 0.0) {
                return this.dropOut(null);
            }
            return this.dropOut(new Dropout(inputRetainProbability));
        }

        public T dropOut(IDropout dropout) {
            this.setIDropout(dropout);
            return (T)this;
        }

        public T constrainAllParameters(LayerConstraint ... constraints) {
            this.setAllParamConstraints(Arrays.asList(constraints));
            return (T)this;
        }

        public T constrainBias(LayerConstraint ... constraints) {
            this.setBiasConstraints(Arrays.asList(constraints));
            return (T)this;
        }

        public T constrainWeights(LayerConstraint ... constraints) {
            this.setWeightConstraints(Arrays.asList(constraints));
            return (T)this;
        }

        public abstract <E extends Layer> E build();

        public String getLayerName() {
            return this.layerName;
        }

        public List<LayerConstraint> getAllParamConstraints() {
            return this.allParamConstraints;
        }

        public List<LayerConstraint> getWeightConstraints() {
            return this.weightConstraints;
        }

        public List<LayerConstraint> getBiasConstraints() {
            return this.biasConstraints;
        }

        public IDropout getIDropout() {
            return this.iDropout;
        }

        public void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        public void setAllParamConstraints(List<LayerConstraint> allParamConstraints) {
            this.allParamConstraints = allParamConstraints;
        }

        public void setWeightConstraints(List<LayerConstraint> weightConstraints) {
            this.weightConstraints = weightConstraints;
        }

        public void setBiasConstraints(List<LayerConstraint> biasConstraints) {
            this.biasConstraints = biasConstraints;
        }

        public void setIDropout(IDropout iDropout) {
            this.iDropout = iDropout;
        }
    }
}

