/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.layers.convolution.Convolution3DLayer;
import org.deeplearning4j.nn.params.Convolution3DParamInitializer;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.deeplearning4j.util.Convolution3DUtils;
import org.deeplearning4j.util.ConvolutionUtils;
import org.deeplearning4j.util.ValidationUtils;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class Convolution3D
extends ConvolutionLayer {
    @JsonProperty(value="mode")
    protected ConvolutionMode mode = ConvolutionMode.Same;
    @JsonProperty(value="dataFormat")
    protected DataFormat dataFormat = DataFormat.NCDHW;

    public Convolution3D(Builder builder) {
        super(builder);
        this.dataFormat = builder.dataFormat;
        this.convolutionMode = builder.convolutionMode;
    }

    @Override
    public boolean hasBias() {
        return this.hasBias;
    }

    @Override
    public Convolution3D clone() {
        Convolution3D clone = (Convolution3D)super.clone();
        if (clone.kernelSize != null) {
            clone.kernelSize = (int[])clone.kernelSize.clone();
        }
        if (clone.stride != null) {
            clone.stride = (int[])clone.stride.clone();
        }
        if (clone.padding != null) {
            clone.padding = (int[])clone.padding.clone();
        }
        if (clone.dilation != null) {
            clone.dilation = (int[])clone.dilation.clone();
        }
        return clone;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<TrainingListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams, DataType networkDataType) {
        LayerValidation.assertNInNOutSet("Convolution3D", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        Convolution3DLayer ret = new Convolution3DLayer(conf, networkDataType);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return Convolution3DParamInitializer.getInstance();
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType inputType) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN3D) {
            throw new IllegalStateException("Invalid input for Convolution3D layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN3D input, got " + inputType);
        }
        return InputTypeUtil.getOutputTypeCnn3DLayers(inputType, this.dataFormat, this.kernelSize, this.stride, this.padding, this.dilation, this.convolutionMode, this.nOut, layerIndex, this.getLayerName(), Convolution3DLayer.class);
    }

    @Override
    public InputPreProcessor getPreProcessorForInputType(InputType inputType) {
        if (inputType == null) {
            throw new IllegalStateException("Invalid input for Convolution3D layer (layer name=\"" + this.getLayerName() + "\"): input is null");
        }
        return InputTypeUtil.getPreProcessorForInputTypeCnn3DLayers(inputType, this.getLayerName());
    }

    @Override
    public void setNIn(InputType inputType, boolean override) {
        if (inputType == null || inputType.getType() != InputType.Type.CNN3D) {
            throw new IllegalStateException("Invalid input for Convolution 3D layer (layer name=\"" + this.getLayerName() + "\"): Expected CNN3D input, got " + inputType);
        }
        if (this.nIn <= 0L || override) {
            InputType.InputTypeConvolutional3D c = (InputType.InputTypeConvolutional3D)inputType;
            this.nIn = c.getChannels();
        }
    }

    public ConvolutionMode getMode() {
        return this.mode;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setMode(ConvolutionMode mode) {
        this.mode = mode;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public Convolution3D() {
    }

    @Override
    public String toString() {
        return "Convolution3D(super=" + super.toString() + ", mode=" + (Object)((Object)this.getMode()) + ", dataFormat=" + this.getDataFormat() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Convolution3D)) {
            return false;
        }
        Convolution3D other = (Convolution3D)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConvolutionMode this$mode = this.getMode();
        ConvolutionMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode)) {
            return false;
        }
        DataFormat this$dataFormat = this.getDataFormat();
        DataFormat other$dataFormat = other.getDataFormat();
        return !(this$dataFormat == null ? other$dataFormat != null : !this$dataFormat.equals(other$dataFormat));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Convolution3D;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ConvolutionMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        DataFormat $dataFormat = this.getDataFormat();
        result = result * 59 + ($dataFormat == null ? 43 : $dataFormat.hashCode());
        return result;
    }

    public static class Builder
    extends ConvolutionLayer.BaseConvBuilder<Builder> {
        private DataFormat dataFormat = DataFormat.NCDHW;

        public Builder() {
            super(new int[]{2, 2, 2}, new int[]{1, 1, 1}, new int[]{0, 0, 0}, new int[]{1, 1, 1}, 3);
        }

        @Override
        protected boolean allowCausal() {
            return false;
        }

        public Builder(int[] kernelSize, int[] stride, int[] padding, int[] dilation) {
            super(kernelSize, stride, padding, dilation, 3);
        }

        public Builder(int[] kernelSize, int[] stride, int[] padding) {
            this(kernelSize, stride, padding, new int[]{1, 1, 1});
        }

        public Builder(int[] kernelSize, int[] stride) {
            this(kernelSize, stride, new int[]{0, 0, 0});
        }

        public Builder(int ... kernelSize) {
            this(kernelSize, new int[]{1, 1, 1});
        }

        @Override
        public Builder kernelSize(int ... kernelSize) {
            this.setKernelSize(kernelSize);
            return this;
        }

        @Override
        public Builder stride(int ... stride) {
            this.setStride(stride);
            return this;
        }

        @Override
        public Builder padding(int ... padding) {
            this.setPadding(padding);
            return this;
        }

        @Override
        public Builder dilation(int ... dilation) {
            this.setDilation(dilation);
            return this;
        }

        @Override
        public Builder convolutionMode(ConvolutionMode mode) {
            this.setConvolutionMode(mode);
            return this;
        }

        public Builder dataFormat(DataFormat dataFormat) {
            this.setDataFormat(dataFormat);
            return this;
        }

        @Override
        public void setKernelSize(int ... kernelSize) {
            this.kernelSize = ValidationUtils.validate3NonNegative(kernelSize, "kernelSize");
        }

        @Override
        public void setStride(int ... stride) {
            this.stride = ValidationUtils.validate3NonNegative(stride, "stride");
        }

        @Override
        public void setPadding(int ... padding) {
            this.padding = ValidationUtils.validate3NonNegative(padding, "padding");
        }

        @Override
        public void setDilation(int ... dilation) {
            this.dilation = ValidationUtils.validate3NonNegative(dilation, "dilation");
        }

        @Override
        public Convolution3D build() {
            ConvolutionUtils.validateConvolutionModePadding(this.convolutionMode, this.padding);
            Convolution3DUtils.validateCnn3DKernelStridePadding(this.kernelSize, this.stride, this.padding);
            return new Convolution3D(this);
        }

        public Builder(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
        }

        public DataFormat getDataFormat() {
            return this.dataFormat;
        }

        public void setDataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
        }
    }

    public static enum DataFormat implements org.deeplearning4j.nn.conf.DataFormat
    {
        NCDHW,
        NDHWC;

    }
}

