/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class ScaleVertex
extends GraphVertex {
    protected double scaleFactor;

    public ScaleVertex(@JsonProperty(value="scaleFactor") double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    @Override
    public ScaleVertex clone() {
        return new ScaleVertex(this.scaleFactor);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ScaleVertex)) {
            return false;
        }
        return ((ScaleVertex)o).scaleFactor == this.scaleFactor;
    }

    @Override
    public int hashCode() {
        return 123073088;
    }

    @Override
    public long numParams(boolean backprop) {
        return 0L;
    }

    @Override
    public int minVertexInputs() {
        return 1;
    }

    @Override
    public int maxVertexInputs() {
        return 1;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams, DataType networkDatatype) {
        return new org.deeplearning4j.nn.graph.vertex.impl.ScaleVertex(graph, name, idx, this.scaleFactor, networkDatatype);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length == 1) {
            return vertexInputs[0];
        }
        InputType first = vertexInputs[0];
        return first;
    }

    @Override
    public MemoryReport getMemoryReport(InputType ... inputTypes) {
        InputType outputType = this.getOutputType(-1, inputTypes);
        return new LayerMemoryReport.Builder(null, ScaleVertex.class, inputTypes[0], outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, 0L).cacheMemory(0L, 0L).build();
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public String toString() {
        return "ScaleVertex(scaleFactor=" + this.getScaleFactor() + ")";
    }
}

