/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.conf.layers.InputTypeUtil;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.impl.ElementWiseVertex;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class ElementWiseVertex
extends GraphVertex {
    protected Op op;

    public ElementWiseVertex(@JsonProperty(value="op") Op op) {
        this.op = op;
    }

    @Override
    public ElementWiseVertex clone() {
        return new ElementWiseVertex(this.op);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ElementWiseVertex)) {
            return false;
        }
        return ((ElementWiseVertex)o).op == this.op;
    }

    @Override
    public int hashCode() {
        return this.op.hashCode();
    }

    @Override
    public long numParams(boolean backprop) {
        return 0L;
    }

    @Override
    public int minVertexInputs() {
        return 2;
    }

    @Override
    public int maxVertexInputs() {
        switch (this.op) {
            case Add: 
            case Average: 
            case Product: 
            case Max: {
                return Integer.MAX_VALUE;
            }
            case Subtract: {
                return 2;
            }
        }
        throw new UnsupportedOperationException("Unknown op: " + (Object)((Object)this.op));
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams, DataType networkDatatype) {
        ElementWiseVertex.Op op;
        switch (this.op) {
            case Add: {
                op = ElementWiseVertex.Op.Add;
                break;
            }
            case Average: {
                op = ElementWiseVertex.Op.Average;
                break;
            }
            case Subtract: {
                op = ElementWiseVertex.Op.Subtract;
                break;
            }
            case Product: {
                op = ElementWiseVertex.Op.Product;
                break;
            }
            case Max: {
                op = ElementWiseVertex.Op.Max;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return new org.deeplearning4j.nn.graph.vertex.impl.ElementWiseVertex(graph, name, idx, op, networkDatatype);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length == 1) {
            return vertexInputs[0];
        }
        InputTypeUtil.convertMultipleTypes(vertexInputs);
        InputType first = vertexInputs[0];
        if (first.getType() != InputType.Type.CNN) {
            for (int i = 1; i < vertexInputs.length; ++i) {
                if (vertexInputs[i].getType() == first.getType()) continue;
                throw new InvalidInputTypeException("Invalid input: ElementWise vertex cannot process activations of different types: first type = " + (Object)((Object)first.getType()) + ", input type " + (i + 1) + " = " + (Object)((Object)vertexInputs[i].getType()));
            }
        } else {
            InputType.InputTypeConvolutional firstConv = (InputType.InputTypeConvolutional)first;
            long fd = firstConv.getChannels();
            long fw = firstConv.getWidth();
            long fh = firstConv.getHeight();
            for (int i = 1; i < vertexInputs.length; ++i) {
                if (vertexInputs[i].getType() != InputType.Type.CNN) {
                    throw new InvalidInputTypeException("Invalid input: ElementWise vertex cannot process activations of different types: first type = " + (Object)((Object)InputType.Type.CNN) + ", input type " + (i + 1) + " = " + (Object)((Object)vertexInputs[i].getType()));
                }
                InputType.InputTypeConvolutional otherConv = (InputType.InputTypeConvolutional)vertexInputs[i];
                long od = otherConv.getChannels();
                long ow = otherConv.getWidth();
                long oh = otherConv.getHeight();
                if (fd == od && fw == ow && fh == oh) continue;
                throw new InvalidInputTypeException("Invalid input: ElementWise vertex cannot process CNN activations of different sizes:first [channels,width,height] = [" + fd + "," + fw + "," + fh + "], input " + i + " = [" + od + "," + ow + "," + oh + "]");
            }
        }
        if (vertexInputs.length < 2) {
            return vertexInputs[0];
        }
        if (first.getType() == InputType.Type.FF) {
            InputType.InputTypeFeedForward maxInputType = null;
            for (int i = 0; i < vertexInputs.length; ++i) {
                InputType.InputTypeFeedForward feedForward = (InputType.InputTypeFeedForward)vertexInputs[i];
                if (maxInputType == null) {
                    maxInputType = feedForward;
                    continue;
                }
                if (maxInputType.getSize() >= feedForward.getSize()) continue;
                maxInputType = feedForward;
            }
            return maxInputType;
        }
        if (first.getType() == InputType.Type.CNNFlat) {
            InputType.InputTypeConvolutionalFlat maxInputType = null;
            for (int i = 0; i < vertexInputs.length; ++i) {
                InputType.InputTypeConvolutionalFlat feedForward = (InputType.InputTypeConvolutionalFlat)vertexInputs[i];
                if (maxInputType == null) {
                    maxInputType = feedForward;
                    continue;
                }
                if (maxInputType.getFlattenedSize() >= feedForward.getFlattenedSize()) continue;
                maxInputType = feedForward;
            }
            return maxInputType;
        }
        if (first.getType() == InputType.Type.RNN) {
            InputType.InputTypeRecurrent maxInputType = null;
            for (int i = 0; i < vertexInputs.length; ++i) {
                InputType.InputTypeRecurrent feedForward = (InputType.InputTypeRecurrent)vertexInputs[i];
                if (maxInputType == null) {
                    maxInputType = feedForward;
                    continue;
                }
                if (maxInputType.getTimeSeriesLength() >= feedForward.getTimeSeriesLength()) continue;
                maxInputType = feedForward;
            }
            return maxInputType;
        }
        return first;
    }

    @Override
    public MemoryReport getMemoryReport(InputType ... inputTypes) {
        return new LayerMemoryReport.Builder(null, ElementWiseVertex.class, inputTypes[0], inputTypes[0]).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, 0L).cacheMemory(0L, 0L).build();
    }

    public Op getOp() {
        return this.op;
    }

    public void setOp(Op op) {
        this.op = op;
    }

    public String toString() {
        return "ElementWiseVertex(op=" + (Object)((Object)this.getOp()) + ")";
    }

    public static enum Op {
        Add,
        Subtract,
        Product,
        Average,
        Max;

    }
}

