/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.convolution;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.AbstractLayer;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class ZeroPadding3DLayer
extends AbstractLayer<org.deeplearning4j.nn.conf.layers.ZeroPadding3DLayer> {
    private int[] padding;

    public ZeroPadding3DLayer(NeuralNetConfiguration conf, DataType dataType) {
        super(conf, dataType);
        this.padding = ((org.deeplearning4j.nn.conf.layers.ZeroPadding3DLayer)conf.getLayer()).getPadding();
    }

    @Override
    public boolean isPretrainLayer() {
        return false;
    }

    @Override
    public void clearNoiseWeightParams() {
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.CONVOLUTIONAL;
    }

    @Override
    public Pair<Gradient, INDArray> backpropGradient(INDArray epsilon, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(true);
        long[] inShape = this.input.shape();
        INDArray epsNext = epsilon.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((long)this.padding[0], (long)((long)this.padding[0] + inShape[2])), NDArrayIndex.interval((long)this.padding[2], (long)((long)this.padding[2] + inShape[3])), NDArrayIndex.interval((long)this.padding[4], (long)((long)this.padding[4] + inShape[4]))});
        epsNext = workspaceMgr.leverageTo(ArrayType.ACTIVATION_GRAD, epsNext);
        return new Pair((Object)new DefaultGradient(), (Object)epsNext);
    }

    @Override
    public INDArray activate(boolean training, LayerWorkspaceMgr workspaceMgr) {
        this.assertInputSet(false);
        long[] inShape = this.input.shape();
        long outD = inShape[2] + (long)this.padding[0] + (long)this.padding[1];
        long outH = inShape[3] + (long)this.padding[2] + (long)this.padding[3];
        long outW = inShape[4] + (long)this.padding[4] + (long)this.padding[5];
        long[] outShape = new long[]{inShape[0], inShape[1], outD, outH, outW};
        INDArray out = workspaceMgr.create(ArrayType.ACTIVATIONS, this.input.dataType(), outShape, 'c');
        out.put(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((long)this.padding[0], (long)((long)this.padding[0] + inShape[2])), NDArrayIndex.interval((long)this.padding[2], (long)((long)this.padding[2] + inShape[3])), NDArrayIndex.interval((long)this.padding[4], (long)((long)this.padding[4] + inShape[4]))}, this.input);
        return out;
    }

    public Layer clone() {
        return new ZeroPadding3DLayer(this.conf.clone(), this.dataType);
    }

    @Override
    public double calcRegularizationScore(boolean backpropParamsOnly) {
        return 0.0;
    }
}

