/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.graph.vertex.impl;

import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.graph.vertex.BaseGraphVertex;
import org.deeplearning4j.nn.graph.vertex.VertexIndices;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.bool.Or;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public class PoolHelperVertex
extends BaseGraphVertex {
    public PoolHelperVertex(ComputationGraph graph, String name, int vertexIndex, DataType dataType) {
        this(graph, name, vertexIndex, null, null, dataType);
    }

    public PoolHelperVertex(ComputationGraph graph, String name, int vertexIndex, VertexIndices[] inputVertices, VertexIndices[] outputVertices, DataType dataType) {
        super(graph, name, vertexIndex, inputVertices, outputVertices, dataType);
    }

    @Override
    public boolean hasLayer() {
        return false;
    }

    @Override
    public Layer getLayer() {
        return null;
    }

    @Override
    public INDArray doForward(boolean training, LayerWorkspaceMgr workspaceMgr) {
        if (!this.canDoForward()) {
            throw new IllegalStateException("Cannot do forward pass: inputs not set");
        }
        if (this.inputs.length > 1) {
            throw new IllegalStateException("PoolHelper vertex requires a single input.");
        }
        INDArray strippedInput = this.inputs[0].get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((long)1L, (long)this.inputs[0].size(2)), NDArrayIndex.interval((long)1L, (long)this.inputs[0].size(3))});
        return workspaceMgr.dup(ArrayType.ACTIVATIONS, strippedInput);
    }

    @Override
    public Pair<Gradient, INDArray[]> doBackward(boolean tbptt, LayerWorkspaceMgr workspaceMgr) {
        if (!this.canDoBackward()) {
            throw new IllegalStateException("Cannot do backward pass: errors not set");
        }
        INDArray out = workspaceMgr.create(ArrayType.ACTIVATION_GRAD, this.epsilon.dataType(), new long[]{this.epsilon.size(0), this.epsilon.size(1), 1L + this.epsilon.size(2), 1L + this.epsilon.size(2)});
        out.get(new INDArrayIndex[]{NDArrayIndex.all(), NDArrayIndex.all(), NDArrayIndex.interval((long)1L, (long)this.inputs[0].size(2)), NDArrayIndex.interval((long)1L, (long)this.inputs[0].size(3))}).assign(this.epsilon);
        return new Pair(null, (Object)new INDArray[]{out});
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray backpropGradientsViewArray) {
        if (backpropGradientsViewArray != null) {
            throw new RuntimeException("Vertex does not have gradients; gradients view array cannot be set here");
        }
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArrays(INDArray[] maskArrays, MaskState currentMaskState, int minibatchSize) {
        if (maskArrays == null) {
            return new Pair(null, (Object)currentMaskState);
        }
        for (INDArray arr : maskArrays) {
            if (arr != null) continue;
            return new Pair(null, (Object)currentMaskState);
        }
        if (maskArrays.length == 1) {
            return new Pair((Object)maskArrays[0], (Object)currentMaskState);
        }
        INDArray ret = maskArrays[0].dup(maskArrays[0].ordering());
        Nd4j.getExecutioner().exec((Op)new Or(maskArrays[0], maskArrays[1], ret));
        for (int i = 2; i < maskArrays.length; ++i) {
            Nd4j.getExecutioner().exec((Op)new Or(maskArrays[i], ret, ret));
        }
        return new Pair((Object)ret, (Object)currentMaskState);
    }

    @Override
    public String toString() {
        return "PoolHelperVertex(id=" + this.getVertexIndex() + ",name=\"" + this.getVertexName() + "\")";
    }
}

