/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.graph;

import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.inputs.InvalidInputTypeException;
import org.deeplearning4j.nn.conf.memory.LayerMemoryReport;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class ShiftVertex
extends GraphVertex {
    protected double shiftFactor = 0.0;

    public ShiftVertex(@JsonProperty(value="shiftFactor") double shiftFactor) {
        this.shiftFactor = shiftFactor;
    }

    @Override
    public ShiftVertex clone() {
        return new ShiftVertex(this.shiftFactor);
    }

    @Override
    public long numParams(boolean backprop) {
        return 0L;
    }

    @Override
    public int minVertexInputs() {
        return 1;
    }

    @Override
    public int maxVertexInputs() {
        return 1;
    }

    @Override
    public org.deeplearning4j.nn.graph.vertex.GraphVertex instantiate(ComputationGraph graph, String name, int idx, INDArray paramsView, boolean initializeParams, DataType networkDatatype) {
        return new org.deeplearning4j.nn.graph.vertex.impl.ShiftVertex(graph, name, idx, this.shiftFactor, networkDatatype);
    }

    @Override
    public InputType getOutputType(int layerIndex, InputType ... vertexInputs) throws InvalidInputTypeException {
        if (vertexInputs.length == 1) {
            return vertexInputs[0];
        }
        InputType first = vertexInputs[0];
        return first;
    }

    @Override
    public MemoryReport getMemoryReport(InputType ... inputTypes) {
        InputType outputType = this.getOutputType(-1, inputTypes);
        return new LayerMemoryReport.Builder(null, ShiftVertex.class, inputTypes[0], outputType).standardMemory(0L, 0L).workingMemory(0L, 0L, 0L, 0L).cacheMemory(0L, 0L).build();
    }

    public double getShiftFactor() {
        return this.shiftFactor;
    }

    public void setShiftFactor(double shiftFactor) {
        this.shiftFactor = shiftFactor;
    }

    public ShiftVertex() {
    }

    public String toString() {
        return "ShiftVertex(super=" + super.toString() + ", shiftFactor=" + this.getShiftFactor() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShiftVertex)) {
            return false;
        }
        ShiftVertex other = (ShiftVertex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.getShiftFactor(), other.getShiftFactor()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShiftVertex;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $shiftFactor = Double.doubleToLongBits(this.getShiftFactor());
        result = result * 59 + (int)($shiftFactor >>> 32 ^ $shiftFactor);
        return result;
    }
}

