/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.WorkspaceMode;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.graph.GraphVertex;
import org.deeplearning4j.nn.conf.graph.LayerVertex;
import org.deeplearning4j.nn.conf.graph.MergeVertex;
import org.deeplearning4j.nn.conf.graph.rnn.LastTimeStepVertex;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.GlobalPoolingLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.recurrent.LastTimeStep;
import org.deeplearning4j.nn.conf.layers.samediff.SameDiffVertex;
import org.deeplearning4j.nn.conf.memory.MemoryReport;
import org.deeplearning4j.nn.conf.memory.NetworkMemoryReport;
import org.deeplearning4j.nn.conf.serde.JsonMappers;
import org.deeplearning4j.nn.weights.IWeightInit;
import org.deeplearning4j.nn.weights.WeightInit;
import org.deeplearning4j.util.OutputLayerUtil;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.shade.jackson.core.JsonProcessingException;
import org.nd4j.shade.jackson.core.TreeNode;
import org.nd4j.shade.jackson.databind.JsonNode;
import org.nd4j.shade.jackson.databind.ObjectMapper;
import org.nd4j.shade.jackson.databind.exc.InvalidTypeIdException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputationGraphConfiguration
implements Serializable,
Cloneable {
    private static Logger log = LoggerFactory.getLogger(ComputationGraphConfiguration.class);
    protected Map<String, GraphVertex> vertices = new LinkedHashMap<String, GraphVertex>();
    protected Map<String, List<String>> vertexInputs = new LinkedHashMap<String, List<String>>();
    protected WorkspaceMode trainingWorkspaceMode = WorkspaceMode.ENABLED;
    protected WorkspaceMode inferenceWorkspaceMode = WorkspaceMode.ENABLED;
    protected CacheMode cacheMode;
    protected DataType dataType = DataType.FLOAT;
    protected boolean validateOutputLayerConfig = true;
    protected List<String> networkInputs;
    protected List<String> networkOutputs;
    protected BackpropType backpropType = BackpropType.Standard;
    protected int tbpttFwdLength = 20;
    protected int tbpttBackLength = 20;
    protected NeuralNetConfiguration defaultConfiguration;
    protected int iterationCount = 0;
    protected int epochCount = 0;
    protected int[] topologicalOrder;
    protected List<String> topologicalOrderStr;

    public String toYaml() {
        ObjectMapper mapper;
        ObjectMapper objectMapper = mapper = NeuralNetConfiguration.mapperYaml();
        synchronized (objectMapper) {
            try {
                return mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static ComputationGraphConfiguration fromYaml(String json) {
        ObjectMapper mapper = NeuralNetConfiguration.mapperYaml();
        try {
            return (ComputationGraphConfiguration)mapper.readValue(json, ComputationGraphConfiguration.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJson() {
        ObjectMapper mapper;
        ObjectMapper objectMapper = mapper = NeuralNetConfiguration.mapper();
        synchronized (objectMapper) {
            try {
                return mapper.writeValueAsString((Object)this);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static ComputationGraphConfiguration fromJson(String json) {
        ComputationGraphConfiguration conf;
        ObjectMapper mapper = NeuralNetConfiguration.mapper();
        try {
            conf = (ComputationGraphConfiguration)mapper.readValue(json, ComputationGraphConfiguration.class);
        }
        catch (InvalidTypeIdException e) {
            if (e.getMessage().contains("@class")) {
                try {
                    return (ComputationGraphConfiguration)JsonMappers.getLegacyMapper().readValue(json, ComputationGraphConfiguration.class);
                }
                catch (InvalidTypeIdException e2) {
                    String msg = e2.getMessage();
                    if (msg != null && msg.contains("Could not resolve type id")) {
                        throw new RuntimeException("Error deserializing ComputationGraphConfiguration - configuration may have a custom layer, vertex or preprocessor, in pre version 1.0.0-beta JSON format.\nModels in legacy format with custom layers should be loaded in 1.0.0-beta to 1.0.0-beta4 and saved again, before loading in the current version of DL4J", e);
                    }
                    throw new RuntimeException(e2);
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg != null && msg.contains("legacy")) {
                throw new RuntimeException("Error deserializing ComputationGraphConfiguration - configuration may have a custom layer, vertex or preprocessor, in pre version 1.0.0-alpha JSON format. These layers can be deserialized by first registering them with NeuralNetConfiguration.registerLegacyCustomClassesForJSON(Class...)", e);
            }
            throw new RuntimeException(e);
        }
        boolean layerCount = false;
        Map<String, GraphVertex> vertexMap = conf.getVertices();
        JsonNode vertices = null;
        for (Map.Entry<String, GraphVertex> entry : vertexMap.entrySet()) {
            LayerVertex lv;
            if (!(entry.getValue() instanceof LayerVertex) || (lv = (LayerVertex)entry.getValue()).getLayerConf() == null || lv.getLayerConf().getLayer() == null) continue;
            Layer layer = lv.getLayerConf().getLayer();
            if (layer instanceof BaseLayer && ((BaseLayer)layer).getActivationFn() == null) {
                String layerName = layer.getLayerName();
                try {
                    JsonNode layerWrapperNode;
                    JsonNode vertexNode;
                    JsonNode layerVertexNode;
                    if (vertices == null) {
                        JsonNode jsonNode = mapper.readTree(json);
                        vertices = jsonNode.get("vertices");
                    }
                    if ((layerVertexNode = (vertexNode = vertices.get(layerName)).get("LayerVertex")) == null || !layerVertexNode.has("layerConf") || !layerVertexNode.get("layerConf").has("layer") || (layerWrapperNode = layerVertexNode.get("layerConf").get("layer")) == null || layerWrapperNode.size() != 1) continue;
                    JsonNode layerNode = (JsonNode)layerWrapperNode.elements().next();
                    JsonNode activationFunction = layerNode.get("activationFunction");
                    if (activationFunction != null) {
                        IActivation ia = Activation.fromString((String)activationFunction.asText()).getActivationFunction();
                        ((BaseLayer)layer).setActivationFn(ia);
                    }
                }
                catch (IOException e) {
                    log.warn("Layer with null ActivationFn field or pre-0.7.2 activation function detected: could not parse JSON", (Throwable)e);
                }
            }
            ComputationGraphConfiguration.handleLegacyWeightInitFromJson(json, layer, mapper, vertices);
        }
        return conf;
    }

    private static void handleLegacyWeightInitFromJson(String json, Layer layer, ObjectMapper mapper, JsonNode vertices) {
        if (layer instanceof BaseLayer && ((BaseLayer)layer).getWeightInitFn() == null) {
            String layerName = layer.getLayerName();
            try {
                JsonNode vertexNode;
                JsonNode layerVertexNode;
                if (vertices == null) {
                    JsonNode jsonNode = mapper.readTree(json);
                    vertices = jsonNode.get("vertices");
                }
                if ((layerVertexNode = (vertexNode = vertices.get(layerName)).get("LayerVertex")) == null || !layerVertexNode.has("layerConf") || !layerVertexNode.get("layerConf").has("layer")) {
                    return;
                }
                JsonNode layerWrapperNode = layerVertexNode.get("layerConf").get("layer");
                if (layerWrapperNode == null || layerWrapperNode.size() != 1) {
                    return;
                }
                JsonNode layerNode = (JsonNode)layerWrapperNode.elements().next();
                JsonNode weightInit = layerNode.get("weightInit");
                JsonNode distribution = layerNode.get("dist");
                Distribution dist = null;
                if (distribution != null) {
                    dist = (Distribution)mapper.treeToValue((TreeNode)distribution, Distribution.class);
                }
                if (weightInit != null) {
                    IWeightInit wi = WeightInit.valueOf(weightInit.asText()).getWeightInitFunction(dist);
                    ((BaseLayer)layer).setWeightInitFn(wi);
                }
            }
            catch (IOException e) {
                log.warn("Layer with null ActivationFn field or pre-0.7.2 activation function detected: could not parse JSON", (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.toJson();
    }

    public ComputationGraphConfiguration clone() {
        ComputationGraphConfiguration conf = new ComputationGraphConfiguration();
        conf.vertices = new LinkedHashMap<String, GraphVertex>();
        for (Map.Entry<String, GraphVertex> entry : this.vertices.entrySet()) {
            conf.vertices.put(entry.getKey(), entry.getValue().clone());
        }
        conf.vertexInputs = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, Object> entry : this.vertexInputs.entrySet()) {
            conf.vertexInputs.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        conf.networkInputs = new ArrayList<String>();
        conf.networkInputs = new ArrayList<String>(this.networkInputs);
        conf.networkOutputs = new ArrayList<String>(this.networkOutputs);
        conf.backpropType = this.backpropType;
        conf.tbpttFwdLength = this.tbpttFwdLength;
        conf.tbpttBackLength = this.tbpttBackLength;
        conf.defaultConfiguration = this.defaultConfiguration.clone();
        conf.trainingWorkspaceMode = this.trainingWorkspaceMode;
        conf.inferenceWorkspaceMode = this.inferenceWorkspaceMode;
        conf.cacheMode = this.cacheMode;
        conf.defaultConfiguration.cacheMode = this.cacheMode;
        conf.validateOutputLayerConfig = this.validateOutputLayerConfig;
        conf.dataType = this.dataType;
        return conf;
    }

    public void validate() {
        this.validate(false, false);
    }

    public void validate(boolean allowDisconnected, boolean allowNoOutput) {
        if (this.networkInputs == null || this.networkInputs.isEmpty()) {
            throw new IllegalStateException("Invalid configuration: network has no inputs. Use .addInputs(String...) to label (and give an ordering to) the network inputs");
        }
        if ((this.networkOutputs == null || this.networkOutputs.isEmpty()) && !allowNoOutput) {
            throw new IllegalStateException("Invalid configuration: network has no outputs. Use .setOutput(String...) to specify (and give an ordering to) the output vertices, or use allowNoOutputs(true) to disable this check");
        }
        for (String string : this.networkInputs) {
            if (!this.vertices.containsKey(string)) continue;
            throw new IllegalStateException("Invalid configuration: name \"" + string + "\" is present in both network inputs and graph vertices/layers");
        }
        for (Map.Entry entry : this.vertexInputs.entrySet()) {
            String string = (String)entry.getKey();
            if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) {
                throw new IllegalStateException("Invalid configuration: vertex \"" + string + "\" has no inputs");
            }
            for (String inputName : (List)entry.getValue()) {
                if (this.vertices.containsKey(inputName) || this.networkInputs.contains(inputName)) continue;
                throw new IllegalStateException("Invalid configuration: Vertex \"" + string + "\" has input \"" + inputName + "\" that does not exist");
            }
        }
        if (this.networkOutputs != null) {
            for (String string : this.networkOutputs) {
                if (this.vertices.containsKey(string)) continue;
                throw new IllegalStateException("Invalid configuration: Output name \"" + string + "\" is not a valid vertex");
            }
        }
        if (!allowDisconnected) {
            HashSet<String> seenAsInput = new HashSet<String>();
            seenAsInput.addAll(this.networkOutputs);
            for (Map.Entry<String, List<String>> entry : this.vertexInputs.entrySet()) {
                seenAsInput.addAll((Collection)entry.getValue());
            }
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(this.networkInputs);
            hashSet.addAll(this.vertices.keySet());
            hashSet.removeAll(seenAsInput);
            if (!hashSet.isEmpty() && !allowNoOutput) {
                throw new IllegalStateException("Invalid configuration: disconnected vertices found - " + hashSet + ". Disconnected vertices are those that do not connect to either another vertex, and are also not a network output. This vertex can be set as an output using setOutputs(String...). To disable this error (i.e., allow network configurations with disconnected vertices) use GraphBuilder.allowDisconnected(true)");
            }
        }
    }

    public void addPreProcessors(InputType ... inputTypes) {
        this.getLayerActivationTypes(true, inputTypes);
    }

    public void addPreProcessors(boolean addPreprocIfNecessary, boolean forceOverrideInputs, InputType ... inputTypes) {
        this.getLayerActivationTypes(addPreprocIfNecessary, forceOverrideInputs, inputTypes);
    }

    public void addPreProcessors(boolean forceOverrideInputs, InputType ... inputTypes) {
        this.getLayerActivationTypes(true, forceOverrideInputs, inputTypes);
    }

    public Map<String, InputType> getLayerActivationTypes(InputType ... inputTypes) {
        return this.getLayerActivationTypes(true, inputTypes);
    }

    public Map<String, InputType> getLayerActivationTypes(boolean addPreprocIfNecessary, boolean overrideInputs, InputType ... inputTypes) {
        if (inputTypes == null || inputTypes.length != this.networkInputs.size()) {
            throw new IllegalArgumentException("Invalid number of InputTypes: cannot add preprocessors if number of InputType objects differs from number of network inputs");
        }
        List<String> topologicalOrdering = this.topologicalOrdering();
        LinkedHashMap<String, InputType> vertexOutputs = new LinkedHashMap<String, InputType>();
        int currLayerIdx = -1;
        for (String s : topologicalOrdering) {
            int inputIdx = this.networkInputs.indexOf(s);
            if (inputIdx != -1) {
                vertexOutputs.put(s, inputTypes[inputIdx]);
                continue;
            }
            GraphVertex gv = this.vertices.get(s);
            ArrayList<InputType> inputTypeList = new ArrayList<InputType>();
            if (gv instanceof LayerVertex) {
                String in = this.vertexInputs.get(s).get(0);
                InputType layerInput = (InputType)vertexOutputs.get(in);
                inputTypeList.add(layerInput);
                LayerVertex lv = (LayerVertex)gv;
                Layer l = lv.getLayerConf().getLayer();
                if (lv.getPreProcessor() == null) {
                    InputPreProcessor preproc = l.getPreProcessorForInputType(layerInput);
                    lv.setPreProcessor(preproc);
                }
                InputType afterPreproc = layerInput;
                if (lv.getPreProcessor() != null && addPreprocIfNecessary) {
                    InputPreProcessor ip = lv.getPreProcessor();
                    afterPreproc = ip.getOutputType(layerInput);
                }
                l.setNIn(afterPreproc, overrideInputs);
                ++currLayerIdx;
            } else {
                List<String> inputs = this.vertexInputs.get(s);
                if (inputs != null) {
                    for (String inputVertexName : inputs) {
                        inputTypeList.add((InputType)vertexOutputs.get(inputVertexName));
                    }
                }
            }
            InputType outputFromVertex = gv.getOutputType(currLayerIdx, inputTypeList.toArray(new InputType[inputTypeList.size()]));
            vertexOutputs.put(s, outputFromVertex);
        }
        return vertexOutputs;
    }

    public Map<String, InputType> getLayerActivationTypes(boolean addPreprocIfNecessary, InputType ... inputTypes) {
        return this.getLayerActivationTypes(addPreprocIfNecessary, true, inputTypes);
    }

    private Map<String, List<String>> verticesOutputTo() {
        HashMap<String, List<String>> verticesOutputTo = new HashMap<String, List<String>>();
        for (Map.Entry<String, GraphVertex> entry : this.vertices.entrySet()) {
            String vertexName = entry.getKey();
            List<String> vertexInputNames = this.vertexInputs.get(vertexName);
            if (vertexInputNames == null) continue;
            for (String s : vertexInputNames) {
                ArrayList<String> list = (ArrayList<String>)verticesOutputTo.get(s);
                if (list == null) {
                    list = new ArrayList<String>();
                    verticesOutputTo.put(s, list);
                }
                list.add(vertexName);
            }
        }
        return verticesOutputTo;
    }

    private List<String> topologicalOrdering() {
        Map<String, List<String>> verticesOutputTo = this.verticesOutputTo();
        LinkedList<String> noIncomingEdges = new LinkedList<String>(this.networkInputs);
        ArrayList<String> topologicalOrdering = new ArrayList<String>();
        HashMap inputEdges = new HashMap();
        for (Map.Entry<String, List<String>> entry : this.vertexInputs.entrySet()) {
            inputEdges.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        while (!noIncomingEdges.isEmpty()) {
            String next = noIncomingEdges.removeFirst();
            topologicalOrdering.add(next);
            List<String> list = verticesOutputTo.get(next);
            if (list == null || list.isEmpty()) continue;
            for (String s : list) {
                Set set = (Set)inputEdges.get(s);
                set.remove(next);
                if (!set.isEmpty()) continue;
                noIncomingEdges.add(s);
            }
        }
        for (Map.Entry<String, List<String>> entry : inputEdges.entrySet()) {
            Set set = (Set)((Object)entry.getValue());
            if (set == null || set.isEmpty()) continue;
            throw new IllegalStateException("Invalid configuration: cycle detected in graph. Cannot calculate topological ordering with graph cycle (cycle includes vertex \"" + entry.getKey() + "\")");
        }
        return topologicalOrdering;
    }

    public NetworkMemoryReport getMemoryReport(InputType ... inputTypes) {
        LinkedHashMap<String, MemoryReport> memoryReportMap = new LinkedHashMap<String, MemoryReport>();
        List<String> topologicalOrdering = this.topologicalOrdering();
        HashMap<String, InputType> vertexOutputs = new HashMap<String, InputType>();
        int currLayerIdx = -1;
        for (String s : topologicalOrdering) {
            int inputIdx = this.networkInputs.indexOf(s);
            if (inputIdx != -1) {
                vertexOutputs.put(s, inputTypes[inputIdx]);
                continue;
            }
            GraphVertex gv = this.vertices.get(s);
            ArrayList<Object> inputTypeList = new ArrayList<Object>();
            if (gv instanceof LayerVertex) {
                String in = this.vertexInputs.get(s).get(0);
                InputType layerInput = (InputType)vertexOutputs.get(in);
                inputTypeList.add(layerInput);
                ++currLayerIdx;
            } else {
                List<String> inputs = this.vertexInputs.get(s);
                if (inputs != null) {
                    for (String inputVertexName : inputs) {
                        inputTypeList.add((InputType)vertexOutputs.get(inputVertexName));
                    }
                }
            }
            InputType outputFromVertex = gv.getOutputType(currLayerIdx, inputTypeList.toArray(new InputType[inputTypeList.size()]));
            vertexOutputs.put(s, outputFromVertex);
            MemoryReport mr = gv.getMemoryReport(inputTypeList.toArray(new InputType[inputTypeList.size()]));
            memoryReportMap.put(s, mr);
        }
        return new NetworkMemoryReport(memoryReportMap, ComputationGraphConfiguration.class, "ComputationGraph", inputTypes);
    }

    public Map<String, GraphVertex> getVertices() {
        return this.vertices;
    }

    public Map<String, List<String>> getVertexInputs() {
        return this.vertexInputs;
    }

    public boolean isValidateOutputLayerConfig() {
        return this.validateOutputLayerConfig;
    }

    public List<String> getNetworkInputs() {
        return this.networkInputs;
    }

    public List<String> getNetworkOutputs() {
        return this.networkOutputs;
    }

    public BackpropType getBackpropType() {
        return this.backpropType;
    }

    public int getTbpttFwdLength() {
        return this.tbpttFwdLength;
    }

    public int getTbpttBackLength() {
        return this.tbpttBackLength;
    }

    public NeuralNetConfiguration getDefaultConfiguration() {
        return this.defaultConfiguration;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public int getEpochCount() {
        return this.epochCount;
    }

    public int[] getTopologicalOrder() {
        return this.topologicalOrder;
    }

    public List<String> getTopologicalOrderStr() {
        return this.topologicalOrderStr;
    }

    public void setVertices(Map<String, GraphVertex> vertices) {
        this.vertices = vertices;
    }

    public void setVertexInputs(Map<String, List<String>> vertexInputs) {
        this.vertexInputs = vertexInputs;
    }

    public void setValidateOutputLayerConfig(boolean validateOutputLayerConfig) {
        this.validateOutputLayerConfig = validateOutputLayerConfig;
    }

    public void setNetworkInputs(List<String> networkInputs) {
        this.networkInputs = networkInputs;
    }

    public void setNetworkOutputs(List<String> networkOutputs) {
        this.networkOutputs = networkOutputs;
    }

    public void setBackpropType(BackpropType backpropType) {
        this.backpropType = backpropType;
    }

    public void setTbpttFwdLength(int tbpttFwdLength) {
        this.tbpttFwdLength = tbpttFwdLength;
    }

    public void setTbpttBackLength(int tbpttBackLength) {
        this.tbpttBackLength = tbpttBackLength;
    }

    public void setDefaultConfiguration(NeuralNetConfiguration defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public void setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
    }

    public void setEpochCount(int epochCount) {
        this.epochCount = epochCount;
    }

    public void setTopologicalOrder(int[] topologicalOrder) {
        this.topologicalOrder = topologicalOrder;
    }

    public void setTopologicalOrderStr(List<String> topologicalOrderStr) {
        this.topologicalOrderStr = topologicalOrderStr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComputationGraphConfiguration)) {
            return false;
        }
        ComputationGraphConfiguration other = (ComputationGraphConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isValidateOutputLayerConfig() != other.isValidateOutputLayerConfig()) {
            return false;
        }
        if (this.getTbpttFwdLength() != other.getTbpttFwdLength()) {
            return false;
        }
        if (this.getTbpttBackLength() != other.getTbpttBackLength()) {
            return false;
        }
        if (this.getIterationCount() != other.getIterationCount()) {
            return false;
        }
        if (this.getEpochCount() != other.getEpochCount()) {
            return false;
        }
        Map<String, GraphVertex> this$vertices = this.getVertices();
        Map<String, GraphVertex> other$vertices = other.getVertices();
        if (this$vertices == null ? other$vertices != null : !((Object)this$vertices).equals(other$vertices)) {
            return false;
        }
        Map<String, List<String>> this$vertexInputs = this.getVertexInputs();
        Map<String, List<String>> other$vertexInputs = other.getVertexInputs();
        if (this$vertexInputs == null ? other$vertexInputs != null : !((Object)this$vertexInputs).equals(other$vertexInputs)) {
            return false;
        }
        DataType this$dataType = this.getDataType();
        DataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        List<String> this$networkInputs = this.getNetworkInputs();
        List<String> other$networkInputs = other.getNetworkInputs();
        if (this$networkInputs == null ? other$networkInputs != null : !((Object)this$networkInputs).equals(other$networkInputs)) {
            return false;
        }
        List<String> this$networkOutputs = this.getNetworkOutputs();
        List<String> other$networkOutputs = other.getNetworkOutputs();
        if (this$networkOutputs == null ? other$networkOutputs != null : !((Object)this$networkOutputs).equals(other$networkOutputs)) {
            return false;
        }
        BackpropType this$backpropType = this.getBackpropType();
        BackpropType other$backpropType = other.getBackpropType();
        if (this$backpropType == null ? other$backpropType != null : !((Object)((Object)this$backpropType)).equals((Object)other$backpropType)) {
            return false;
        }
        NeuralNetConfiguration this$defaultConfiguration = this.getDefaultConfiguration();
        NeuralNetConfiguration other$defaultConfiguration = other.getDefaultConfiguration();
        return !(this$defaultConfiguration == null ? other$defaultConfiguration != null : !((Object)this$defaultConfiguration).equals(other$defaultConfiguration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComputationGraphConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValidateOutputLayerConfig() ? 79 : 97);
        result = result * 59 + this.getTbpttFwdLength();
        result = result * 59 + this.getTbpttBackLength();
        result = result * 59 + this.getIterationCount();
        result = result * 59 + this.getEpochCount();
        Map<String, GraphVertex> $vertices = this.getVertices();
        result = result * 59 + ($vertices == null ? 43 : ((Object)$vertices).hashCode());
        Map<String, List<String>> $vertexInputs = this.getVertexInputs();
        result = result * 59 + ($vertexInputs == null ? 43 : ((Object)$vertexInputs).hashCode());
        DataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        List<String> $networkInputs = this.getNetworkInputs();
        result = result * 59 + ($networkInputs == null ? 43 : ((Object)$networkInputs).hashCode());
        List<String> $networkOutputs = this.getNetworkOutputs();
        result = result * 59 + ($networkOutputs == null ? 43 : ((Object)$networkOutputs).hashCode());
        BackpropType $backpropType = this.getBackpropType();
        result = result * 59 + ($backpropType == null ? 43 : ((Object)((Object)$backpropType)).hashCode());
        NeuralNetConfiguration $defaultConfiguration = this.getDefaultConfiguration();
        result = result * 59 + ($defaultConfiguration == null ? 43 : ((Object)$defaultConfiguration).hashCode());
        return result;
    }

    private ComputationGraphConfiguration(Map<String, GraphVertex> vertices, Map<String, List<String>> vertexInputs, WorkspaceMode trainingWorkspaceMode, WorkspaceMode inferenceWorkspaceMode, CacheMode cacheMode, DataType dataType, boolean validateOutputLayerConfig, List<String> networkInputs, List<String> networkOutputs, BackpropType backpropType, int tbpttFwdLength, int tbpttBackLength, NeuralNetConfiguration defaultConfiguration, int iterationCount, int epochCount, int[] topologicalOrder, List<String> topologicalOrderStr) {
        this.vertices = vertices;
        this.vertexInputs = vertexInputs;
        this.trainingWorkspaceMode = trainingWorkspaceMode;
        this.inferenceWorkspaceMode = inferenceWorkspaceMode;
        this.cacheMode = cacheMode;
        this.dataType = dataType;
        this.validateOutputLayerConfig = validateOutputLayerConfig;
        this.networkInputs = networkInputs;
        this.networkOutputs = networkOutputs;
        this.backpropType = backpropType;
        this.tbpttFwdLength = tbpttFwdLength;
        this.tbpttBackLength = tbpttBackLength;
        this.defaultConfiguration = defaultConfiguration;
        this.iterationCount = iterationCount;
        this.epochCount = epochCount;
        this.topologicalOrder = topologicalOrder;
        this.topologicalOrderStr = topologicalOrderStr;
    }

    public ComputationGraphConfiguration() {
    }

    public WorkspaceMode getTrainingWorkspaceMode() {
        return this.trainingWorkspaceMode;
    }

    public void setTrainingWorkspaceMode(WorkspaceMode trainingWorkspaceMode) {
        this.trainingWorkspaceMode = trainingWorkspaceMode;
    }

    public WorkspaceMode getInferenceWorkspaceMode() {
        return this.inferenceWorkspaceMode;
    }

    public void setInferenceWorkspaceMode(WorkspaceMode inferenceWorkspaceMode) {
        this.inferenceWorkspaceMode = inferenceWorkspaceMode;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public static class GraphBuilder {
        private static final int DEFAULT_TBPTT_LENGTH = 20;
        protected Map<String, GraphVertex> vertices = new LinkedHashMap<String, GraphVertex>();
        protected Map<String, List<String>> vertexInputs = new LinkedHashMap<String, List<String>>();
        protected List<String> networkInputs = new ArrayList<String>();
        protected List<InputType> networkInputTypes = new ArrayList<InputType>();
        protected List<String> networkOutputs = new ArrayList<String>();
        protected BackpropType backpropType = BackpropType.Standard;
        protected int tbpttFwdLength = 20;
        protected int tbpttBackLength = 20;
        protected Map<String, InputPreProcessor> inputPreProcessors = new LinkedHashMap<String, InputPreProcessor>();
        protected NeuralNetConfiguration.Builder globalConfiguration;
        protected boolean allowDisconnected = false;
        protected boolean allowNoOutput = false;
        protected boolean validateOutputConfig = true;
        protected boolean validateTbpttConfig = true;
        protected String lastAdded = null;

        public GraphBuilder(NeuralNetConfiguration.Builder globalConfiguration) {
            this.globalConfiguration = globalConfiguration;
        }

        public GraphBuilder(ComputationGraphConfiguration newConf, NeuralNetConfiguration.Builder globalConfiguration) {
            ComputationGraphConfiguration clonedConf = newConf.clone();
            this.vertices = clonedConf.getVertices();
            this.vertexInputs = clonedConf.getVertexInputs();
            this.networkInputs = clonedConf.getNetworkInputs();
            this.networkOutputs = clonedConf.getNetworkOutputs();
            this.backpropType = clonedConf.getBackpropType();
            this.tbpttFwdLength = clonedConf.getTbpttFwdLength();
            this.tbpttBackLength = clonedConf.getTbpttBackLength();
            this.globalConfiguration = globalConfiguration;
        }

        public GraphBuilder inputPreProcessor(String layer, InputPreProcessor processor) {
            this.inputPreProcessors.put(layer, processor);
            return this;
        }

        public GraphBuilder backpropType(BackpropType type) {
            this.backpropType = type;
            return this;
        }

        public GraphBuilder tBPTTForwardLength(int forwardLength) {
            this.tbpttFwdLength = forwardLength;
            return this;
        }

        public GraphBuilder tBPTTBackwardLength(int backwardLength) {
            this.tbpttBackLength = backwardLength;
            return this;
        }

        public GraphBuilder tBPTTLength(int tbpttLength) {
            this.tBPTTForwardLength(tbpttLength);
            return this.tBPTTBackwardLength(tbpttLength);
        }

        public GraphBuilder addLayer(String layerName, Layer layer, String ... layerInputs) {
            return this.addLayer(layerName, layer, (InputPreProcessor)null, layerInputs);
        }

        public GraphBuilder appendLayer(String layerName, Layer layer) {
            return this.appendLayer(layerName, layer, null);
        }

        public GraphBuilder layer(int layerName, Layer layer, String ... layerInputs) {
            return this.addLayer(String.valueOf(layerName), layer, (InputPreProcessor)null, layerInputs);
        }

        public GraphBuilder layer(String layerName, Layer layer, String ... layerInputs) {
            return this.addLayer(layerName, layer, (InputPreProcessor)null, layerInputs);
        }

        public GraphBuilder addLayer(String layerName, Layer layer, InputPreProcessor preProcessor, String ... layerInputs) {
            NeuralNetConfiguration.Builder builder = this.globalConfiguration.clone();
            builder.layer(layer);
            this.addVertex(layerName, new LayerVertex(builder.build(), preProcessor), layerInputs);
            layer.setLayerName(layerName);
            return this;
        }

        public GraphBuilder appendLayer(String layerName, Layer layer, InputPreProcessor preProcessor) {
            if (this.lastAdded == null) {
                throw new IllegalStateException("Can not use appendLayer with no previous layers");
            }
            this.addLayer(layerName, layer, preProcessor, this.lastAdded);
            return this;
        }

        public GraphBuilder layer(String layerName, Layer layer, InputPreProcessor preProcessor, String ... layerInputs) {
            return this.addLayer(layerName, layer, preProcessor, layerInputs);
        }

        public GraphBuilder removeVertex(String vertexName) {
            this.removeVertex(vertexName, true);
            return this;
        }

        public GraphBuilder removeVertex(String vertexName, boolean removeConnections) {
            this.vertices.remove(vertexName);
            this.vertexInputs.remove(vertexName);
            if (this.networkInputs.contains(vertexName)) {
                this.networkInputs.remove(vertexName);
            }
            if (removeConnections) {
                if (this.networkOutputs.contains(vertexName)) {
                    this.networkOutputs.remove(vertexName);
                }
                LinkedHashMap<String, List<String>> newVertexInputs = new LinkedHashMap<String, List<String>>();
                for (Map.Entry<String, List<String>> entry : this.vertexInputs.entrySet()) {
                    List<String> inputs = entry.getValue();
                    if (inputs.contains(vertexName)) {
                        ArrayList<String> newList = new ArrayList<String>(inputs.size() - 1);
                        for (String s : inputs) {
                            if (vertexName.equals(s)) continue;
                            newList.add(s);
                        }
                        newVertexInputs.put(entry.getKey(), newList);
                        continue;
                    }
                    newVertexInputs.put(entry.getKey(), entry.getValue());
                }
                this.vertexInputs = newVertexInputs;
                if (this.inputPreProcessors.containsKey(vertexName)) {
                    this.inputPreProcessors.remove(vertexName);
                }
            }
            return this;
        }

        public GraphBuilder addInputs(String ... inputNames) {
            Collections.addAll(this.networkInputs, inputNames);
            this.lastAdded = this.networkInputs.get(this.networkInputs.size() - 1);
            return this;
        }

        public GraphBuilder addInputs(Collection<String> inputNames) {
            this.networkInputs.addAll(inputNames);
            this.lastAdded = this.networkInputs.get(this.networkInputs.size() - 1);
            return this;
        }

        public GraphBuilder setInputTypes(InputType ... inputTypes) {
            if (inputTypes != null && inputTypes.length > 0) {
                if (this.networkInputs.size() > 0 && this.networkInputTypes.size() + inputTypes.length != this.networkInputs.size()) {
                    throw new IllegalArgumentException("Invalid number of InputTypes: existing inputTypes (" + this.networkInputTypes.size() + ") + additional inputTypes (" + inputTypes.length + ") != number of network inputs (" + this.networkInputs.size() + ")");
                }
                Collections.addAll(this.networkInputTypes, inputTypes);
            }
            return this;
        }

        public GraphBuilder setOutputs(String ... outputNames) {
            this.networkOutputs.clear();
            Collections.addAll(this.networkOutputs, outputNames);
            return this;
        }

        public GraphBuilder addVertex(String vertexName, GraphVertex vertex, String ... vertexInputs) {
            Preconditions.checkState((!this.vertices.containsKey(vertexName) ? 1 : 0) != 0, (String)"Cannot add vertex: a vertex with name \"%s\" already exists", (Object)vertexName);
            this.vertices.put(vertexName, vertex);
            if (vertex.maxVertexInputs() == 1 && vertexInputs != null && vertexInputs.length > 1) {
                String mergeName = vertexName + "-merge";
                this.addVertex(mergeName, new MergeVertex(), vertexInputs);
                this.vertexInputs.put(vertexName, Collections.singletonList(mergeName));
            } else if (vertexInputs != null) {
                this.vertexInputs.put(vertexName, Arrays.asList(vertexInputs));
            }
            this.lastAdded = vertexName;
            return this;
        }

        public GraphBuilder appendVertex(String vertexName, GraphVertex vertex) {
            if (this.lastAdded == null) {
                throw new IllegalStateException("Can not use appendLayer with no previous layers");
            }
            this.addVertex(vertexName, vertex, this.lastAdded);
            return this;
        }

        public GraphBuilder allowDisconnected(boolean allowDisconnected) {
            this.allowDisconnected = allowDisconnected;
            return this;
        }

        public GraphBuilder allowNoOutput(boolean allowNoOutput) {
            this.allowNoOutput = allowNoOutput;
            return this;
        }

        public GraphBuilder validateOutputLayerConfig(boolean validate) {
            this.validateOutputConfig = validate;
            return this;
        }

        public GraphBuilder validateTbpttConfig(boolean validate) {
            this.validateTbpttConfig = validate;
            return this;
        }

        public Map<String, InputType> getLayerActivationTypes() {
            ComputationGraphConfiguration conf;
            Preconditions.checkArgument((this.networkInputs != null && this.networkInputs.size() > 0 ? 1 : 0) != 0, (String)"Cannot calculate activation types if no inputs have been set (use addInputs(String...))");
            Preconditions.checkArgument((this.networkInputTypes != null && this.networkInputTypes.size() == this.networkInputs.size() ? 1 : 0) != 0, (String)"Cannot calculate layer activation types if network if network input types have notbeen set (use ");
            try {
                conf = this.buildConfig();
            }
            catch (Exception e) {
                throw new RuntimeException("Error calculating activation types for layers: error occured when constructing temporary ComputationGraphConfiguration)", e);
            }
            try {
                conf.validate(true, true);
            }
            catch (Exception e) {
                throw new RuntimeException("Error calculating activation types for layers: validation of temporary ComputationGraphConfiguration failed", e);
            }
            return conf.getLayerActivationTypes(true, this.networkInputTypes.toArray(new InputType[this.networkInputTypes.size()]));
        }

        private ComputationGraphConfiguration buildConfig() {
            if ((this.tbpttBackLength != 20 || this.tbpttFwdLength != 20) && this.backpropType != BackpropType.TruncatedBPTT) {
                log.warn("Truncated backpropagation through time lengths have been configured with values " + this.tbpttFwdLength + " and " + this.tbpttBackLength + " but backprop type is set to " + this.backpropType + ". TBPTT configuration settings will only take effect if backprop type is set to BackpropType.TruncatedBPTT");
            }
            ComputationGraphConfiguration conf = new ComputationGraphConfiguration();
            conf.backpropType = this.backpropType;
            conf.tbpttBackLength = this.tbpttBackLength;
            conf.tbpttFwdLength = this.tbpttFwdLength;
            conf.networkInputs = this.networkInputs;
            conf.networkOutputs = this.networkOutputs;
            conf.vertices = this.vertices;
            conf.vertexInputs = this.vertexInputs;
            conf.trainingWorkspaceMode = this.globalConfiguration.trainingWorkspaceMode;
            conf.inferenceWorkspaceMode = this.globalConfiguration.inferenceWorkspaceMode;
            conf.cacheMode = this.globalConfiguration.cacheMode;
            conf.validateOutputLayerConfig = this.validateOutputConfig;
            conf.dataType = this.globalConfiguration.dataType;
            conf.defaultConfiguration = this.globalConfiguration.build();
            for (Map.Entry<String, InputPreProcessor> entry : this.inputPreProcessors.entrySet()) {
                GraphVertex gv = this.vertices.get(entry.getKey());
                if (gv instanceof LayerVertex) {
                    LayerVertex lv = (LayerVertex)gv;
                    lv.setPreProcessor(entry.getValue());
                    continue;
                }
                throw new IllegalStateException("Invalid configuration: InputPreProcessor defined for GraphVertex \"" + entry.getKey() + "\", but this vertex is not a LayerVertex");
            }
            for (Map.Entry<String, Cloneable> entry : this.vertices.entrySet()) {
                if (entry.getValue() instanceof LayerVertex) {
                    LayerVertex lv = (LayerVertex)entry.getValue();
                    Layer layer = lv.getLayerConf().getLayer();
                }
                if (!(entry.getValue() instanceof SameDiffVertex)) continue;
                ((SameDiffVertex)entry.getValue()).applyGlobalConfig(this.globalConfiguration);
            }
            return conf;
        }

        public ComputationGraphConfiguration build() {
            ComputationGraphConfiguration conf = this.buildConfig();
            conf.validate(this.allowDisconnected, this.allowNoOutput);
            if (!this.networkInputTypes.isEmpty()) {
                conf.addPreProcessors(this.networkInputTypes.toArray(new InputType[this.networkInputs.size()]));
            }
            if (this.validateOutputConfig) {
                for (Map.Entry<String, GraphVertex> e : conf.getVertices().entrySet()) {
                    if (!(e.getValue() instanceof LayerVertex)) continue;
                    Layer l = ((LayerVertex)e.getValue()).getLayerConf().getLayer();
                    OutputLayerUtil.validateOutputLayer(e.getKey(), l);
                }
            }
            if (this.backpropType == BackpropType.TruncatedBPTT && this.validateTbpttConfig) {
                for (Map.Entry<String, GraphVertex> e : this.vertices.entrySet()) {
                    Layer l;
                    GraphVertex gv = e.getValue();
                    Layer layer = l = gv instanceof LayerVertex ? ((LayerVertex)gv).getLayerConf().getLayer() : null;
                    if (!(gv instanceof LastTimeStepVertex) && (l == null || !(l instanceof LastTimeStep) && !(l instanceof GlobalPoolingLayer))) continue;
                    String s = l == null ? gv.getClass().getName() : l.getClass().getName();
                    String n = e.getKey();
                    throw new IllegalStateException("Invalid network configuration detected: Truncated backpropagation through time (TBPTT) cannot be used with layer \"" + n + "\" of type " + s + ": TBPTT is incompatible with this layer type (which is designed to process entire sequences at once, and does support the type of sequence segments that TPBTT uses).\nThis check can be disabled using validateTbpttConfig(false) but this is not recommended.");
                }
            }
            return conf;
        }

        public Map<String, GraphVertex> getVertices() {
            return this.vertices;
        }

        public Map<String, List<String>> getVertexInputs() {
            return this.vertexInputs;
        }

        public List<String> getNetworkInputs() {
            return this.networkInputs;
        }

        public List<InputType> getNetworkInputTypes() {
            return this.networkInputTypes;
        }

        public List<String> getNetworkOutputs() {
            return this.networkOutputs;
        }

        public BackpropType getBackpropType() {
            return this.backpropType;
        }

        public int getTbpttFwdLength() {
            return this.tbpttFwdLength;
        }

        public int getTbpttBackLength() {
            return this.tbpttBackLength;
        }

        public Map<String, InputPreProcessor> getInputPreProcessors() {
            return this.inputPreProcessors;
        }

        public NeuralNetConfiguration.Builder getGlobalConfiguration() {
            return this.globalConfiguration;
        }

        public boolean isAllowDisconnected() {
            return this.allowDisconnected;
        }

        public boolean isAllowNoOutput() {
            return this.allowNoOutput;
        }

        public boolean isValidateOutputConfig() {
            return this.validateOutputConfig;
        }

        public boolean isValidateTbpttConfig() {
            return this.validateTbpttConfig;
        }

        public String getLastAdded() {
            return this.lastAdded;
        }

        public void setVertices(Map<String, GraphVertex> vertices) {
            this.vertices = vertices;
        }

        public void setVertexInputs(Map<String, List<String>> vertexInputs) {
            this.vertexInputs = vertexInputs;
        }

        public void setNetworkInputs(List<String> networkInputs) {
            this.networkInputs = networkInputs;
        }

        public void setNetworkInputTypes(List<InputType> networkInputTypes) {
            this.networkInputTypes = networkInputTypes;
        }

        public void setNetworkOutputs(List<String> networkOutputs) {
            this.networkOutputs = networkOutputs;
        }

        public void setBackpropType(BackpropType backpropType) {
            this.backpropType = backpropType;
        }

        public void setTbpttFwdLength(int tbpttFwdLength) {
            this.tbpttFwdLength = tbpttFwdLength;
        }

        public void setTbpttBackLength(int tbpttBackLength) {
            this.tbpttBackLength = tbpttBackLength;
        }

        public void setInputPreProcessors(Map<String, InputPreProcessor> inputPreProcessors) {
            this.inputPreProcessors = inputPreProcessors;
        }

        public void setGlobalConfiguration(NeuralNetConfiguration.Builder globalConfiguration) {
            this.globalConfiguration = globalConfiguration;
        }

        public void setAllowDisconnected(boolean allowDisconnected) {
            this.allowDisconnected = allowDisconnected;
        }

        public void setAllowNoOutput(boolean allowNoOutput) {
            this.allowNoOutput = allowNoOutput;
        }

        public void setValidateOutputConfig(boolean validateOutputConfig) {
            this.validateOutputConfig = validateOutputConfig;
        }

        public void setValidateTbpttConfig(boolean validateTbpttConfig) {
            this.validateTbpttConfig = validateTbpttConfig;
        }

        public void setLastAdded(String lastAdded) {
            this.lastAdded = lastAdded;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GraphBuilder)) {
                return false;
            }
            GraphBuilder other = (GraphBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTbpttFwdLength() != other.getTbpttFwdLength()) {
                return false;
            }
            if (this.getTbpttBackLength() != other.getTbpttBackLength()) {
                return false;
            }
            if (this.isAllowDisconnected() != other.isAllowDisconnected()) {
                return false;
            }
            if (this.isAllowNoOutput() != other.isAllowNoOutput()) {
                return false;
            }
            if (this.isValidateOutputConfig() != other.isValidateOutputConfig()) {
                return false;
            }
            if (this.isValidateTbpttConfig() != other.isValidateTbpttConfig()) {
                return false;
            }
            Map<String, GraphVertex> this$vertices = this.getVertices();
            Map<String, GraphVertex> other$vertices = other.getVertices();
            if (this$vertices == null ? other$vertices != null : !((Object)this$vertices).equals(other$vertices)) {
                return false;
            }
            Map<String, List<String>> this$vertexInputs = this.getVertexInputs();
            Map<String, List<String>> other$vertexInputs = other.getVertexInputs();
            if (this$vertexInputs == null ? other$vertexInputs != null : !((Object)this$vertexInputs).equals(other$vertexInputs)) {
                return false;
            }
            List<String> this$networkInputs = this.getNetworkInputs();
            List<String> other$networkInputs = other.getNetworkInputs();
            if (this$networkInputs == null ? other$networkInputs != null : !((Object)this$networkInputs).equals(other$networkInputs)) {
                return false;
            }
            List<InputType> this$networkInputTypes = this.getNetworkInputTypes();
            List<InputType> other$networkInputTypes = other.getNetworkInputTypes();
            if (this$networkInputTypes == null ? other$networkInputTypes != null : !((Object)this$networkInputTypes).equals(other$networkInputTypes)) {
                return false;
            }
            List<String> this$networkOutputs = this.getNetworkOutputs();
            List<String> other$networkOutputs = other.getNetworkOutputs();
            if (this$networkOutputs == null ? other$networkOutputs != null : !((Object)this$networkOutputs).equals(other$networkOutputs)) {
                return false;
            }
            BackpropType this$backpropType = this.getBackpropType();
            BackpropType other$backpropType = other.getBackpropType();
            if (this$backpropType == null ? other$backpropType != null : !((Object)((Object)this$backpropType)).equals((Object)other$backpropType)) {
                return false;
            }
            Map<String, InputPreProcessor> this$inputPreProcessors = this.getInputPreProcessors();
            Map<String, InputPreProcessor> other$inputPreProcessors = other.getInputPreProcessors();
            if (this$inputPreProcessors == null ? other$inputPreProcessors != null : !((Object)this$inputPreProcessors).equals(other$inputPreProcessors)) {
                return false;
            }
            NeuralNetConfiguration.Builder this$globalConfiguration = this.getGlobalConfiguration();
            NeuralNetConfiguration.Builder other$globalConfiguration = other.getGlobalConfiguration();
            if (this$globalConfiguration == null ? other$globalConfiguration != null : !((Object)this$globalConfiguration).equals(other$globalConfiguration)) {
                return false;
            }
            String this$lastAdded = this.getLastAdded();
            String other$lastAdded = other.getLastAdded();
            return !(this$lastAdded == null ? other$lastAdded != null : !this$lastAdded.equals(other$lastAdded));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GraphBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTbpttFwdLength();
            result = result * 59 + this.getTbpttBackLength();
            result = result * 59 + (this.isAllowDisconnected() ? 79 : 97);
            result = result * 59 + (this.isAllowNoOutput() ? 79 : 97);
            result = result * 59 + (this.isValidateOutputConfig() ? 79 : 97);
            result = result * 59 + (this.isValidateTbpttConfig() ? 79 : 97);
            Map<String, GraphVertex> $vertices = this.getVertices();
            result = result * 59 + ($vertices == null ? 43 : ((Object)$vertices).hashCode());
            Map<String, List<String>> $vertexInputs = this.getVertexInputs();
            result = result * 59 + ($vertexInputs == null ? 43 : ((Object)$vertexInputs).hashCode());
            List<String> $networkInputs = this.getNetworkInputs();
            result = result * 59 + ($networkInputs == null ? 43 : ((Object)$networkInputs).hashCode());
            List<InputType> $networkInputTypes = this.getNetworkInputTypes();
            result = result * 59 + ($networkInputTypes == null ? 43 : ((Object)$networkInputTypes).hashCode());
            List<String> $networkOutputs = this.getNetworkOutputs();
            result = result * 59 + ($networkOutputs == null ? 43 : ((Object)$networkOutputs).hashCode());
            BackpropType $backpropType = this.getBackpropType();
            result = result * 59 + ($backpropType == null ? 43 : ((Object)((Object)$backpropType)).hashCode());
            Map<String, InputPreProcessor> $inputPreProcessors = this.getInputPreProcessors();
            result = result * 59 + ($inputPreProcessors == null ? 43 : ((Object)$inputPreProcessors).hashCode());
            NeuralNetConfiguration.Builder $globalConfiguration = this.getGlobalConfiguration();
            result = result * 59 + ($globalConfiguration == null ? 43 : ((Object)$globalConfiguration).hashCode());
            String $lastAdded = this.getLastAdded();
            result = result * 59 + ($lastAdded == null ? 43 : $lastAdded.hashCode());
            return result;
        }

        public String toString() {
            return "ComputationGraphConfiguration.GraphBuilder(vertices=" + this.getVertices() + ", vertexInputs=" + this.getVertexInputs() + ", networkInputs=" + this.getNetworkInputs() + ", networkInputTypes=" + this.getNetworkInputTypes() + ", networkOutputs=" + this.getNetworkOutputs() + ", backpropType=" + this.getBackpropType() + ", tbpttFwdLength=" + this.getTbpttFwdLength() + ", tbpttBackLength=" + this.getTbpttBackLength() + ", inputPreProcessors=" + this.getInputPreProcessors() + ", globalConfiguration=" + this.getGlobalConfiguration() + ", allowDisconnected=" + this.isAllowDisconnected() + ", allowNoOutput=" + this.isAllowNoOutput() + ", validateOutputConfig=" + this.isValidateOutputConfig() + ", validateTbpttConfig=" + this.isValidateTbpttConfig() + ", lastAdded=" + this.getLastAdded() + ")";
        }
    }
}

