/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.optimize.listeners;

import java.util.concurrent.atomic.AtomicLong;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.deeplearning4j.optimize.api.IterationListener;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceListener
implements IterationListener {
    private final int frequency;
    private static final Logger logger = LoggerFactory.getLogger(PerformanceListener.class);
    private ThreadLocal<Double> samplesPerSec = new ThreadLocal();
    private ThreadLocal<Double> batchesPerSec = new ThreadLocal();
    private ThreadLocal<Long> lastTime = new ThreadLocal();
    private ThreadLocal<AtomicLong> iterationCount = new ThreadLocal();
    private boolean reportScore;
    private boolean reportSample = true;
    private boolean reportBatch = true;
    private boolean reportIteration = true;
    private boolean reportEtl = true;
    private boolean reportTime = true;

    public PerformanceListener(int frequency) {
        this(frequency, false);
    }

    public PerformanceListener(int frequency, boolean reportScore) {
        this.frequency = frequency;
        this.reportScore = reportScore;
        this.lastTime.set(System.currentTimeMillis());
    }

    @Override
    public boolean invoked() {
        return false;
    }

    @Override
    public void invoke() {
    }

    @Override
    public void iterationDone(Model model, int iteration) {
        if (this.lastTime.get() == null) {
            this.lastTime.set(System.currentTimeMillis());
        }
        if (this.samplesPerSec.get() == null) {
            this.samplesPerSec.set(0.0);
        }
        if (this.batchesPerSec.get() == null) {
            this.batchesPerSec.set(0.0);
        }
        if (this.iterationCount.get() == null) {
            this.iterationCount.set(new AtomicLong(0L));
        }
        if (this.iterationCount.get().getAndIncrement() % (long)this.frequency == 0L) {
            ComputationGraph cg;
            INDArray[] inputs;
            long currentTime = System.currentTimeMillis();
            long timeSpent = currentTime - this.lastTime.get();
            float timeSec = (float)timeSpent / 1000.0f;
            INDArray input = model instanceof ComputationGraph ? ((inputs = (cg = (ComputationGraph)model).getInputs()) != null && inputs.length > 0 ? inputs[0] : model.input()) : model.input();
            long numSamples = input.size(0);
            this.samplesPerSec.set(Double.valueOf((float)numSamples / timeSec));
            this.batchesPerSec.set(Double.valueOf(1.0f / timeSec));
            StringBuilder builder = new StringBuilder();
            if (Nd4j.getAffinityManager().getNumberOfDevices() > 1) {
                builder.append("Device: [").append(Nd4j.getAffinityManager().getDeviceForCurrentThread()).append("]; ");
            }
            if (this.reportEtl) {
                long time = model instanceof MultiLayerNetwork ? ((MultiLayerNetwork)model).getLastEtlTime() : ((ComputationGraph)model).getLastEtlTime();
                builder.append("ETL: ").append(time).append(" ms; ");
            }
            if (this.reportIteration) {
                builder.append("iteration ").append(this.iterationCount.get().get()).append("; ");
            }
            if (this.reportTime) {
                builder.append("iteration time: ").append(timeSpent).append(" ms; ");
            }
            if (this.reportSample) {
                builder.append("samples/sec: ").append(String.format("%.3f", this.samplesPerSec.get())).append("; ");
            }
            if (this.reportBatch) {
                builder.append("batches/sec: ").append(String.format("%.3f", this.batchesPerSec.get())).append("; ");
            }
            if (this.reportScore) {
                builder.append("score: ").append(model.score()).append(";");
            }
            logger.info(builder.toString());
        }
        this.lastTime.set(System.currentTimeMillis());
    }

    public static class Builder {
        private int frequency = 1;
        private boolean reportScore;
        private boolean reportSample = true;
        private boolean reportBatch = true;
        private boolean reportIteration = true;
        private boolean reportTime = true;
        private boolean reportEtl = true;

        public Builder reportIteration(boolean reallyReport) {
            this.reportIteration = reallyReport;
            return this;
        }

        public Builder reportTime(boolean reallyReport) {
            this.reportTime = reallyReport;
            return this;
        }

        public Builder reportETL(boolean reallyReport) {
            this.reportEtl = reallyReport;
            return this;
        }

        public Builder reportSample(boolean reallyReport) {
            this.reportSample = reallyReport;
            return this;
        }

        public Builder reportBatch(boolean reallyReport) {
            this.reportBatch = reallyReport;
            return this;
        }

        public Builder reportScore(boolean reallyReport) {
            this.reportScore = reallyReport;
            return this;
        }

        public Builder setFrequency(int frequency) {
            this.frequency = frequency;
            return this;
        }

        public PerformanceListener build() {
            PerformanceListener listener = new PerformanceListener(this.frequency, this.reportScore);
            listener.reportIteration = this.reportIteration;
            listener.reportTime = this.reportTime;
            listener.reportBatch = this.reportBatch;
            listener.reportSample = this.reportSample;
            return listener;
        }
    }
}

