/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.MaskState;
import org.deeplearning4j.nn.conf.CacheMode;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.optimize.api.ConvexOptimizer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.Dropout;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;

public abstract class AbstractLayer<LayerConfT extends Layer>
implements org.deeplearning4j.nn.api.Layer {
    protected INDArray input;
    protected INDArray preOutput;
    protected NeuralNetConfiguration conf;
    protected INDArray dropoutMask;
    protected boolean dropoutApplied = false;
    protected Collection<IterationListener> iterationListeners = new ArrayList<IterationListener>();
    protected int index = 0;
    protected INDArray maskArray;
    protected MaskState maskState;
    protected CacheMode cacheMode = CacheMode.NONE;

    public AbstractLayer(NeuralNetConfiguration conf) {
        this.conf = conf;
        this.cacheMode = conf.getCacheMode();
    }

    public AbstractLayer(NeuralNetConfiguration conf, INDArray input) {
        this(conf);
        this.input = input;
    }

    @Override
    public void setCacheMode(CacheMode mode) {
        if (mode == null) {
            mode = CacheMode.NONE;
        }
        this.cacheMode = mode;
    }

    protected LayerConfT layerConf() {
        return (LayerConfT)this.conf.getLayer();
    }

    protected String layerId() {
        String name = this.conf().getLayer().getLayerName();
        return "(layer name: " + (name == null ? "\"\"" : name) + ", layer index: " + this.index + ")";
    }

    public INDArray getInput() {
        return this.input;
    }

    @Override
    public void init() {
    }

    @Override
    public abstract org.deeplearning4j.nn.api.Layer clone();

    @Override
    public void setInput(INDArray input) {
        this.input = input;
        this.dropoutApplied = false;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public Collection<IterationListener> getListeners() {
        return this.iterationListeners;
    }

    @Override
    public void setListeners(Collection<IterationListener> listeners) {
        this.iterationListeners = listeners != null ? listeners : new ArrayList();
    }

    @Override
    public void addListeners(IterationListener ... listeners) {
        if (this.iterationListeners == null) {
            this.setListeners(listeners);
            return;
        }
        for (IterationListener listener : listeners) {
            this.iterationListeners.add(listener);
        }
    }

    @Override
    public void setListeners(IterationListener ... listeners) {
        this.setListeners(Arrays.asList(listeners));
    }

    @Override
    public Gradient error(INDArray errorSignal) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    @Deprecated
    public INDArray derivativeActivation(INDArray input) {
        throw new UnsupportedOperationException("Deprecated - " + this.layerId());
    }

    @Override
    public Gradient calcGradient(Gradient layerError, INDArray activation) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void computeGradientAndScore() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public INDArray preOutput(INDArray x, Layer.TrainingMode training) {
        return this.preOutput(x, training == Layer.TrainingMode.TRAIN);
    }

    @Override
    public INDArray activate(Layer.TrainingMode training) {
        return this.activate(training == Layer.TrainingMode.TRAIN);
    }

    @Override
    public INDArray activate(INDArray input, Layer.TrainingMode training) {
        return this.activate(input, training == Layer.TrainingMode.TRAIN);
    }

    @Override
    public void iterate(INDArray input) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(Gradient gradient) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(INDArray gradient, String paramType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConvexOptimizer getOptimizer() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setConf(NeuralNetConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public INDArray params() {
        return null;
    }

    @Override
    public INDArray getParam(String param) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setParam(String key, INDArray val) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setParams(INDArray params) {
        if (params != null) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    protected void setParams(INDArray params, char order) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setParamsViewArray(INDArray params) {
        if (params != null) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    @Override
    public INDArray getGradientsViewArray() {
        return null;
    }

    @Override
    public void setBackpropGradientsViewArray(INDArray gradients) {
        if (gradients != null) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    @Override
    public void setParamTable(Map<String, INDArray> paramTable) {
        if (paramTable != null && !paramTable.isEmpty()) {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    @Override
    public void initParams() {
        throw new UnsupportedOperationException("Deprecated - no longer used - " + this.layerId());
    }

    @Override
    public Map<String, INDArray> paramTable() {
        return this.paramTable(false);
    }

    @Override
    public Map<String, INDArray> paramTable(boolean backpropParamsOnly) {
        return Collections.emptyMap();
    }

    @Override
    public INDArray preOutput(INDArray x, boolean training) {
        if (x == null) {
            throw new IllegalArgumentException("Cannot do forward pass with null input " + this.layerId());
        }
        this.setInput(x);
        return this.preOutput(training);
    }

    public abstract INDArray preOutput(boolean var1);

    protected void applyMask(INDArray to) {
        to.muliColumnVector(this.maskArray);
    }

    @Override
    public INDArray activate(INDArray input) {
        this.setInput(input);
        return this.activate(true);
    }

    @Override
    public INDArray activate(INDArray input, boolean training) {
        this.setInput(input);
        return this.activate(training);
    }

    @Override
    public INDArray activate() {
        return this.activate(false);
    }

    @Override
    public INDArray preOutput(INDArray x) {
        return this.preOutput(x, true);
    }

    @Override
    public double calcL2(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public double calcL1(boolean backpropParamsOnly) {
        return 0.0;
    }

    @Override
    public int batchSize() {
        return this.input.size(0);
    }

    @Override
    public NeuralNetConfiguration conf() {
        return this.conf;
    }

    @Override
    public void clear() {
        this.input = null;
    }

    protected void applyDropOutIfNecessary(boolean training) {
        if (((Layer)this.layerConf()).getDropOut() > 0.0 && !this.conf.isUseDropConnect() && training && !this.dropoutApplied) {
            if (Nd4j.getWorkspaceManager().checkIfWorkspaceExists("LOOP_EXTERNAL")) {
                try (MemoryWorkspace ws = Nd4j.getWorkspaceManager().getWorkspaceForCurrentThread("LOOP_EXTERNAL").notifyScopeBorrowed();){
                    this.input = this.input.isView() ? this.input.dup() : this.input.unsafeDuplication();
                }
            } else {
                this.input = this.input.isView() ? this.input.dup() : this.input.unsafeDuplication();
            }
            Dropout.applyDropout(this.input, ((Layer)this.layerConf()).getDropOut());
            this.dropoutApplied = true;
        }
    }

    @Override
    public void merge(org.deeplearning4j.nn.api.Layer l, int batchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Layer.Type type() {
        return Layer.Type.FEED_FORWARD;
    }

    @Override
    public int numParams() {
        return 0;
    }

    @Override
    public int numParams(boolean backwards) {
        return this.numParams();
    }

    @Override
    public void fit(INDArray input) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public Pair<Gradient, Double> gradientAndScore() {
        return new Pair((Object)this.gradient(), (Object)this.score());
    }

    @Override
    public INDArray input() {
        return this.input;
    }

    @Override
    public void validateInput() {
    }

    @Override
    public org.deeplearning4j.nn.api.Layer transpose() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setInputMiniBatchSize(int size) {
    }

    @Override
    public int getInputMiniBatchSize() {
        return this.input.size(0);
    }

    @Override
    public void applyLearningRateScoreDecay() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setMaskArray(INDArray maskArray) {
        this.maskArray = maskArray;
    }

    @Override
    public INDArray getMaskArray() {
        return this.maskArray;
    }

    @Override
    public Pair<INDArray, MaskState> feedForwardMaskArray(INDArray maskArray, MaskState currentMaskState, int minibatchSize) {
        this.maskArray = maskArray;
        this.maskState = currentMaskState;
        return new Pair((Object)maskArray, (Object)currentMaskState);
    }

    @Override
    public Gradient gradient() {
        throw new UnsupportedOperationException("Not supported for this layer, or should be overridden for layers requiring it");
    }

    @Override
    public void fit() {
        throw new UnsupportedOperationException("Not supported for this layer, or should be overridden for layers requiring it");
    }

    @Override
    public double score() {
        throw new UnsupportedOperationException("Not supported for this layer, or should be overridden for layers requiring it");
    }

    @Override
    public void accumulateScore(double accum) {
        throw new UnsupportedOperationException("Not supported for this layer, or should be overridden for layers requiring it");
    }

    public INDArray getPreOutput() {
        return this.preOutput;
    }

    public NeuralNetConfiguration getConf() {
        return this.conf;
    }

    public INDArray getDropoutMask() {
        return this.dropoutMask;
    }

    public boolean isDropoutApplied() {
        return this.dropoutApplied;
    }

    public Collection<IterationListener> getIterationListeners() {
        return this.iterationListeners;
    }

    public MaskState getMaskState() {
        return this.maskState;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setPreOutput(INDArray preOutput) {
        this.preOutput = preOutput;
    }

    public void setDropoutMask(INDArray dropoutMask) {
        this.dropoutMask = dropoutMask;
    }

    public void setDropoutApplied(boolean dropoutApplied) {
        this.dropoutApplied = dropoutApplied;
    }

    public void setIterationListeners(Collection<IterationListener> iterationListeners) {
        this.iterationListeners = iterationListeners;
    }

    public void setMaskState(MaskState maskState) {
        this.maskState = maskState;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractLayer)) {
            return false;
        }
        AbstractLayer other = (AbstractLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        INDArray this$input = this.getInput();
        INDArray other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        INDArray this$preOutput = this.getPreOutput();
        INDArray other$preOutput = other.getPreOutput();
        if (this$preOutput == null ? other$preOutput != null : !this$preOutput.equals(other$preOutput)) {
            return false;
        }
        NeuralNetConfiguration this$conf = this.getConf();
        NeuralNetConfiguration other$conf = other.getConf();
        if (this$conf == null ? other$conf != null : !((Object)this$conf).equals(other$conf)) {
            return false;
        }
        INDArray this$dropoutMask = this.getDropoutMask();
        INDArray other$dropoutMask = other.getDropoutMask();
        if (this$dropoutMask == null ? other$dropoutMask != null : !this$dropoutMask.equals(other$dropoutMask)) {
            return false;
        }
        if (this.isDropoutApplied() != other.isDropoutApplied()) {
            return false;
        }
        Collection<IterationListener> this$iterationListeners = this.getIterationListeners();
        Collection<IterationListener> other$iterationListeners = other.getIterationListeners();
        if (this$iterationListeners == null ? other$iterationListeners != null : !((Object)this$iterationListeners).equals(other$iterationListeners)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        INDArray this$maskArray = this.getMaskArray();
        INDArray other$maskArray = other.getMaskArray();
        if (this$maskArray == null ? other$maskArray != null : !this$maskArray.equals(other$maskArray)) {
            return false;
        }
        MaskState this$maskState = this.getMaskState();
        MaskState other$maskState = other.getMaskState();
        if (this$maskState == null ? other$maskState != null : !((Object)((Object)this$maskState)).equals((Object)other$maskState)) {
            return false;
        }
        CacheMode this$cacheMode = this.getCacheMode();
        CacheMode other$cacheMode = other.getCacheMode();
        return !(this$cacheMode == null ? other$cacheMode != null : !((Object)((Object)this$cacheMode)).equals((Object)other$cacheMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractLayer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        INDArray $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        INDArray $preOutput = this.getPreOutput();
        result = result * 59 + ($preOutput == null ? 43 : $preOutput.hashCode());
        NeuralNetConfiguration $conf = this.getConf();
        result = result * 59 + ($conf == null ? 43 : ((Object)$conf).hashCode());
        INDArray $dropoutMask = this.getDropoutMask();
        result = result * 59 + ($dropoutMask == null ? 43 : $dropoutMask.hashCode());
        result = result * 59 + (this.isDropoutApplied() ? 79 : 97);
        Collection<IterationListener> $iterationListeners = this.getIterationListeners();
        result = result * 59 + ($iterationListeners == null ? 43 : ((Object)$iterationListeners).hashCode());
        result = result * 59 + this.getIndex();
        INDArray $maskArray = this.getMaskArray();
        result = result * 59 + ($maskArray == null ? 43 : $maskArray.hashCode());
        MaskState $maskState = this.getMaskState();
        result = result * 59 + ($maskState == null ? 43 : ((Object)((Object)$maskState)).hashCode());
        CacheMode $cacheMode = this.getCacheMode();
        result = result * 59 + ($cacheMode == null ? 43 : ((Object)((Object)$cacheMode)).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractLayer(input=" + this.getInput() + ", preOutput=" + this.getPreOutput() + ", conf=" + this.getConf() + ", dropoutMask=" + this.getDropoutMask() + ", dropoutApplied=" + this.isDropoutApplied() + ", iterationListeners=" + this.getIterationListeners() + ", index=" + this.getIndex() + ", maskArray=" + this.getMaskArray() + ", maskState=" + (Object)((Object)this.getMaskState()) + ", cacheMode=" + (Object)((Object)this.getCacheMode()) + ")";
    }

    public AbstractLayer() {
    }
}

