/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.beans.ConstructorProperties;
import org.deeplearning4j.nn.conf.layers.BaseRecurrentLayer;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.activations.impl.ActivationSigmoid;

public abstract class AbstractLSTM
extends BaseRecurrentLayer {
    protected double forgetGateBiasInit;
    protected IActivation gateActivationFn = new ActivationSigmoid();

    protected AbstractLSTM(Builder builder) {
        super(builder);
        this.forgetGateBiasInit = builder.forgetGateBiasInit;
        this.gateActivationFn = builder.gateActivationFn;
    }

    @Override
    public double getL1ByParam(String paramName) {
        switch (paramName) {
            case "W": 
            case "RW": {
                return this.l1;
            }
            case "b": {
                return this.l1Bias;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getL2ByParam(String paramName) {
        switch (paramName) {
            case "W": 
            case "RW": {
                return this.l2;
            }
            case "b": {
                return this.l2Bias;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    @Override
    public double getLearningRateByParam(String paramName) {
        switch (paramName) {
            case "W": 
            case "RW": {
                return this.learningRate;
            }
            case "b": {
                if (!Double.isNaN(this.biasLearningRate)) {
                    return this.biasLearningRate;
                }
                return this.learningRate;
            }
        }
        throw new IllegalArgumentException("Unknown parameter name: \"" + paramName + "\"");
    }

    public double getForgetGateBiasInit() {
        return this.forgetGateBiasInit;
    }

    public IActivation getGateActivationFn() {
        return this.gateActivationFn;
    }

    public void setForgetGateBiasInit(double forgetGateBiasInit) {
        this.forgetGateBiasInit = forgetGateBiasInit;
    }

    public void setGateActivationFn(IActivation gateActivationFn) {
        this.gateActivationFn = gateActivationFn;
    }

    public AbstractLSTM() {
    }

    @Override
    public String toString() {
        return "AbstractLSTM(super=" + super.toString() + ", forgetGateBiasInit=" + this.getForgetGateBiasInit() + ", gateActivationFn=" + this.getGateActivationFn() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractLSTM)) {
            return false;
        }
        AbstractLSTM other = (AbstractLSTM)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getForgetGateBiasInit(), other.getForgetGateBiasInit()) != 0) {
            return false;
        }
        IActivation this$gateActivationFn = this.getGateActivationFn();
        IActivation other$gateActivationFn = other.getGateActivationFn();
        return !(this$gateActivationFn == null ? other$gateActivationFn != null : !this$gateActivationFn.equals(other$gateActivationFn));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractLSTM;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $forgetGateBiasInit = Double.doubleToLongBits(this.getForgetGateBiasInit());
        result = result * 59 + (int)($forgetGateBiasInit >>> 32 ^ $forgetGateBiasInit);
        IActivation $gateActivationFn = this.getGateActivationFn();
        result = result * 59 + ($gateActivationFn == null ? 43 : $gateActivationFn.hashCode());
        return result;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseRecurrentLayer.Builder<T> {
        protected double forgetGateBiasInit = 1.0;
        protected IActivation gateActivationFn = new ActivationSigmoid();

        public T forgetGateBiasInit(double biasInit) {
            this.forgetGateBiasInit = biasInit;
            return (T)this;
        }

        public T gateActivationFunction(String gateActivationFn) {
            return this.gateActivationFunction(Activation.fromString((String)gateActivationFn));
        }

        public T gateActivationFunction(Activation gateActivationFn) {
            return this.gateActivationFunction(gateActivationFn.getActivationFunction());
        }

        public T gateActivationFunction(IActivation gateActivationFn) {
            this.gateActivationFn = gateActivationFn;
            return (T)this;
        }

        @ConstructorProperties(value={"forgetGateBiasInit", "gateActivationFn"})
        public Builder(double forgetGateBiasInit, IActivation gateActivationFn) {
            this.forgetGateBiasInit = forgetGateBiasInit;
            this.gateActivationFn = gateActivationFn;
        }

        public Builder() {
        }
    }
}

