/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.sentenceiterator.interoperability;

import java.util.List;
import lombok.NonNull;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.deeplearning4j.text.documentiterator.LabelsSource;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.labelaware.LabelAwareSentenceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SentenceIteratorConverter
implements LabelAwareIterator {
    private SentenceIterator backendIterator;
    private LabelsSource generator;
    protected static final Logger log = LoggerFactory.getLogger(SentenceIteratorConverter.class);

    public SentenceIteratorConverter(@NonNull SentenceIterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        this.backendIterator = iterator;
        this.generator = new LabelsSource();
    }

    public SentenceIteratorConverter(@NonNull SentenceIterator iterator, @NonNull LabelsSource generator) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        if (generator == null) {
            throw new NullPointerException("generator is marked non-null but is null");
        }
        this.backendIterator = iterator;
        this.generator = generator;
    }

    @Override
    public boolean hasNextDocument() {
        return this.backendIterator.hasNext();
    }

    @Override
    public LabelledDocument nextDocument() {
        LabelledDocument document = new LabelledDocument();
        document.setContent(this.backendIterator.nextSentence());
        if (this.backendIterator instanceof LabelAwareSentenceIterator) {
            List<String> labels = ((LabelAwareSentenceIterator)this.backendIterator).currentLabels();
            if (labels != null) {
                for (String label : labels) {
                    document.addLabel(label);
                    this.generator.storeLabel(label);
                }
            } else {
                String label = ((LabelAwareSentenceIterator)this.backendIterator).currentLabel();
                if (label != null) {
                    document.addLabel(label);
                    this.generator.storeLabel(label);
                }
            }
        } else if (this.generator != null) {
            document.addLabel(this.generator.nextLabel());
        }
        return document;
    }

    @Override
    public void reset() {
        this.generator.reset();
        this.backendIterator.reset();
    }

    @Override
    public boolean hasNext() {
        return this.hasNextDocument();
    }

    @Override
    public LabelledDocument next() {
        return this.nextDocument();
    }

    @Override
    public void remove() {
    }

    @Override
    public LabelsSource getLabelsSource() {
        return this.generator;
    }

    @Override
    public void shutdown() {
    }
}

