/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.text.documentiterator;

import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.deeplearning4j.text.documentiterator.DocumentIterator;
import org.deeplearning4j.text.documentiterator.LabelAwareDocumentIterator;
import org.deeplearning4j.text.documentiterator.LabelAwareIterator;
import org.deeplearning4j.text.documentiterator.LabelledDocument;
import org.deeplearning4j.text.documentiterator.LabelsSource;
import org.deeplearning4j.text.documentiterator.interoperability.DocumentIteratorConverter;
import org.deeplearning4j.text.sentenceiterator.SentenceIterator;
import org.deeplearning4j.text.sentenceiterator.interoperability.SentenceIteratorConverter;
import org.deeplearning4j.text.sentenceiterator.labelaware.LabelAwareSentenceIterator;

public class BasicLabelAwareIterator
implements LabelAwareIterator {
    protected AtomicLong documentPosition = new AtomicLong(0L);
    protected LabelsSource generator;
    protected transient LabelAwareIterator backendIterator;

    private BasicLabelAwareIterator() {
    }

    @Override
    public boolean hasNextDocument() {
        return this.backendIterator.hasNextDocument();
    }

    @Override
    public LabelledDocument nextDocument() {
        return this.backendIterator.nextDocument();
    }

    @Override
    public void reset() {
        this.backendIterator.reset();
    }

    @Override
    public LabelsSource getLabelsSource() {
        return this.generator;
    }

    @Override
    public boolean hasNext() {
        return this.hasNextDocument();
    }

    @Override
    public LabelledDocument next() {
        return this.nextDocument();
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void remove() {
    }

    public static class Builder {
        private String labelTemplate = "DOC_";
        private LabelAwareIterator labelAwareIterator;
        private LabelsSource generator = new LabelsSource(this.labelTemplate);

        protected Builder() {
        }

        public Builder(@NonNull SentenceIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked non-null but is null");
            }
            this.labelAwareIterator = new SentenceIteratorConverter(iterator, this.generator);
        }

        public Builder(@NonNull DocumentIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked non-null but is null");
            }
            this.labelAwareIterator = new DocumentIteratorConverter(iterator, this.generator);
        }

        public Builder(@NonNull LabelAwareSentenceIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked non-null but is null");
            }
            this.labelAwareIterator = new SentenceIteratorConverter(iterator, this.generator);
        }

        public Builder(@NonNull LabelAwareDocumentIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked non-null but is null");
            }
            this.labelAwareIterator = new DocumentIteratorConverter(iterator, this.generator);
        }

        public Builder(@NonNull LabelAwareIterator iterator) {
            if (iterator == null) {
                throw new NullPointerException("iterator is marked non-null but is null");
            }
            this.labelAwareIterator = iterator;
            this.generator = iterator.getLabelsSource();
        }

        public Builder setLabelTemplate(@NonNull String template) {
            if (template == null) {
                throw new NullPointerException("template is marked non-null but is null");
            }
            this.labelTemplate = template;
            this.generator.setTemplate(template);
            return this;
        }

        public Builder setLabelsSource(@NonNull LabelsSource source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.generator = source;
            return this;
        }

        public BasicLabelAwareIterator build() {
            BasicLabelAwareIterator iterator = new BasicLabelAwareIterator();
            iterator.generator = this.generator;
            iterator.backendIterator = this.labelAwareIterator;
            return iterator;
        }
    }
}

