/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.models.sequencevectors.graph.walkers.impl;

import java.util.List;
import java.util.Random;
import lombok.NonNull;
import org.deeplearning4j.models.sequencevectors.graph.enums.NoEdgeHandling;
import org.deeplearning4j.models.sequencevectors.graph.enums.WalkDirection;
import org.deeplearning4j.models.sequencevectors.graph.exception.NoEdgesException;
import org.deeplearning4j.models.sequencevectors.graph.primitives.Edge;
import org.deeplearning4j.models.sequencevectors.graph.primitives.IGraph;
import org.deeplearning4j.models.sequencevectors.graph.primitives.Vertex;
import org.deeplearning4j.models.sequencevectors.graph.walkers.GraphWalker;
import org.deeplearning4j.models.sequencevectors.graph.walkers.impl.RandomWalker;
import org.deeplearning4j.models.sequencevectors.sequence.Sequence;
import org.deeplearning4j.models.sequencevectors.sequence.SequenceElement;

public class WeightedWalker<T extends SequenceElement>
extends RandomWalker<T>
implements GraphWalker<T> {
    protected WeightedWalker() {
    }

    @Override
    public boolean hasNext() {
        return super.hasNext();
    }

    @Override
    public boolean isLabelEnabled() {
        return false;
    }

    @Override
    public Sequence<T> next() {
        int currentPoint;
        Sequence sequence = new Sequence();
        int startPosition = this.position.getAndIncrement();
        int lastId = -1;
        int startPoint = currentPoint = this.order[startPosition];
        block6: for (int i = 0; i < this.walkLength; ++i) {
            if (this.alpha > 0.0 && lastId != startPoint && lastId != -1 && this.alpha > this.rng.nextDouble()) {
                startPosition = startPoint;
                continue;
            }
            Vertex vertex = this.sourceGraph.getVertex(currentPoint);
            sequence.addElement(vertex.getValue());
            List edges = this.sourceGraph.getEdgesOut(currentPoint);
            if (edges == null || edges.isEmpty()) {
                switch (this.noEdgeHandling) {
                    case CUTOFF_ON_DISCONNECTED: {
                        i = this.walkLength;
                        break;
                    }
                    case EXCEPTION_ON_DISCONNECTED: {
                        throw new NoEdgesException("No available edges left");
                    }
                    case PADDING_ON_DISCONNECTED: {
                        throw new UnsupportedOperationException("Padding isn't implemented yet");
                    }
                    case RESTART_ON_DISCONNECTED: {
                        currentPoint = this.order[startPosition];
                        break;
                    }
                }
                continue;
            }
            double totalWeight = 0.0;
            for (Edge edge : edges) {
                totalWeight += ((Number)edge.getValue()).doubleValue();
            }
            double d = this.rng.nextDouble();
            double threshold = d * totalWeight;
            double sumWeight = 0.0;
            for (Edge edge : edges) {
                if (!((sumWeight += ((Number)edge.getValue()).doubleValue()) >= threshold)) continue;
                currentPoint = edge.isDirected() ? edge.getTo() : (edge.getFrom() == currentPoint ? edge.getTo() : edge.getFrom());
                lastId = currentPoint;
                continue block6;
            }
        }
        return sequence;
    }

    @Override
    public void reset(boolean shuffle) {
        super.reset(shuffle);
    }

    public static class Builder<T extends SequenceElement>
    extends RandomWalker.Builder<T> {
        public Builder(IGraph<T, ? extends Number> sourceGraph) {
            super(sourceGraph);
        }

        @Override
        public Builder<T> setWalkLength(int walkLength) {
            super.setWalkLength(walkLength);
            return this;
        }

        @Override
        public Builder<T> setNoEdgeHandling(@NonNull NoEdgeHandling handling) {
            if (handling == null) {
                throw new NullPointerException("handling is marked non-null but is null");
            }
            super.setNoEdgeHandling(handling);
            return this;
        }

        @Override
        public Builder<T> setSeed(long seed) {
            super.setSeed(seed);
            return this;
        }

        @Override
        public Builder<T> setWalkDirection(@NonNull WalkDirection direction) {
            if (direction == null) {
                throw new NullPointerException("direction is marked non-null but is null");
            }
            super.setWalkDirection(direction);
            return this;
        }

        @Override
        public RandomWalker.Builder<T> setRestartProbability(double alpha) {
            return super.setRestartProbability(alpha);
        }

        @Override
        public WeightedWalker<T> build() {
            WeightedWalker walker = new WeightedWalker();
            walker.noEdgeHandling = this.noEdgeHandling;
            walker.sourceGraph = this.sourceGraph;
            walker.walkLength = this.walkLength;
            walker.seed = this.seed;
            walker.walkDirection = this.walkDirection;
            walker.alpha = this.alpha;
            walker.order = new int[this.sourceGraph.numVertices()];
            for (int i = 0; i < walker.order.length; ++i) {
                walker.order[i] = i;
            }
            if (this.seed != 0L) {
                walker.rng = new Random(this.seed);
            }
            return walker;
        }
    }
}

