/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.iterator.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import lombok.NonNull;
import org.deeplearning4j.iterator.LabeledPairSentenceProvider;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.Triple;
import org.nd4j.common.util.MathUtils;

public class CollectionLabeledPairSentenceProvider
implements LabeledPairSentenceProvider {
    private final List<String> sentenceL;
    private final List<String> sentenceR;
    private final List<String> labels;
    private final Random rng;
    private final int[] order;
    private final List<String> allLabels;
    private int cursor = 0;

    public CollectionLabeledPairSentenceProvider(@NonNull List<String> sentenceL, @NonNull List<String> sentenceR, @NonNull List<String> labelsForSentences) {
        this(sentenceL, sentenceR, labelsForSentences, new Random());
        if (sentenceL == null) {
            throw new NullPointerException("sentenceL is marked non-null but is null");
        }
        if (sentenceR == null) {
            throw new NullPointerException("sentenceR is marked non-null but is null");
        }
        if (labelsForSentences == null) {
            throw new NullPointerException("labelsForSentences is marked non-null but is null");
        }
    }

    public CollectionLabeledPairSentenceProvider(@NonNull List<String> sentenceL, List<String> sentenceR, @NonNull List<String> labelsForSentences, Random rng) {
        if (sentenceL == null) {
            throw new NullPointerException("sentenceL is marked non-null but is null");
        }
        if (labelsForSentences == null) {
            throw new NullPointerException("labelsForSentences is marked non-null but is null");
        }
        if (sentenceR.size() != sentenceL.size()) {
            throw new IllegalArgumentException("Sentence lists must be same size (first list size: " + sentenceL.size() + ", second list size: " + sentenceR.size() + ")");
        }
        if (sentenceR.size() != labelsForSentences.size()) {
            throw new IllegalArgumentException("Sentence pairs and labels must be same size (sentence pair size: " + sentenceR.size() + ", labels size: " + labelsForSentences.size() + ")");
        }
        this.sentenceL = sentenceL;
        this.sentenceR = sentenceR;
        this.labels = labelsForSentences;
        this.rng = rng;
        if (rng == null) {
            this.order = null;
        } else {
            this.order = new int[sentenceR.size()];
            for (int i = 0; i < sentenceR.size(); ++i) {
                this.order[i] = i;
            }
            MathUtils.shuffleArray((int[])this.order, (Random)rng);
        }
        HashSet<String> uniqueLabels = new HashSet<String>(labelsForSentences);
        this.allLabels = new ArrayList<String>(uniqueLabels);
        Collections.sort(this.allLabels);
    }

    @Override
    public boolean hasNext() {
        return this.cursor < this.sentenceR.size();
    }

    @Override
    public Triple<String, String, String> nextSentencePair() {
        Preconditions.checkState((boolean)this.hasNext(), (String)"No next element available");
        int idx = this.rng == null ? this.cursor++ : this.order[this.cursor++];
        return new Triple((Object)this.sentenceL.get(idx), (Object)this.sentenceR.get(idx), (Object)this.labels.get(idx));
    }

    @Override
    public void reset() {
        this.cursor = 0;
        if (this.rng != null) {
            MathUtils.shuffleArray((int[])this.order, (Random)this.rng);
        }
    }

    @Override
    public int totalNumSentences() {
        return this.sentenceR.size();
    }

    @Override
    public List<String> allLabels() {
        return this.allLabels;
    }

    @Override
    public int numLabelClasses() {
        return this.allLabels.size();
    }
}

