/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.modelimport.keras.layers.core;

import java.util.Map;
import org.deeplearning4j.nn.conf.inputs.InputType;
import org.deeplearning4j.nn.conf.layers.samediff.SameDiffLayer;
import org.deeplearning4j.nn.modelimport.keras.KerasLayer;
import org.deeplearning4j.nn.modelimport.keras.exceptions.InvalidKerasConfigurationException;
import org.deeplearning4j.nn.modelimport.keras.exceptions.UnsupportedKerasConfigurationException;

public class KerasLambda
extends KerasLayer {
    public KerasLambda(Map<String, Object> layerConfig, SameDiffLayer sameDiffLayer) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        this(layerConfig, true, sameDiffLayer);
    }

    public KerasLambda(Map<String, Object> layerConfig, boolean enforceTrainingConfig, SameDiffLayer sameDiffLayer) throws InvalidKerasConfigurationException, UnsupportedKerasConfigurationException {
        super(layerConfig, enforceTrainingConfig);
        sameDiffLayer.setLayerName(this.layerName);
        this.layer = sameDiffLayer;
    }

    @Override
    public InputType getOutputType(InputType ... inputType) throws InvalidKerasConfigurationException {
        if (inputType.length > 1) {
            throw new InvalidKerasConfigurationException("Keras SameDiff layer accepts only one input (received " + inputType.length + ")");
        }
        return this.getSameDiffLayer().getOutputType(-1, inputType[0]);
    }

    public SameDiffLayer getSameDiffLayer() {
        return (SameDiffLayer)this.layer;
    }
}

