/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.io.IOException;
import org.deeplearning4j.datasets.base.IrisUtils;
import org.nd4j.linalg.dataset.api.iterator.fetcher.BaseDataFetcher;

public class IrisDataFetcher
extends BaseDataFetcher {
    private static final long serialVersionUID = 4566329799221375262L;
    public static final int NUM_EXAMPLES = 150;

    public IrisDataFetcher() {
        this.numOutcomes = 3;
        this.inputColumns = 4;
        this.totalExamples = 150;
    }

    public void fetch(int numExamples) {
        int from = this.cursor;
        int to = this.cursor + numExamples;
        if (to > this.totalExamples) {
            to = this.totalExamples;
        }
        try {
            this.initializeCurrFromList(IrisUtils.loadIris(from, to));
            this.cursor += numExamples;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load iris.dat", e);
        }
    }
}

