/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.fetchers;

import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.common.resources.ResourceType;
import org.deeplearning4j.datasets.base.EmnistFetcher;
import org.deeplearning4j.datasets.fetchers.MnistDataFetcher;
import org.deeplearning4j.datasets.iterator.impl.EmnistDataSetIterator;
import org.deeplearning4j.datasets.mnist.MnistManager;
import org.nd4j.linalg.dataset.api.iterator.fetcher.DataSetFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmnistDataFetcher
extends MnistDataFetcher
implements DataSetFetcher {
    private static final Logger log = LoggerFactory.getLogger(EmnistDataFetcher.class);
    protected EmnistFetcher fetcher;

    public EmnistDataFetcher(EmnistDataSetIterator.Set dataSet, boolean binarize, boolean train, boolean shuffle, long rngSeed) throws IOException {
        MnistManager man;
        this.fetcher = new EmnistFetcher(dataSet);
        if (!this.emnistExists(this.fetcher)) {
            this.fetcher.downloadAndUntar();
        }
        String EMNIST_ROOT = DL4JResources.getDirectory((ResourceType)ResourceType.DATASET, (String)"EMNIST").getAbsolutePath();
        if (train) {
            this.images = FilenameUtils.concat((String)EMNIST_ROOT, (String)this.fetcher.getTrainingFilesFilename_unzipped());
            this.labels = FilenameUtils.concat((String)EMNIST_ROOT, (String)this.fetcher.getTrainingFileLabelsFilename_unzipped());
            this.totalExamples = EmnistDataSetIterator.numExamplesTrain(dataSet);
        } else {
            this.images = FilenameUtils.concat((String)EMNIST_ROOT, (String)this.fetcher.getTestFilesFilename_unzipped());
            this.labels = FilenameUtils.concat((String)EMNIST_ROOT, (String)this.fetcher.getTestFileLabelsFilename_unzipped());
            this.totalExamples = EmnistDataSetIterator.numExamplesTest(dataSet);
        }
        try {
            man = new MnistManager(this.images, this.labels, this.totalExamples);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            FileUtils.deleteDirectory((File)new File(EMNIST_ROOT));
            new EmnistFetcher(dataSet).downloadAndUntar();
            man = new MnistManager(this.images, this.labels, this.totalExamples);
        }
        this.numOutcomes = EmnistDataSetIterator.numLabels(dataSet);
        this.binarize = binarize;
        this.cursor = 0;
        man.setCurrent(this.cursor);
        this.inputColumns = man.getImages().getEntryLength();
        this.train = train;
        this.shuffle = shuffle;
        this.order = new int[this.totalExamples];
        for (int i = 0; i < this.order.length; ++i) {
            this.order[i] = i;
        }
        this.rng = new Random(rngSeed);
        this.reset();
        this.oneIndexed = dataSet == EmnistDataSetIterator.Set.LETTERS;
        this.fOrder = true;
        man.close();
    }

    private boolean emnistExists(EmnistFetcher e) {
        String EMNIST_ROOT = DL4JResources.getDirectory((ResourceType)ResourceType.DATASET, (String)"EMNIST").getAbsolutePath();
        File f = new File(EMNIST_ROOT, e.getTrainingFilesFilename_unzipped());
        if (!f.exists()) {
            return false;
        }
        f = new File(EMNIST_ROOT, e.getTrainingFileLabelsFilename_unzipped());
        if (!f.exists()) {
            return false;
        }
        f = new File(EMNIST_ROOT, e.getTestFilesFilename_unzipped());
        if (!f.exists()) {
            return false;
        }
        f = new File(EMNIST_ROOT, e.getTestFileLabelsFilename_unzipped());
        return f.exists();
    }
}

