/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.mnist;

import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class MnistDbFile
extends RandomAccessFile {
    private int count;

    public MnistDbFile(String name, String mode) throws IOException {
        super(name, mode);
        if (this.getMagicNumber() != this.readInt()) {
            throw new RuntimeException("This MNIST DB file " + name + " should start with the number " + this.getMagicNumber() + ".");
        }
        this.count = this.readInt();
    }

    protected abstract int getMagicNumber();

    public long getCurrentIndex() throws IOException {
        return (this.getFilePointer() - (long)this.getHeaderSize()) / (long)this.getEntryLength() + 1L;
    }

    public void setCurrentIndex(long curr) {
        try {
            if (curr < 0L || curr > (long)this.count) {
                throw new RuntimeException(curr + " is not in the range 0 to " + this.count);
            }
            this.seek((long)this.getHeaderSize() + curr * (long)this.getEntryLength());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getHeaderSize() {
        return 8;
    }

    public int getEntryLength() {
        return 1;
    }

    public void next() throws IOException {
        if (this.getCurrentIndex() < (long)this.count) {
            this.skipBytes(this.getEntryLength());
        }
    }

    public void prev() throws IOException {
        if (this.getCurrentIndex() > 0L) {
            this.seek(this.getFilePointer() - (long)this.getEntryLength());
        }
    }

    public int getCount() {
        return this.count;
    }
}

