/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.impl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.datavec.image.transform.ImageTransform;
import org.deeplearning4j.common.resources.DL4JResources;
import org.deeplearning4j.common.resources.ResourceType;
import org.deeplearning4j.datasets.datavec.RecordReaderDataSetIterator;
import org.deeplearning4j.datasets.fetchers.Cifar10Fetcher;
import org.deeplearning4j.datasets.fetchers.DataSetType;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;

public class Cifar10DataSetIterator
extends RecordReaderDataSetIterator {
    protected DataSetPreProcessor preProcessor;

    public Cifar10DataSetIterator(int batchSize) {
        this(batchSize, null, DataSetType.TRAIN, null, 123L);
    }

    public Cifar10DataSetIterator(int batchSize, DataSetType set) {
        this(batchSize, null, set, null, 123L);
    }

    public Cifar10DataSetIterator(int batchSize, int[] imgDim, DataSetType set) {
        this(batchSize, imgDim, set, null, 123L);
    }

    public Cifar10DataSetIterator(int batchSize, int[] imgDim, DataSetType set, ImageTransform imageTransform, long rngSeed) {
        super(new Cifar10Fetcher().getRecordReader(rngSeed, imgDim, set, imageTransform), batchSize, 1, Cifar10Fetcher.NUM_LABELS);
    }

    public static List<String> getLabels(boolean categories) {
        List lines;
        List rawLabels = new Cifar10DataSetIterator(1).getLabels();
        if (categories) {
            return rawLabels;
        }
        File baseDir = DL4JResources.getDirectory((ResourceType)ResourceType.DATASET, (String)"cifar10");
        File labelFile = new File(baseDir, "labels.txt");
        try {
            lines = FileUtils.readLines((File)labelFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading label file", e);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String line : lines) {
            String[] split = line.split("\t");
            map.put(split[0], split[1]);
        }
        ArrayList<String> outLabels = new ArrayList<String>(rawLabels.size());
        for (String s : rawLabels) {
            String s2 = (String)map.get(s);
            Preconditions.checkState((s2 != null ? 1 : 0) != 0, (String)"Label \"%s\" not found in labels.txt file");
            outLabels.add(s2);
        }
        return outLabels;
    }

    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }
}

