/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.task;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.deeplearning4j.arbiter.GraphConfiguration;
import org.deeplearning4j.arbiter.listener.DL4JArbiterStatusReportingListener;
import org.deeplearning4j.arbiter.optimize.api.Candidate;
import org.deeplearning4j.arbiter.optimize.api.OptimizationResult;
import org.deeplearning4j.arbiter.optimize.api.TaskCreator;
import org.deeplearning4j.arbiter.optimize.api.data.DataProvider;
import org.deeplearning4j.arbiter.optimize.api.data.DataSource;
import org.deeplearning4j.arbiter.optimize.api.evaluation.ModelEvaluator;
import org.deeplearning4j.arbiter.optimize.api.saving.ResultReference;
import org.deeplearning4j.arbiter.optimize.api.saving.ResultSaver;
import org.deeplearning4j.arbiter.optimize.api.score.ScoreFunction;
import org.deeplearning4j.arbiter.optimize.runner.CandidateInfo;
import org.deeplearning4j.arbiter.optimize.runner.CandidateStatus;
import org.deeplearning4j.arbiter.optimize.runner.IOptimizationRunner;
import org.deeplearning4j.arbiter.optimize.runner.listener.StatusListener;
import org.deeplearning4j.arbiter.scoring.util.ScoreUtil;
import org.deeplearning4j.arbiter.task.TaskListener;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.earlystopping.EarlyStoppingResult;
import org.deeplearning4j.earlystopping.trainer.EarlyStoppingGraphTrainer;
import org.deeplearning4j.nn.api.Model;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.optimize.api.TrainingListener;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputationGraphTaskCreator
implements TaskCreator {
    private static final Logger log = LoggerFactory.getLogger(ComputationGraphTaskCreator.class);
    private ModelEvaluator modelEvaluator;
    private TaskListener taskListener;

    public ComputationGraphTaskCreator(ModelEvaluator modelEvaluator) {
        this(modelEvaluator, null);
    }

    public Callable<OptimizationResult> create(Candidate candidate, DataProvider dataProvider, ScoreFunction scoreFunction, List<StatusListener> statusListener, IOptimizationRunner runner) {
        return new GraphLearningTask(candidate, dataProvider, scoreFunction, this.modelEvaluator, statusListener, this.taskListener, runner);
    }

    public Callable<OptimizationResult> create(Candidate candidate, Class<? extends DataSource> dataSource, Properties dataSourceProperties, ScoreFunction scoreFunction, List<StatusListener> statusListeners, IOptimizationRunner runner) {
        return new GraphLearningTask(candidate, dataSource, dataSourceProperties, scoreFunction, this.modelEvaluator, statusListeners, this.taskListener, runner);
    }

    public ComputationGraphTaskCreator(ModelEvaluator modelEvaluator, TaskListener taskListener) {
        this.modelEvaluator = modelEvaluator;
        this.taskListener = taskListener;
    }

    public ComputationGraphTaskCreator() {
    }

    public TaskListener getTaskListener() {
        return this.taskListener;
    }

    public void setTaskListener(TaskListener taskListener) {
        this.taskListener = taskListener;
    }

    private static class GraphLearningTask
    implements Callable<OptimizationResult> {
        private Candidate candidate;
        private DataProvider dataProvider;
        private Class<? extends DataSource> dataSource;
        private Properties dataSourceProperties;
        private ScoreFunction scoreFunction;
        private ModelEvaluator modelEvaluator;
        private List<StatusListener> listeners;
        private TaskListener taskListener;
        private IOptimizationRunner runner;
        private long startTime;

        public GraphLearningTask(Candidate candidate, DataProvider dataProvider, ScoreFunction scoreFunction, ModelEvaluator modelEvaluator, List<StatusListener> listeners, TaskListener taskListener, IOptimizationRunner runner) {
            this.candidate = candidate;
            this.dataProvider = dataProvider;
            this.scoreFunction = scoreFunction;
            this.modelEvaluator = modelEvaluator;
            this.listeners = listeners;
            this.taskListener = taskListener;
            this.runner = runner;
        }

        public GraphLearningTask(Candidate candidate, Class<? extends DataSource> dataSource, Properties dataSourceProperties, ScoreFunction scoreFunction, ModelEvaluator modelEvaluator, List<StatusListener> listeners, TaskListener taskListener, IOptimizationRunner runner) {
            this.candidate = candidate;
            this.dataSource = dataSource;
            this.dataSourceProperties = dataSourceProperties;
            this.scoreFunction = scoreFunction;
            this.modelEvaluator = modelEvaluator;
            this.listeners = listeners;
            this.taskListener = taskListener;
            this.runner = runner;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public OptimizationResult call() throws Exception {
            OptimizationResult ci;
            try {
                OptimizationResult result = this.callHelper();
                if (this.listeners != null && !this.listeners.isEmpty()) {
                    ci = new CandidateInfo(this.candidate.getIndex(), CandidateStatus.Complete, result.getScore(), this.startTime, Long.valueOf(this.startTime), Long.valueOf(System.currentTimeMillis()), this.candidate.getFlatParameters(), null);
                    for (StatusListener sl : this.listeners) {
                        try {
                            sl.onCandidateStatusChange((CandidateInfo)ci, this.runner, result);
                        }
                        catch (Exception e) {
                            log.error("Error in status listener for candidate {}", (Object)this.candidate.getIndex(), (Object)e);
                        }
                    }
                }
                ci = result;
            }
            catch (Throwable e) {
                try {
                    String stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
                    log.warn("Execution failed for task {}", (Object)this.candidate.getIndex(), (Object)e);
                    CandidateInfo ci2 = new CandidateInfo(this.candidate.getIndex(), CandidateStatus.Failed, null, this.startTime, null, null, this.candidate.getFlatParameters(), stackTrace);
                    OptimizationResult optimizationResult = new OptimizationResult(this.candidate, null, this.candidate.getIndex(), null, ci2, null);
                    return optimizationResult;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Nd4j.getWorkspaceManager().destroyAllWorkspacesForCurrentThread();
                    System.gc();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                }
            }
            Nd4j.getWorkspaceManager().destroyAllWorkspacesForCurrentThread();
            System.gc();
            try {
                Thread.sleep(2000L);
                return ci;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ci;
        }

        private OptimizationResult callHelper() throws Exception {
            MultiDataSetIterator iterator;
            this.startTime = System.currentTimeMillis();
            CandidateInfo ci = new CandidateInfo(this.candidate.getIndex(), CandidateStatus.Running, null, this.startTime, Long.valueOf(this.startTime), null, this.candidate.getFlatParameters(), null);
            ComputationGraph net = new ComputationGraph(((GraphConfiguration)this.candidate.getValue()).getConfiguration());
            net.init();
            if (this.taskListener != null) {
                net = this.taskListener.preProcess(net, this.candidate);
            }
            if (this.listeners != null) {
                net.addListeners(new TrainingListener[]{new DL4JArbiterStatusReportingListener(this.listeners, ci)});
            }
            if (this.dataSource != null) {
                try {
                    DataSource dsInstance = this.dataSource.newInstance();
                    if (this.dataSourceProperties != null) {
                        dsInstance.configure(this.dataSourceProperties);
                    }
                    iterator = ScoreUtil.getMultiIterator(dsInstance.trainData());
                }
                catch (Exception e) {
                    throw new RuntimeException("Error instantiating instance of DataSource for class " + this.dataSource.getName() + " - no zero-arg constructor?", e);
                }
            } else {
                iterator = ScoreUtil.getMultiIterator(this.dataProvider.trainData(this.candidate.getDataParameters()));
            }
            EarlyStoppingConfiguration<ComputationGraph> esConfig = ((GraphConfiguration)this.candidate.getValue()).getEarlyStoppingConfiguration();
            EarlyStoppingResult esResult = null;
            if (esConfig != null) {
                EarlyStoppingGraphTrainer trainer = new EarlyStoppingGraphTrainer(esConfig, net, iterator, null);
                esResult = trainer.fit();
                net = (ComputationGraph)esResult.getBestModel();
                switch (esResult.getTerminationReason()) {
                    case Error: {
                        ci.setCandidateStatus(CandidateStatus.Failed);
                        ci.setExceptionStackTrace(esResult.getTerminationDetails());
                        break;
                    }
                    case IterationTerminationCondition: 
                    case EpochTerminationCondition: {
                        ci.setCandidateStatus(CandidateStatus.Complete);
                    }
                }
            } else {
                int nEpochs = ((GraphConfiguration)this.candidate.getValue()).getNumEpochs();
                for (int i = 0; i < nEpochs; ++i) {
                    net.fit(iterator);
                }
                ci.setCandidateStatus(CandidateStatus.Complete);
            }
            Nd4j.getExecutioner().commit();
            Object additionalEvaluation = null;
            if (esConfig != null && esResult.getTerminationReason() != EarlyStoppingResult.TerminationReason.Error) {
                additionalEvaluation = this.modelEvaluator != null ? this.modelEvaluator.evaluateModel((Object)net, this.dataProvider) : null;
            }
            Double score = null;
            if (net != null) {
                score = this.dataSource != null ? Double.valueOf(this.scoreFunction.score((Object)net, this.dataSource, this.dataSourceProperties)) : Double.valueOf(this.scoreFunction.score((Object)net, this.dataProvider, this.candidate.getDataParameters()));
                ci.setScore(score);
            }
            if (this.taskListener != null) {
                this.taskListener.postProcess((Model)net, this.candidate);
            }
            OptimizationResult result = new OptimizationResult(this.candidate, score, this.candidate.getIndex(), additionalEvaluation, ci, null);
            ResultSaver saver = this.runner.getConfiguration().getResultSaver();
            ResultReference resultReference = null;
            if (saver != null) {
                try {
                    resultReference = saver.saveModel(result, (Object)net);
                }
                catch (IOException e) {
                    log.warn("Error saving model (id={}): IOException thrown. ", (Object)result.getIndex(), (Object)e);
                }
            }
            result.setResultReference(resultReference);
            return result;
        }

        public GraphLearningTask(Candidate candidate, DataProvider dataProvider, Class<? extends DataSource> dataSource, Properties dataSourceProperties, ScoreFunction scoreFunction, ModelEvaluator modelEvaluator, List<StatusListener> listeners, TaskListener taskListener, IOptimizationRunner runner, long startTime) {
            this.candidate = candidate;
            this.dataProvider = dataProvider;
            this.dataSource = dataSource;
            this.dataSourceProperties = dataSourceProperties;
            this.scoreFunction = scoreFunction;
            this.modelEvaluator = modelEvaluator;
            this.listeners = listeners;
            this.taskListener = taskListener;
            this.runner = runner;
            this.startTime = startTime;
        }
    }
}

