/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.arbiter.layers.BaseConvolutionLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.SeparableConvolution2D;

public class SeparableConvolution2DLayerSpace
extends BaseConvolutionLayerSpace<SeparableConvolution2D> {
    private ParameterSpace<Integer> depthMultiplier;
    protected ParameterSpace<List<LayerConstraint>> pointWiseConstraints;

    protected SeparableConvolution2DLayerSpace(Builder builder) {
        super(builder);
        this.depthMultiplier = builder.depthMultiplier;
        this.pointWiseConstraints = builder.pointWiseConstraints;
    }

    public SeparableConvolution2D getValue(double[] parameterValues) {
        SeparableConvolution2D.Builder b = new SeparableConvolution2D.Builder();
        this.setLayerOptionsBuilder(b, parameterValues);
        return b.build();
    }

    protected void setLayerOptionsBuilder(SeparableConvolution2D.Builder builder, double[] values) {
        List c;
        super.setLayerOptionsBuilder((ConvolutionLayer.BaseConvBuilder<?>)builder, values);
        if (this.kernelSize != null) {
            builder.kernelSize((int[])this.kernelSize.getValue(values));
        }
        if (this.stride != null) {
            builder.stride((int[])this.stride.getValue(values));
        }
        if (this.padding != null) {
            builder.padding((int[])this.padding.getValue(values));
        }
        if (this.convolutionMode != null) {
            builder.convolutionMode((ConvolutionMode)this.convolutionMode.getValue(values));
        }
        if (this.hasBias != null) {
            builder.hasBias(((Boolean)this.hasBias.getValue(values)).booleanValue());
        }
        if (this.depthMultiplier != null) {
            builder.depthMultiplier(((Integer)this.depthMultiplier.getValue(values)).intValue());
        }
        if (this.pointWiseConstraints != null && (c = (List)this.pointWiseConstraints.getValue(values)) != null) {
            builder.constrainPointWise(c.toArray(new LayerConstraint[c.size()]));
        }
    }

    public ParameterSpace<Integer> getDepthMultiplier() {
        return this.depthMultiplier;
    }

    public ParameterSpace<List<LayerConstraint>> getPointWiseConstraints() {
        return this.pointWiseConstraints;
    }

    public void setDepthMultiplier(ParameterSpace<Integer> depthMultiplier) {
        this.depthMultiplier = depthMultiplier;
    }

    public void setPointWiseConstraints(ParameterSpace<List<LayerConstraint>> pointWiseConstraints) {
        this.pointWiseConstraints = pointWiseConstraints;
    }

    @Override
    public String toString() {
        return "SeparableConvolution2DLayerSpace(depthMultiplier=" + this.getDepthMultiplier() + ", pointWiseConstraints=" + this.getPointWiseConstraints() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SeparableConvolution2DLayerSpace)) {
            return false;
        }
        SeparableConvolution2DLayerSpace other = (SeparableConvolution2DLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<Integer> this$depthMultiplier = this.getDepthMultiplier();
        ParameterSpace<Integer> other$depthMultiplier = other.getDepthMultiplier();
        if (this$depthMultiplier == null ? other$depthMultiplier != null : !this$depthMultiplier.equals(other$depthMultiplier)) {
            return false;
        }
        ParameterSpace<List<LayerConstraint>> this$pointWiseConstraints = this.getPointWiseConstraints();
        ParameterSpace<List<LayerConstraint>> other$pointWiseConstraints = other.getPointWiseConstraints();
        return !(this$pointWiseConstraints == null ? other$pointWiseConstraints != null : !this$pointWiseConstraints.equals(other$pointWiseConstraints));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SeparableConvolution2DLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParameterSpace<Integer> $depthMultiplier = this.getDepthMultiplier();
        result = result * 59 + ($depthMultiplier == null ? 43 : $depthMultiplier.hashCode());
        ParameterSpace<List<LayerConstraint>> $pointWiseConstraints = this.getPointWiseConstraints();
        result = result * 59 + ($pointWiseConstraints == null ? 43 : $pointWiseConstraints.hashCode());
        return result;
    }

    protected SeparableConvolution2DLayerSpace() {
    }

    public static class Builder
    extends BaseConvolutionLayerSpace.Builder<Builder> {
        private ParameterSpace<Integer> depthMultiplier;
        protected ParameterSpace<List<LayerConstraint>> pointWiseConstraints;

        public Builder constrainPointWise(LayerConstraint ... constraints) {
            return this.constrainPointWise((ParameterSpace<List<LayerConstraint>>)new FixedValue(Arrays.asList(constraints)));
        }

        public Builder constrainPointWise(ParameterSpace<List<LayerConstraint>> constraints) {
            this.pointWiseConstraints = constraints;
            return this;
        }

        public Builder depthMultiplier(int depthMultiplier) {
            return this.depthMultiplier((ParameterSpace<Integer>)new FixedValue((Object)depthMultiplier));
        }

        public Builder depthMultiplier(ParameterSpace<Integer> depthMultiplier) {
            this.depthMultiplier = depthMultiplier;
            return this;
        }

        @Override
        public SeparableConvolution2DLayerSpace build() {
            return new SeparableConvolution2DLayerSpace(this);
        }
    }
}

