/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import org.deeplearning4j.arbiter.adapter.ActivationParameterSpaceAdapter;
import org.deeplearning4j.arbiter.adapter.LossFunctionParameterSpaceAdapter;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.nn.conf.layers.LossLayer;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class LossLayerSpace
extends LayerSpace<LossLayer> {
    private ParameterSpace<IActivation> activationFunction;
    protected ParameterSpace<ILossFunction> lossFunction;

    public LossLayerSpace(Builder builder) {
        super(builder);
        this.activationFunction = builder.activationFunction;
        this.lossFunction = builder.lossFunction;
        this.numParameters = LeafUtils.countUniqueParameters(this.collectLeaves());
    }

    public LossLayer getValue(double[] parameterValues) {
        LossLayer.Builder b = new LossLayer.Builder();
        if (this.activationFunction != null) {
            b.activation((IActivation)this.activationFunction.getValue(parameterValues));
        }
        if (this.lossFunction != null) {
            b.lossFunction((ILossFunction)this.lossFunction.getValue(parameterValues));
        }
        return b.build();
    }

    public ParameterSpace<IActivation> getActivationFunction() {
        return this.activationFunction;
    }

    public ParameterSpace<ILossFunction> getLossFunction() {
        return this.lossFunction;
    }

    public void setActivationFunction(ParameterSpace<IActivation> activationFunction) {
        this.activationFunction = activationFunction;
    }

    public void setLossFunction(ParameterSpace<ILossFunction> lossFunction) {
        this.lossFunction = lossFunction;
    }

    @Override
    public String toString() {
        return "LossLayerSpace(activationFunction=" + this.getActivationFunction() + ", lossFunction=" + this.getLossFunction() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LossLayerSpace)) {
            return false;
        }
        LossLayerSpace other = (LossLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<IActivation> this$activationFunction = this.getActivationFunction();
        ParameterSpace<IActivation> other$activationFunction = other.getActivationFunction();
        if (this$activationFunction == null ? other$activationFunction != null : !this$activationFunction.equals(other$activationFunction)) {
            return false;
        }
        ParameterSpace<ILossFunction> this$lossFunction = this.getLossFunction();
        ParameterSpace<ILossFunction> other$lossFunction = other.getLossFunction();
        return !(this$lossFunction == null ? other$lossFunction != null : !this$lossFunction.equals(other$lossFunction));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LossLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParameterSpace<IActivation> $activationFunction = this.getActivationFunction();
        result = result * 59 + ($activationFunction == null ? 43 : $activationFunction.hashCode());
        ParameterSpace<ILossFunction> $lossFunction = this.getLossFunction();
        result = result * 59 + ($lossFunction == null ? 43 : $lossFunction.hashCode());
        return result;
    }

    protected LossLayerSpace() {
    }

    public static class Builder
    extends LayerSpace.Builder<Builder> {
        private ParameterSpace<IActivation> activationFunction;
        protected ParameterSpace<ILossFunction> lossFunction;

        public Builder lossFunction(LossFunctions.LossFunction lossFunction) {
            return this.lossFunction((ParameterSpace<LossFunctions.LossFunction>)new FixedValue((Object)lossFunction));
        }

        public Builder lossFunction(ParameterSpace<LossFunctions.LossFunction> lossFunction) {
            return this.iLossFunction((ParameterSpace<ILossFunction>)new LossFunctionParameterSpaceAdapter(lossFunction));
        }

        public Builder iLossFunction(ILossFunction lossFunction) {
            return this.iLossFunction((ParameterSpace<ILossFunction>)new FixedValue((Object)lossFunction));
        }

        public Builder iLossFunction(ParameterSpace<ILossFunction> lossFunction) {
            this.lossFunction = lossFunction;
            return this;
        }

        public Builder activation(Activation activation) {
            return this.activation((ParameterSpace<Activation>)new FixedValue((Object)activation));
        }

        public Builder activation(IActivation iActivation) {
            return this.activationFn((ParameterSpace<IActivation>)new FixedValue((Object)iActivation));
        }

        public Builder activation(ParameterSpace<Activation> activationFunction) {
            return this.activationFn((ParameterSpace<IActivation>)new ActivationParameterSpaceAdapter(activationFunction));
        }

        public Builder activationFn(ParameterSpace<IActivation> activationFunction) {
            this.activationFunction = activationFunction;
            return this;
        }

        @Override
        public LossLayerSpace build() {
            return new LossLayerSpace(this);
        }
    }
}

