/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.Arrays;
import java.util.List;
import org.deeplearning4j.arbiter.layers.BaseLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;

public abstract class FeedForwardLayerSpace<L extends FeedForwardLayer>
extends BaseLayerSpace<L> {
    protected ParameterSpace<Integer> nIn;
    protected ParameterSpace<Integer> nOut;
    protected ParameterSpace<List<LayerConstraint>> constrainWeights;
    protected ParameterSpace<List<LayerConstraint>> constrainBias;
    protected ParameterSpace<List<LayerConstraint>> constrainAll;

    protected FeedForwardLayerSpace(Builder builder) {
        super(builder);
        this.nIn = builder.nIn;
        this.nOut = builder.nOut;
        this.constrainWeights = builder.constrainWeights;
        this.constrainBias = builder.constrainBias;
        this.constrainAll = builder.constrainAll;
    }

    protected void setLayerOptionsBuilder(FeedForwardLayer.Builder builder, double[] values) {
        List c;
        super.setLayerOptionsBuilder((BaseLayer.Builder)builder, values);
        if (this.nIn != null) {
            builder.nIn(((Integer)this.nIn.getValue(values)).intValue());
        }
        if (this.nOut != null) {
            builder.nOut(((Integer)this.nOut.getValue(values)).intValue());
        }
        if (this.constrainWeights != null && (c = (List)this.constrainWeights.getValue(values)) != null) {
            builder.constrainWeights(c.toArray(new LayerConstraint[c.size()]));
        }
        if (this.constrainBias != null && (c = (List)this.constrainBias.getValue(values)) != null) {
            builder.constrainBias(c.toArray(new LayerConstraint[c.size()]));
        }
        if (this.constrainAll != null && (c = (List)this.constrainAll.getValue(values)) != null) {
            builder.constrainAllParameters(c.toArray(new LayerConstraint[c.size()]));
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    protected String toString(String delim) {
        StringBuilder sb = new StringBuilder();
        if (this.nIn != null) {
            sb.append("nIn: ").append(this.nIn).append(delim);
        }
        if (this.nOut != null) {
            sb.append("nOut: ").append(this.nOut).append(delim);
        }
        if (this.constrainWeights != null) {
            sb.append("constrainWeights: ").append(this.constrainWeights).append(delim);
        }
        if (this.constrainBias != null) {
            sb.append("constrainBias: ").append(this.constrainBias).append(delim);
        }
        if (this.constrainAll != null) {
            sb.append("constrainAllParams: ").append(this.constrainAll).append(delim);
        }
        sb.append(super.toString(delim));
        return sb.toString();
    }

    public ParameterSpace<Integer> getNIn() {
        return this.nIn;
    }

    public ParameterSpace<Integer> getNOut() {
        return this.nOut;
    }

    public ParameterSpace<List<LayerConstraint>> getConstrainWeights() {
        return this.constrainWeights;
    }

    public ParameterSpace<List<LayerConstraint>> getConstrainBias() {
        return this.constrainBias;
    }

    public ParameterSpace<List<LayerConstraint>> getConstrainAll() {
        return this.constrainAll;
    }

    public void setNIn(ParameterSpace<Integer> nIn) {
        this.nIn = nIn;
    }

    public void setNOut(ParameterSpace<Integer> nOut) {
        this.nOut = nOut;
    }

    public void setConstrainWeights(ParameterSpace<List<LayerConstraint>> constrainWeights) {
        this.constrainWeights = constrainWeights;
    }

    public void setConstrainBias(ParameterSpace<List<LayerConstraint>> constrainBias) {
        this.constrainBias = constrainBias;
    }

    public void setConstrainAll(ParameterSpace<List<LayerConstraint>> constrainAll) {
        this.constrainAll = constrainAll;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeedForwardLayerSpace)) {
            return false;
        }
        FeedForwardLayerSpace other = (FeedForwardLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<Integer> this$nIn = this.getNIn();
        ParameterSpace<Integer> other$nIn = other.getNIn();
        if (this$nIn == null ? other$nIn != null : !this$nIn.equals(other$nIn)) {
            return false;
        }
        ParameterSpace<Integer> this$nOut = this.getNOut();
        ParameterSpace<Integer> other$nOut = other.getNOut();
        if (this$nOut == null ? other$nOut != null : !this$nOut.equals(other$nOut)) {
            return false;
        }
        ParameterSpace<List<LayerConstraint>> this$constrainWeights = this.getConstrainWeights();
        ParameterSpace<List<LayerConstraint>> other$constrainWeights = other.getConstrainWeights();
        if (this$constrainWeights == null ? other$constrainWeights != null : !this$constrainWeights.equals(other$constrainWeights)) {
            return false;
        }
        ParameterSpace<List<LayerConstraint>> this$constrainBias = this.getConstrainBias();
        ParameterSpace<List<LayerConstraint>> other$constrainBias = other.getConstrainBias();
        if (this$constrainBias == null ? other$constrainBias != null : !this$constrainBias.equals(other$constrainBias)) {
            return false;
        }
        ParameterSpace<List<LayerConstraint>> this$constrainAll = this.getConstrainAll();
        ParameterSpace<List<LayerConstraint>> other$constrainAll = other.getConstrainAll();
        return !(this$constrainAll == null ? other$constrainAll != null : !this$constrainAll.equals(other$constrainAll));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FeedForwardLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParameterSpace<Integer> $nIn = this.getNIn();
        result = result * 59 + ($nIn == null ? 43 : $nIn.hashCode());
        ParameterSpace<Integer> $nOut = this.getNOut();
        result = result * 59 + ($nOut == null ? 43 : $nOut.hashCode());
        ParameterSpace<List<LayerConstraint>> $constrainWeights = this.getConstrainWeights();
        result = result * 59 + ($constrainWeights == null ? 43 : $constrainWeights.hashCode());
        ParameterSpace<List<LayerConstraint>> $constrainBias = this.getConstrainBias();
        result = result * 59 + ($constrainBias == null ? 43 : $constrainBias.hashCode());
        ParameterSpace<List<LayerConstraint>> $constrainAll = this.getConstrainAll();
        result = result * 59 + ($constrainAll == null ? 43 : $constrainAll.hashCode());
        return result;
    }

    public FeedForwardLayerSpace() {
    }

    public static abstract class Builder<T>
    extends BaseLayerSpace.Builder<T> {
        protected ParameterSpace<Integer> nIn;
        protected ParameterSpace<Integer> nOut;
        protected ParameterSpace<List<LayerConstraint>> constrainWeights;
        protected ParameterSpace<List<LayerConstraint>> constrainBias;
        protected ParameterSpace<List<LayerConstraint>> constrainAll;

        public T nIn(int nIn) {
            return this.nIn((ParameterSpace<Integer>)new FixedValue((Object)nIn));
        }

        public T nIn(ParameterSpace<Integer> nIn) {
            this.nIn = nIn;
            return (T)this;
        }

        public T nOut(int nOut) {
            return this.nOut((ParameterSpace<Integer>)new FixedValue((Object)nOut));
        }

        public T nOut(ParameterSpace<Integer> nOut) {
            this.nOut = nOut;
            return (T)this;
        }

        public T constrainWeights(LayerConstraint ... constraints) {
            return this.constrainWeights((ParameterSpace<List<LayerConstraint>>)new FixedValue(Arrays.asList(constraints)));
        }

        public T constrainWeights(ParameterSpace<List<LayerConstraint>> constraints) {
            this.constrainWeights = constraints;
            return (T)this;
        }

        public T constrainBias(LayerConstraint ... constraints) {
            return this.constrainBias((ParameterSpace<List<LayerConstraint>>)new FixedValue(Arrays.asList(constraints)));
        }

        public T constrainBias(ParameterSpace<List<LayerConstraint>> constraints) {
            this.constrainBias = constraints;
            return (T)this;
        }

        public T constrainAllParams(LayerConstraint ... constraints) {
            return this.constrainAllParams((ParameterSpace<List<LayerConstraint>>)new FixedValue(Arrays.asList(constraints)));
        }

        public T constrainAllParams(ParameterSpace<List<LayerConstraint>> constraints) {
            this.constrainAll = constraints;
            return (T)this;
        }
    }
}

