/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.List;
import lombok.NonNull;
import org.deeplearning4j.arbiter.dropout.DropoutSpace;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.deeplearning4j.nn.conf.layers.DropoutLayer;

public class DropoutLayerSpace
extends LayerSpace<DropoutLayer> {
    public DropoutLayerSpace(@NonNull ParameterSpace<IDropout> dropout) {
        if (dropout == null) {
            throw new NullPointerException("dropout is marked non-null but is null");
        }
        this.dropOut = dropout;
    }

    protected DropoutLayerSpace(Builder builder) {
        super(builder);
    }

    public DropoutLayer getValue(double[] parameterValues) {
        return ((DropoutLayer.Builder)new DropoutLayer.Builder().dropOut((IDropout)this.dropOut.getValue(parameterValues))).build();
    }

    @Override
    public int numParameters() {
        return this.dropOut.numParameters();
    }

    @Override
    public List<ParameterSpace> collectLeaves() {
        return this.dropOut.collectLeaves();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setIndices(int ... indices) {
        this.dropOut.setIndices(indices);
    }

    @Override
    public String toString() {
        return "DropoutLayerSpace()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DropoutLayerSpace)) {
            return false;
        }
        DropoutLayerSpace other = (DropoutLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DropoutLayerSpace;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    protected DropoutLayerSpace() {
    }

    public static class Builder
    extends LayerSpace.Builder<Builder> {
        @Override
        public Builder dropOut(double d) {
            return this.iDropOut(new DropoutSpace((ParameterSpace<Double>)new FixedValue((Object)d)));
        }

        @Override
        public Builder dropOut(ParameterSpace<Double> dropOut) {
            return this.iDropOut(new DropoutSpace(dropOut));
        }

        @Override
        public Builder iDropOut(ParameterSpace<IDropout> dropout) {
            this.dropOut = dropout;
            return this;
        }

        @Override
        public DropoutLayerSpace build() {
            return new DropoutLayerSpace(this);
        }
    }
}

