/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.nn.conf.layers.DenseLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;

public class DenseLayerSpace
extends FeedForwardLayerSpace<DenseLayer> {
    protected ParameterSpace<Boolean> hasBias;

    private DenseLayerSpace(Builder builder) {
        super(builder);
        this.hasBias = builder.hasBias;
        this.numParameters = LeafUtils.countUniqueParameters(this.collectLeaves());
    }

    public DenseLayer getValue(double[] values) {
        DenseLayer.Builder b = new DenseLayer.Builder();
        this.setLayerOptionsBuilder(b, values);
        return b.build();
    }

    protected void setLayerOptionsBuilder(DenseLayer.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.hasBias != null) {
            builder.hasBias(((Boolean)this.hasBias.getValue(values)).booleanValue());
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        return "DenseLayerSpace(" + super.toString(delim) + ")";
    }

    public ParameterSpace<Boolean> getHasBias() {
        return this.hasBias;
    }

    public void setHasBias(ParameterSpace<Boolean> hasBias) {
        this.hasBias = hasBias;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DenseLayerSpace)) {
            return false;
        }
        DenseLayerSpace other = (DenseLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<Boolean> this$hasBias = this.getHasBias();
        ParameterSpace<Boolean> other$hasBias = other.getHasBias();
        return !(this$hasBias == null ? other$hasBias != null : !this$hasBias.equals(other$hasBias));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DenseLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParameterSpace<Boolean> $hasBias = this.getHasBias();
        result = result * 59 + ($hasBias == null ? 43 : $hasBias.hashCode());
        return result;
    }

    public DenseLayerSpace() {
    }

    public static class Builder
    extends FeedForwardLayerSpace.Builder<Builder> {
        protected ParameterSpace<Boolean> hasBias;

        public Builder hasBias(boolean hasBias) {
            return this.hasBias((ParameterSpace<Boolean>)new FixedValue((Object)hasBias));
        }

        public Builder hasBias(ParameterSpace<Boolean> hasBias) {
            this.hasBias = hasBias;
            return this;
        }

        @Override
        public DenseLayerSpace build() {
            return new DenseLayerSpace(this);
        }
    }
}

