/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import java.util.Map;
import org.deeplearning4j.arbiter.adapter.ActivationParameterSpaceAdapter;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.optimize.parameter.discrete.DiscreteParameterSpace;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.layers.BaseLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.weightnoise.IWeightNoise;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.shade.guava.base.Preconditions;
import org.nd4j.shade.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class BaseLayerSpace<L extends BaseLayer>
extends LayerSpace<L> {
    protected ParameterSpace<IActivation> activationFunction;
    protected ParameterSpace<WeightInit> weightInit;
    protected ParameterSpace<Double> biasInit;
    protected ParameterSpace<Distribution> dist;
    protected ParameterSpace<Double> l1;
    protected ParameterSpace<Double> l2;
    protected ParameterSpace<Double> l1Bias;
    protected ParameterSpace<Double> l2Bias;
    protected ParameterSpace<IUpdater> updater;
    protected ParameterSpace<IUpdater> biasUpdater;
    protected ParameterSpace<IWeightNoise> weightNoise;
    protected ParameterSpace<GradientNormalization> gradientNormalization;
    protected ParameterSpace<Double> gradientNormalizationThreshold;
    protected int numParameters;

    protected BaseLayerSpace(Builder builder) {
        super(builder);
        this.activationFunction = builder.activationFunction;
        this.weightInit = builder.weightInit;
        this.biasInit = builder.biasInit;
        this.dist = builder.dist;
        this.l1 = builder.l1;
        this.l2 = builder.l2;
        this.l1Bias = builder.l1Bias;
        this.l2Bias = builder.l2Bias;
        this.updater = builder.updater;
        this.biasUpdater = builder.biasUpdater;
        this.weightNoise = builder.weightNoise;
        this.gradientNormalization = builder.gradientNormalization;
        this.gradientNormalizationThreshold = builder.gradientNormalizationThreshold;
    }

    @Override
    public int numParameters() {
        return this.numParameters;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public void setIndices(int ... indices) {
        throw new UnsupportedOperationException("Cannot set indices for non-leaf parameter space");
    }

    protected void setLayerOptionsBuilder(BaseLayer.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((Layer.Builder)builder, values);
        if (this.activationFunction != null) {
            builder.activation((IActivation)this.activationFunction.getValue(values));
        }
        if (this.biasInit != null) {
            builder.biasInit(((Double)this.biasInit.getValue(values)).doubleValue());
        }
        if (this.weightInit != null) {
            builder.weightInit((WeightInit)this.weightInit.getValue(values));
        }
        if (this.dist != null) {
            builder.dist((Distribution)this.dist.getValue(values));
        }
        if (this.l1 != null) {
            builder.l1(((Double)this.l1.getValue(values)).doubleValue());
        }
        if (this.l2 != null) {
            builder.l2(((Double)this.l2.getValue(values)).doubleValue());
        }
        if (this.l1Bias != null) {
            builder.l1Bias(((Double)this.l1Bias.getValue(values)).doubleValue());
        }
        if (this.l2Bias != null) {
            builder.l2Bias(((Double)this.l2Bias.getValue(values)).doubleValue());
        }
        if (this.updater != null) {
            builder.updater((IUpdater)this.updater.getValue(values));
        }
        if (this.biasUpdater != null) {
            builder.biasUpdater((IUpdater)this.biasUpdater.getValue(values));
        }
        if (this.weightNoise != null) {
            builder.weightNoise((IWeightNoise)this.weightNoise.getValue(values));
        }
        if (this.gradientNormalization != null) {
            builder.gradientNormalization((GradientNormalization)this.gradientNormalization.getValue(values));
        }
        if (this.gradientNormalizationThreshold != null) {
            builder.gradientNormalizationThreshold(((Double)this.gradientNormalizationThreshold.getValue(values)).doubleValue());
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    protected String toString(String delim) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : this.getNestedSpaces().entrySet()) {
            sb.append((String)e.getKey()).append(": ").append(e.getValue()).append("\n");
        }
        return sb.toString();
    }

    public ParameterSpace<IActivation> getActivationFunction() {
        return this.activationFunction;
    }

    public ParameterSpace<WeightInit> getWeightInit() {
        return this.weightInit;
    }

    public ParameterSpace<Double> getBiasInit() {
        return this.biasInit;
    }

    public ParameterSpace<Distribution> getDist() {
        return this.dist;
    }

    public ParameterSpace<Double> getL1() {
        return this.l1;
    }

    public ParameterSpace<Double> getL2() {
        return this.l2;
    }

    public ParameterSpace<Double> getL1Bias() {
        return this.l1Bias;
    }

    public ParameterSpace<Double> getL2Bias() {
        return this.l2Bias;
    }

    public ParameterSpace<IUpdater> getUpdater() {
        return this.updater;
    }

    public ParameterSpace<IUpdater> getBiasUpdater() {
        return this.biasUpdater;
    }

    public ParameterSpace<IWeightNoise> getWeightNoise() {
        return this.weightNoise;
    }

    public ParameterSpace<GradientNormalization> getGradientNormalization() {
        return this.gradientNormalization;
    }

    public ParameterSpace<Double> getGradientNormalizationThreshold() {
        return this.gradientNormalizationThreshold;
    }

    @Override
    public int getNumParameters() {
        return this.numParameters;
    }

    public void setActivationFunction(ParameterSpace<IActivation> activationFunction) {
        this.activationFunction = activationFunction;
    }

    public void setWeightInit(ParameterSpace<WeightInit> weightInit) {
        this.weightInit = weightInit;
    }

    public void setBiasInit(ParameterSpace<Double> biasInit) {
        this.biasInit = biasInit;
    }

    public void setDist(ParameterSpace<Distribution> dist) {
        this.dist = dist;
    }

    public void setL1(ParameterSpace<Double> l1) {
        this.l1 = l1;
    }

    public void setL2(ParameterSpace<Double> l2) {
        this.l2 = l2;
    }

    public void setL1Bias(ParameterSpace<Double> l1Bias) {
        this.l1Bias = l1Bias;
    }

    public void setL2Bias(ParameterSpace<Double> l2Bias) {
        this.l2Bias = l2Bias;
    }

    public void setUpdater(ParameterSpace<IUpdater> updater) {
        this.updater = updater;
    }

    public void setBiasUpdater(ParameterSpace<IUpdater> biasUpdater) {
        this.biasUpdater = biasUpdater;
    }

    public void setWeightNoise(ParameterSpace<IWeightNoise> weightNoise) {
        this.weightNoise = weightNoise;
    }

    public void setGradientNormalization(ParameterSpace<GradientNormalization> gradientNormalization) {
        this.gradientNormalization = gradientNormalization;
    }

    public void setGradientNormalizationThreshold(ParameterSpace<Double> gradientNormalizationThreshold) {
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
    }

    @Override
    public void setNumParameters(int numParameters) {
        this.numParameters = numParameters;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseLayerSpace)) {
            return false;
        }
        BaseLayerSpace other = (BaseLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<IActivation> this$activationFunction = this.getActivationFunction();
        ParameterSpace<IActivation> other$activationFunction = other.getActivationFunction();
        if (this$activationFunction == null ? other$activationFunction != null : !this$activationFunction.equals(other$activationFunction)) {
            return false;
        }
        ParameterSpace<WeightInit> this$weightInit = this.getWeightInit();
        ParameterSpace<WeightInit> other$weightInit = other.getWeightInit();
        if (this$weightInit == null ? other$weightInit != null : !this$weightInit.equals(other$weightInit)) {
            return false;
        }
        ParameterSpace<Double> this$biasInit = this.getBiasInit();
        ParameterSpace<Double> other$biasInit = other.getBiasInit();
        if (this$biasInit == null ? other$biasInit != null : !this$biasInit.equals(other$biasInit)) {
            return false;
        }
        ParameterSpace<Distribution> this$dist = this.getDist();
        ParameterSpace<Distribution> other$dist = other.getDist();
        if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
            return false;
        }
        ParameterSpace<Double> this$l1 = this.getL1();
        ParameterSpace<Double> other$l1 = other.getL1();
        if (this$l1 == null ? other$l1 != null : !this$l1.equals(other$l1)) {
            return false;
        }
        ParameterSpace<Double> this$l2 = this.getL2();
        ParameterSpace<Double> other$l2 = other.getL2();
        if (this$l2 == null ? other$l2 != null : !this$l2.equals(other$l2)) {
            return false;
        }
        ParameterSpace<Double> this$l1Bias = this.getL1Bias();
        ParameterSpace<Double> other$l1Bias = other.getL1Bias();
        if (this$l1Bias == null ? other$l1Bias != null : !this$l1Bias.equals(other$l1Bias)) {
            return false;
        }
        ParameterSpace<Double> this$l2Bias = this.getL2Bias();
        ParameterSpace<Double> other$l2Bias = other.getL2Bias();
        if (this$l2Bias == null ? other$l2Bias != null : !this$l2Bias.equals(other$l2Bias)) {
            return false;
        }
        ParameterSpace<IUpdater> this$updater = this.getUpdater();
        ParameterSpace<IUpdater> other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !this$updater.equals(other$updater)) {
            return false;
        }
        ParameterSpace<IUpdater> this$biasUpdater = this.getBiasUpdater();
        ParameterSpace<IUpdater> other$biasUpdater = other.getBiasUpdater();
        if (this$biasUpdater == null ? other$biasUpdater != null : !this$biasUpdater.equals(other$biasUpdater)) {
            return false;
        }
        ParameterSpace<IWeightNoise> this$weightNoise = this.getWeightNoise();
        ParameterSpace<IWeightNoise> other$weightNoise = other.getWeightNoise();
        if (this$weightNoise == null ? other$weightNoise != null : !this$weightNoise.equals(other$weightNoise)) {
            return false;
        }
        ParameterSpace<GradientNormalization> this$gradientNormalization = this.getGradientNormalization();
        ParameterSpace<GradientNormalization> other$gradientNormalization = other.getGradientNormalization();
        if (this$gradientNormalization == null ? other$gradientNormalization != null : !this$gradientNormalization.equals(other$gradientNormalization)) {
            return false;
        }
        ParameterSpace<Double> this$gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        ParameterSpace<Double> other$gradientNormalizationThreshold = other.getGradientNormalizationThreshold();
        if (this$gradientNormalizationThreshold == null ? other$gradientNormalizationThreshold != null : !this$gradientNormalizationThreshold.equals(other$gradientNormalizationThreshold)) {
            return false;
        }
        return this.getNumParameters() == other.getNumParameters();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParameterSpace<IActivation> $activationFunction = this.getActivationFunction();
        result = result * 59 + ($activationFunction == null ? 43 : $activationFunction.hashCode());
        ParameterSpace<WeightInit> $weightInit = this.getWeightInit();
        result = result * 59 + ($weightInit == null ? 43 : $weightInit.hashCode());
        ParameterSpace<Double> $biasInit = this.getBiasInit();
        result = result * 59 + ($biasInit == null ? 43 : $biasInit.hashCode());
        ParameterSpace<Distribution> $dist = this.getDist();
        result = result * 59 + ($dist == null ? 43 : $dist.hashCode());
        ParameterSpace<Double> $l1 = this.getL1();
        result = result * 59 + ($l1 == null ? 43 : $l1.hashCode());
        ParameterSpace<Double> $l2 = this.getL2();
        result = result * 59 + ($l2 == null ? 43 : $l2.hashCode());
        ParameterSpace<Double> $l1Bias = this.getL1Bias();
        result = result * 59 + ($l1Bias == null ? 43 : $l1Bias.hashCode());
        ParameterSpace<Double> $l2Bias = this.getL2Bias();
        result = result * 59 + ($l2Bias == null ? 43 : $l2Bias.hashCode());
        ParameterSpace<IUpdater> $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : $updater.hashCode());
        ParameterSpace<IUpdater> $biasUpdater = this.getBiasUpdater();
        result = result * 59 + ($biasUpdater == null ? 43 : $biasUpdater.hashCode());
        ParameterSpace<IWeightNoise> $weightNoise = this.getWeightNoise();
        result = result * 59 + ($weightNoise == null ? 43 : $weightNoise.hashCode());
        ParameterSpace<GradientNormalization> $gradientNormalization = this.getGradientNormalization();
        result = result * 59 + ($gradientNormalization == null ? 43 : $gradientNormalization.hashCode());
        ParameterSpace<Double> $gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        result = result * 59 + ($gradientNormalizationThreshold == null ? 43 : $gradientNormalizationThreshold.hashCode());
        result = result * 59 + this.getNumParameters();
        return result;
    }

    protected BaseLayerSpace() {
    }

    public static abstract class Builder<T>
    extends LayerSpace.Builder<T> {
        protected ParameterSpace<IActivation> activationFunction;
        protected ParameterSpace<WeightInit> weightInit;
        protected ParameterSpace<Double> biasInit;
        protected ParameterSpace<Distribution> dist;
        protected ParameterSpace<Double> l1;
        protected ParameterSpace<Double> l2;
        protected ParameterSpace<Double> l1Bias;
        protected ParameterSpace<Double> l2Bias;
        protected ParameterSpace<IUpdater> updater;
        protected ParameterSpace<IUpdater> biasUpdater;
        protected ParameterSpace<IWeightNoise> weightNoise;
        protected ParameterSpace<GradientNormalization> gradientNormalization;
        protected ParameterSpace<Double> gradientNormalizationThreshold;

        public T activation(Activation ... activations) {
            Preconditions.checkArgument((activations.length > 0 ? 1 : 0) != 0, (Object)"Activations length must be 1 or more");
            if (activations.length == 1) {
                return this.activation(activations[0]);
            }
            return this.activation((ParameterSpace<Activation>)new DiscreteParameterSpace((Object[])activations));
        }

        public T activation(Activation activation) {
            return this.activation((ParameterSpace<Activation>)new FixedValue((Object)activation));
        }

        public T activation(IActivation iActivation) {
            return this.activationFn((ParameterSpace<IActivation>)new FixedValue((Object)iActivation));
        }

        public T activation(ParameterSpace<Activation> activationFunction) {
            return this.activationFn((ParameterSpace<IActivation>)new ActivationParameterSpaceAdapter(activationFunction));
        }

        public T activationFn(ParameterSpace<IActivation> activationFunction) {
            this.activationFunction = activationFunction;
            return (T)this;
        }

        public T weightInit(WeightInit weightInit) {
            return this.weightInit((ParameterSpace<WeightInit>)new FixedValue((Object)weightInit));
        }

        public T weightInit(ParameterSpace<WeightInit> weightInit) {
            this.weightInit = weightInit;
            return (T)this;
        }

        public T weightInit(Distribution distribution) {
            this.weightInit(WeightInit.DISTRIBUTION);
            return this.dist(distribution);
        }

        public T biasInit(double biasInit) {
            return this.biasInit((ParameterSpace<Double>)new FixedValue((Object)biasInit));
        }

        public T biasInit(ParameterSpace<Double> biasInit) {
            this.biasInit = biasInit;
            return (T)this;
        }

        public T dist(Distribution dist) {
            return this.dist((ParameterSpace<Distribution>)new FixedValue((Object)dist));
        }

        public T dist(ParameterSpace<Distribution> dist) {
            this.dist = dist;
            return (T)this;
        }

        public T l1(double l1) {
            return this.l1((ParameterSpace<Double>)new FixedValue((Object)l1));
        }

        public T l1(ParameterSpace<Double> l1) {
            this.l1 = l1;
            return (T)this;
        }

        public T l2(double l2) {
            return this.l2((ParameterSpace<Double>)new FixedValue((Object)l2));
        }

        public T l2(ParameterSpace<Double> l2) {
            this.l2 = l2;
            return (T)this;
        }

        public T l1Bias(double l1Bias) {
            return this.l1Bias((ParameterSpace<Double>)new FixedValue((Object)l1Bias));
        }

        public T l1Bias(ParameterSpace<Double> l1Bias) {
            this.l1Bias = l1Bias;
            return (T)this;
        }

        public T l2Bias(double l2Bias) {
            return this.l2Bias((ParameterSpace<Double>)new FixedValue((Object)l2Bias));
        }

        public T l2Bias(ParameterSpace<Double> l2Bias) {
            this.l2Bias = l2Bias;
            return (T)this;
        }

        public T updater(IUpdater updater) {
            return this.updater((ParameterSpace<IUpdater>)new FixedValue((Object)updater));
        }

        public T updater(ParameterSpace<IUpdater> updater) {
            this.updater = updater;
            return (T)this;
        }

        public T biasUpdater(IUpdater biasUpdater) {
            return this.biasUpdater((ParameterSpace<IUpdater>)new FixedValue((Object)biasUpdater));
        }

        public T biasUpdater(ParameterSpace<IUpdater> biasUpdater) {
            this.biasUpdater = biasUpdater;
            return (T)this;
        }

        public T gradientNormalization(GradientNormalization gradientNormalization) {
            return this.gradientNormalization((ParameterSpace<GradientNormalization>)new FixedValue((Object)gradientNormalization));
        }

        public T gradientNormalization(ParameterSpace<GradientNormalization> gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return (T)this;
        }

        public T gradientNormalizationThreshold(double threshold) {
            return this.gradientNormalizationThreshold((ParameterSpace<Double>)new FixedValue((Object)threshold));
        }

        public T gradientNormalizationThreshold(ParameterSpace<Double> gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
            return (T)this;
        }
    }
}

