/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.FeedForwardLayer;

public abstract class BaseConvolutionLayerSpace<T extends FeedForwardLayer>
extends FeedForwardLayerSpace<T> {
    protected ParameterSpace<int[]> dilation;
    protected ParameterSpace<int[]> kernelSize;
    protected ParameterSpace<int[]> stride;
    protected ParameterSpace<int[]> padding;
    protected ParameterSpace<ConvolutionMode> convolutionMode;
    protected ParameterSpace<Boolean> hasBias;

    protected BaseConvolutionLayerSpace(Builder builder) {
        super(builder);
        this.dilation = builder.dilation;
        this.kernelSize = builder.kernelSize;
        this.stride = builder.stride;
        this.padding = builder.padding;
        this.convolutionMode = builder.convolutionMode;
        this.hasBias = builder.hasBias;
        this.numParameters = LeafUtils.countUniqueParameters(this.collectLeaves());
    }

    protected void setLayerOptionsBuilder(ConvolutionLayer.BaseConvBuilder<?> builder, double[] values) {
        super.setLayerOptionsBuilder((FeedForwardLayer.Builder)builder, values);
        if (this.dilation != null) {
            builder.dilation((int[])this.dilation.getValue(values));
        }
        if (this.kernelSize != null) {
            builder.kernelSize((int[])this.kernelSize.getValue(values));
        }
        if (this.stride != null) {
            builder.stride((int[])this.stride.getValue(values));
        }
        if (this.padding != null) {
            builder.padding((int[])this.padding.getValue(values));
        }
        if (this.convolutionMode != null) {
            builder.convolutionMode((ConvolutionMode)this.convolutionMode.getValue(values));
        }
        if (this.hasBias != null) {
            builder.hasBias(((Boolean)this.hasBias.getValue(values)).booleanValue());
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        StringBuilder sb = new StringBuilder();
        if (this.dilation != null) {
            sb.append("dilation: ").append(this.dilation).append(delim);
        }
        if (this.kernelSize != null) {
            sb.append("kernelSize: ").append(this.kernelSize).append(delim);
        }
        if (this.stride != null) {
            sb.append("stride: ").append(this.stride).append(delim);
        }
        if (this.padding != null) {
            sb.append("padding: ").append(this.padding).append(delim);
        }
        if (this.convolutionMode != null) {
            sb.append("convolutionMode: ").append(this.convolutionMode).append(delim);
        }
        if (this.hasBias != null) {
            sb.append("hasBias: ").append(this.hasBias).append(delim);
        }
        sb.append(super.toString(delim));
        return sb.toString();
    }

    public ParameterSpace<int[]> getDilation() {
        return this.dilation;
    }

    public ParameterSpace<int[]> getKernelSize() {
        return this.kernelSize;
    }

    public ParameterSpace<int[]> getStride() {
        return this.stride;
    }

    public ParameterSpace<int[]> getPadding() {
        return this.padding;
    }

    public ParameterSpace<ConvolutionMode> getConvolutionMode() {
        return this.convolutionMode;
    }

    public ParameterSpace<Boolean> getHasBias() {
        return this.hasBias;
    }

    public void setDilation(ParameterSpace<int[]> dilation) {
        this.dilation = dilation;
    }

    public void setKernelSize(ParameterSpace<int[]> kernelSize) {
        this.kernelSize = kernelSize;
    }

    public void setStride(ParameterSpace<int[]> stride) {
        this.stride = stride;
    }

    public void setPadding(ParameterSpace<int[]> padding) {
        this.padding = padding;
    }

    public void setConvolutionMode(ParameterSpace<ConvolutionMode> convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setHasBias(ParameterSpace<Boolean> hasBias) {
        this.hasBias = hasBias;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseConvolutionLayerSpace)) {
            return false;
        }
        BaseConvolutionLayerSpace other = (BaseConvolutionLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<int[]> this$dilation = this.getDilation();
        ParameterSpace<int[]> other$dilation = other.getDilation();
        if (this$dilation == null ? other$dilation != null : !this$dilation.equals(other$dilation)) {
            return false;
        }
        ParameterSpace<int[]> this$kernelSize = this.getKernelSize();
        ParameterSpace<int[]> other$kernelSize = other.getKernelSize();
        if (this$kernelSize == null ? other$kernelSize != null : !this$kernelSize.equals(other$kernelSize)) {
            return false;
        }
        ParameterSpace<int[]> this$stride = this.getStride();
        ParameterSpace<int[]> other$stride = other.getStride();
        if (this$stride == null ? other$stride != null : !this$stride.equals(other$stride)) {
            return false;
        }
        ParameterSpace<int[]> this$padding = this.getPadding();
        ParameterSpace<int[]> other$padding = other.getPadding();
        if (this$padding == null ? other$padding != null : !this$padding.equals(other$padding)) {
            return false;
        }
        ParameterSpace<ConvolutionMode> this$convolutionMode = this.getConvolutionMode();
        ParameterSpace<ConvolutionMode> other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !this$convolutionMode.equals(other$convolutionMode)) {
            return false;
        }
        ParameterSpace<Boolean> this$hasBias = this.getHasBias();
        ParameterSpace<Boolean> other$hasBias = other.getHasBias();
        return !(this$hasBias == null ? other$hasBias != null : !this$hasBias.equals(other$hasBias));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseConvolutionLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParameterSpace<int[]> $dilation = this.getDilation();
        result = result * 59 + ($dilation == null ? 43 : $dilation.hashCode());
        ParameterSpace<int[]> $kernelSize = this.getKernelSize();
        result = result * 59 + ($kernelSize == null ? 43 : $kernelSize.hashCode());
        ParameterSpace<int[]> $stride = this.getStride();
        result = result * 59 + ($stride == null ? 43 : $stride.hashCode());
        ParameterSpace<int[]> $padding = this.getPadding();
        result = result * 59 + ($padding == null ? 43 : $padding.hashCode());
        ParameterSpace<ConvolutionMode> $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : $convolutionMode.hashCode());
        ParameterSpace<Boolean> $hasBias = this.getHasBias();
        result = result * 59 + ($hasBias == null ? 43 : $hasBias.hashCode());
        return result;
    }

    protected BaseConvolutionLayerSpace() {
    }

    public static abstract class Builder<T>
    extends FeedForwardLayerSpace.Builder<T> {
        protected ParameterSpace<int[]> dilation;
        protected ParameterSpace<int[]> kernelSize;
        protected ParameterSpace<int[]> stride;
        protected ParameterSpace<int[]> padding;
        protected ParameterSpace<ConvolutionMode> convolutionMode;
        protected ParameterSpace<Boolean> hasBias;

        public T dilation(int ... dilation) {
            return this.dilation((ParameterSpace<int[]>)new FixedValue((Object)dilation));
        }

        public T dilation(ParameterSpace<int[]> dilation) {
            this.dilation = dilation;
            return (T)this;
        }

        public T kernelSize(int ... kernelSize) {
            return this.kernelSize((ParameterSpace<int[]>)new FixedValue((Object)kernelSize));
        }

        public T kernelSize(ParameterSpace<int[]> kernelSize) {
            this.kernelSize = kernelSize;
            return (T)this;
        }

        public T stride(int ... stride) {
            return this.stride((ParameterSpace<int[]>)new FixedValue((Object)stride));
        }

        public T stride(ParameterSpace<int[]> stride) {
            this.stride = stride;
            return (T)this;
        }

        public T padding(int ... padding) {
            return this.padding((ParameterSpace<int[]>)new FixedValue((Object)padding));
        }

        public T padding(ParameterSpace<int[]> padding) {
            this.padding = padding;
            return (T)this;
        }

        public T convolutionMode(ConvolutionMode convolutionMode) {
            return this.convolutionMode((ParameterSpace<ConvolutionMode>)new FixedValue((Object)convolutionMode));
        }

        public T convolutionMode(ParameterSpace<ConvolutionMode> convolutionMode) {
            this.convolutionMode = convolutionMode;
            return (T)this;
        }

        public T hasBias(boolean hasBias) {
            return this.hasBias((ParameterSpace<Boolean>)new FixedValue((Object)hasBias));
        }

        public T hasBias(ParameterSpace<Boolean> hasBias) {
            this.hasBias = hasBias;
            return (T)this;
        }
    }
}

