/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.conf.updater.schedule;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.nd4j.linalg.schedule.ExponentialSchedule;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.linalg.schedule.ScheduleType;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class ExponentialScheduleSpace
implements ParameterSpace<ISchedule> {
    private ScheduleType scheduleType;
    private ParameterSpace<Double> initialValue;
    private ParameterSpace<Double> gamma;

    public ExponentialScheduleSpace(@NonNull ScheduleType scheduleType, @NonNull ParameterSpace<Double> initialValue, double gamma) {
        this(scheduleType, initialValue, (ParameterSpace<Double>)new FixedValue((Object)gamma));
        if (scheduleType == null) {
            throw new NullPointerException("scheduleType is marked non-null but is null");
        }
        if (initialValue == null) {
            throw new NullPointerException("initialValue is marked non-null but is null");
        }
    }

    public ExponentialScheduleSpace(@JsonProperty(value="scheduleType") @NonNull ScheduleType scheduleType, @JsonProperty(value="initialValue") @NonNull ParameterSpace<Double> initialValue, @JsonProperty(value="gamma") @NonNull ParameterSpace<Double> gamma) {
        if (scheduleType == null) {
            throw new NullPointerException("scheduleType is marked non-null but is null");
        }
        if (initialValue == null) {
            throw new NullPointerException("initialValue is marked non-null but is null");
        }
        if (gamma == null) {
            throw new NullPointerException("gamma is marked non-null but is null");
        }
        this.scheduleType = scheduleType;
        this.initialValue = initialValue;
        this.gamma = gamma;
    }

    public ISchedule getValue(double[] parameterValues) {
        return new ExponentialSchedule(this.scheduleType, ((Double)this.initialValue.getValue(parameterValues)).doubleValue(), ((Double)this.gamma.getValue(parameterValues)).doubleValue());
    }

    public int numParameters() {
        return this.initialValue.numParameters() + this.gamma.numParameters();
    }

    public List<ParameterSpace> collectLeaves() {
        return Arrays.asList(this.initialValue, this.gamma);
    }

    public Map<String, ParameterSpace> getNestedSpaces() {
        LinkedHashMap<String, ParameterSpace> out = new LinkedHashMap<String, ParameterSpace>();
        out.put("initialValue", this.initialValue);
        out.put("gamma", this.gamma);
        return out;
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIndices(int ... indices) {
        if (this.initialValue.numParameters() > 0) {
            int[] sub = Arrays.copyOfRange(indices, 0, this.initialValue.numParameters());
            this.initialValue.setIndices(sub);
        }
        if (this.gamma.numParameters() > 0) {
            int inp = this.initialValue.numParameters();
            int[] sub = Arrays.copyOfRange(indices, inp, inp + this.gamma.numParameters());
            this.gamma.setIndices(sub);
        }
    }

    public ExponentialScheduleSpace() {
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public ParameterSpace<Double> getInitialValue() {
        return this.initialValue;
    }

    public ParameterSpace<Double> getGamma() {
        return this.gamma;
    }

    public void setScheduleType(ScheduleType scheduleType) {
        this.scheduleType = scheduleType;
    }

    public void setInitialValue(ParameterSpace<Double> initialValue) {
        this.initialValue = initialValue;
    }

    public void setGamma(ParameterSpace<Double> gamma) {
        this.gamma = gamma;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExponentialScheduleSpace)) {
            return false;
        }
        ExponentialScheduleSpace other = (ExponentialScheduleSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScheduleType this$scheduleType = this.getScheduleType();
        ScheduleType other$scheduleType = other.getScheduleType();
        if (this$scheduleType == null ? other$scheduleType != null : !this$scheduleType.equals(other$scheduleType)) {
            return false;
        }
        ParameterSpace<Double> this$initialValue = this.getInitialValue();
        ParameterSpace<Double> other$initialValue = other.getInitialValue();
        if (this$initialValue == null ? other$initialValue != null : !this$initialValue.equals(other$initialValue)) {
            return false;
        }
        ParameterSpace<Double> this$gamma = this.getGamma();
        ParameterSpace<Double> other$gamma = other.getGamma();
        return !(this$gamma == null ? other$gamma != null : !this$gamma.equals(other$gamma));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExponentialScheduleSpace;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScheduleType $scheduleType = this.getScheduleType();
        result = result * 59 + ($scheduleType == null ? 43 : $scheduleType.hashCode());
        ParameterSpace<Double> $initialValue = this.getInitialValue();
        result = result * 59 + ($initialValue == null ? 43 : $initialValue.hashCode());
        ParameterSpace<Double> $gamma = this.getGamma();
        result = result * 59 + ($gamma == null ? 43 : $gamma.hashCode());
        return result;
    }

    public String toString() {
        return "ExponentialScheduleSpace(scheduleType=" + this.getScheduleType() + ", initialValue=" + this.getInitialValue() + ", gamma=" + this.getGamma() + ")";
    }
}

