/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.conf.updater;

import org.deeplearning4j.arbiter.conf.updater.BaseUpdaterSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.learning.config.RmsProp;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class RmsPropSpace
extends BaseUpdaterSpace {
    protected ParameterSpace<Double> learningRate;
    protected ParameterSpace<ISchedule> learningRateSchedule;

    public RmsPropSpace(ParameterSpace<Double> learningRate) {
        this(learningRate, null);
    }

    public RmsPropSpace(@JsonProperty(value="learningRate") ParameterSpace<Double> learningRate, @JsonProperty(value="learningRateSchedule") ParameterSpace<ISchedule> learningRateSchedule) {
        this.learningRate = learningRate;
        this.learningRateSchedule = learningRateSchedule;
    }

    public IUpdater getValue(double[] parameterValues) {
        ISchedule lrS;
        double lr = this.learningRate == null ? 0.1 : (Double)this.learningRate.getValue(parameterValues);
        ISchedule iSchedule = lrS = this.learningRateSchedule == null ? null : (ISchedule)this.learningRateSchedule.getValue(parameterValues);
        if (lrS == null) {
            return new RmsProp(lr);
        }
        return new RmsProp(lrS);
    }

    public ParameterSpace<Double> getLearningRate() {
        return this.learningRate;
    }

    public ParameterSpace<ISchedule> getLearningRateSchedule() {
        return this.learningRateSchedule;
    }

    public void setLearningRate(ParameterSpace<Double> learningRate) {
        this.learningRate = learningRate;
    }

    public void setLearningRateSchedule(ParameterSpace<ISchedule> learningRateSchedule) {
        this.learningRateSchedule = learningRateSchedule;
    }

    @Override
    public String toString() {
        return "RmsPropSpace(learningRate=" + this.getLearningRate() + ", learningRateSchedule=" + this.getLearningRateSchedule() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RmsPropSpace)) {
            return false;
        }
        RmsPropSpace other = (RmsPropSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ParameterSpace<Double> this$learningRate = this.getLearningRate();
        ParameterSpace<Double> other$learningRate = other.getLearningRate();
        if (this$learningRate == null ? other$learningRate != null : !this$learningRate.equals(other$learningRate)) {
            return false;
        }
        ParameterSpace<ISchedule> this$learningRateSchedule = this.getLearningRateSchedule();
        ParameterSpace<ISchedule> other$learningRateSchedule = other.getLearningRateSchedule();
        return !(this$learningRateSchedule == null ? other$learningRateSchedule != null : !this$learningRateSchedule.equals(other$learningRateSchedule));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RmsPropSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ParameterSpace<Double> $learningRate = this.getLearningRate();
        result = result * 59 + ($learningRate == null ? 43 : $learningRate.hashCode());
        ParameterSpace<ISchedule> $learningRateSchedule = this.getLearningRateSchedule();
        result = result * 59 + ($learningRateSchedule == null ? 43 : $learningRateSchedule.hashCode());
        return result;
    }
}

