/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.conf.updater;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.AbstractParameterSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.nd4j.linalg.learning.config.IUpdater;

public abstract class BaseUpdaterSpace
extends AbstractParameterSpace<IUpdater> {
    public int numParameters() {
        int count = 0;
        for (ParameterSpace p : this.collectLeaves()) {
            count += p.numParameters();
        }
        return count;
    }

    public List<ParameterSpace> collectLeaves() {
        Map nested = this.getNestedSpaces();
        ArrayList<ParameterSpace> out = new ArrayList<ParameterSpace>();
        for (ParameterSpace p : nested.values()) {
            out.addAll(p.collectLeaves());
        }
        return out;
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIndices(int ... indices) {
        int soFar = 0;
        for (ParameterSpace p : this.collectLeaves()) {
            int numParams = p.numParameters();
            if (numParams <= 0) continue;
            int[] subset = Arrays.copyOfRange(indices, soFar, soFar + numParams);
            p.setIndices(subset);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseUpdaterSpace)) {
            return false;
        }
        BaseUpdaterSpace other = (BaseUpdaterSpace)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseUpdaterSpace;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "BaseUpdaterSpace()";
    }
}

