/*
 * Decompiled with CFR 0.152.
 */
package org.decampo.xirr;

import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.decampo.xirr.NewtonRaphson;
import org.decampo.xirr.Transaction;
import org.decampo.xirr.XirrDetails;

public class Xirr {
    private static final double DAYS_IN_YEAR = 365.0;
    private final List<Investment> investments;
    private final XirrDetails details;
    private final NewtonRaphson.Builder builder;
    private Double guess;

    public static Builder builder() {
        return new Builder();
    }

    public Xirr(Transaction ... tx) {
        this(Arrays.asList(tx));
    }

    public Xirr(Collection<Transaction> txs) {
        this(txs, null, null);
    }

    private Xirr(Collection<Transaction> txs, NewtonRaphson.Builder builder, Double guess) {
        if (txs.size() < 2) {
            throw new IllegalArgumentException("Must have at least two transactions");
        }
        this.details = txs.stream().collect(XirrDetails.collector());
        this.details.validate();
        this.investments = txs.stream().map(this::createInvestment).collect(Collectors.toList());
        this.builder = builder != null ? builder : NewtonRaphson.builder();
        this.guess = guess;
    }

    private Investment createInvestment(Transaction tx) {
        Investment result = new Investment();
        result.amount = tx.amount;
        result.years = (double)ChronoUnit.DAYS.between(tx.when, this.details.end) / 365.0;
        return result;
    }

    public double presentValue(double rate) {
        return this.investments.stream().mapToDouble(inv -> ((Investment)inv).presentValue(rate)).sum();
    }

    public double derivative(double rate) {
        return this.investments.stream().mapToDouble(inv -> ((Investment)inv).derivative(rate)).sum();
    }

    public double xirr() {
        double years = (double)ChronoUnit.DAYS.between(this.details.start, this.details.end) / 365.0;
        if (this.details.maxAmount == 0.0) {
            return -1.0;
        }
        this.guess = this.guess != null ? this.guess : this.details.total / this.details.deposits / years;
        return this.builder.withFunction(this::presentValue).withDerivative(this::derivative).findRoot(this.guess);
    }

    public static class Builder {
        private Collection<Transaction> transactions = null;
        private NewtonRaphson.Builder builder = null;
        private Double guess = null;

        public Builder withTransactions(Transaction ... txs) {
            return this.withTransactions(Arrays.asList(txs));
        }

        public Builder withTransactions(Collection<Transaction> txs) {
            this.transactions = txs;
            return this;
        }

        public Builder withNewtonRaphsonBuilder(NewtonRaphson.Builder builder) {
            this.builder = builder;
            return this;
        }

        public Builder withGuess(double guess) {
            this.guess = guess;
            return this;
        }

        public Xirr build() {
            return new Xirr(this.transactions, this.builder, this.guess);
        }

        public double xirr() {
            return this.build().xirr();
        }
    }

    private static class Investment {
        double amount;
        double years;

        private Investment() {
        }

        private double presentValue(double rate) {
            if (-1.0 < rate) {
                return this.amount * Math.pow(1.0 + rate, this.years);
            }
            if (rate < -1.0) {
                return -Math.abs(this.amount) * Math.pow(-1.0 - rate, this.years);
            }
            if (this.years == 0.0) {
                return this.amount;
            }
            return 0.0;
        }

        private double derivative(double rate) {
            if (this.years == 0.0) {
                return 0.0;
            }
            if (-1.0 < rate) {
                return this.amount * this.years * Math.pow(1.0 + rate, this.years - 1.0);
            }
            if (rate < -1.0) {
                return Math.abs(this.amount) * this.years * Math.pow(-1.0 - rate, this.years - 1.0);
            }
            return 0.0;
        }
    }
}

