/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.datayoo.moql.util.ClassLoaderUtils;
import org.datayoo.moql.util.StringFormater;

public abstract class ResourceUtils {
    public static final String PREFIX_SEPARATOR = ":";
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String JAR_URL_SEPARATOR = "!/";

    public static URL getURL(String resourceLocation) throws FileNotFoundException {
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            URL url = ClassLoaderUtils.getDefaultClassLoader().getResource(path);
            if (url == null) {
                throw new FileNotFoundException(StringFormater.format("Resource location '{}'cannot be resolved to URL because it does not exist!", resourceLocation));
            }
            return url;
        }
        try {
            return new URL(resourceLocation);
        }
        catch (MalformedURLException ex) {
            try {
                return new File(resourceLocation).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new FileNotFoundException(StringFormater.format("Resource location '{}' is neither a URL not a well-formed file path", resourceLocation));
            }
        }
    }

    public static File getFile(String resourceLocation) throws FileNotFoundException {
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            URL url = ClassLoaderUtils.getDefaultClassLoader().getResource(path);
            if (url == null) {
                throw new FileNotFoundException(StringFormater.format("'{}' cannot be resolved to absolute file path because it does not reside in the file system", resourceLocation));
            }
            return ResourceUtils.getFile(url);
        }
        try {
            return ResourceUtils.getFile(new URL(resourceLocation));
        }
        catch (MalformedURLException ex) {
            return new File(resourceLocation);
        }
    }

    public static File getFile(URL resourceUrl) throws FileNotFoundException {
        if (!URL_PROTOCOL_FILE.equals(resourceUrl.getProtocol())) {
            throw new FileNotFoundException(StringFormater.format("'{}' cannot be resolved to absolute file path because it does not reside in the file system", resourceUrl.toString()));
        }
        try {
            return new File(ResourceUtils.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(resourceUrl.getFile());
        }
    }

    public static File getFile(URI resourceUri) throws FileNotFoundException {
        if (!URL_PROTOCOL_FILE.equals(resourceUri.getScheme())) {
            throw new FileNotFoundException(StringFormater.format("'{}' cannot be resolved to absolute file path because it does not reside in the file system", resourceUri.toString()));
        }
        return new File(resourceUri.getSchemeSpecificPart());
    }

    public static boolean isUrl(String resourceLocation) {
        if (resourceLocation == null) {
            return false;
        }
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            return true;
        }
        try {
            new URL(resourceLocation);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public static boolean isJarURL(URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol);
    }

    public static URL extractJarFileURL(URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            return new URL(urlFile.substring(0, separatorIndex));
        }
        return jarUrl;
    }

    public static URI toURI(URL url) throws URISyntaxException {
        return ResourceUtils.toURI(url.toString());
    }

    public static URI toURI(String location) throws URISyntaxException {
        return new URI(StringUtils.replace((String)location, (String)" ", (String)"%20"));
    }
}

