/*
 * Decompiled with CFR 0.152.
 */
package org.datayoo.moql.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Objects;
import org.datayoo.moql.io.AbstractResource;
import org.datayoo.moql.util.ClassLoaderUtils;
import org.datayoo.moql.util.PathUtils;
import org.datayoo.moql.util.ResourceUtils;
import org.datayoo.moql.util.StringFormater;

public class ClassPathResource
extends AbstractResource {
    private final String path;
    private ClassLoader classLoader;
    private Class clazz;

    public ClassPathResource(String path) {
        this(path, (ClassLoader)null);
    }

    public ClassPathResource(String path, ClassLoader classLoader) {
        String pathToUse = PathUtils.toCanonicalPath(path);
        if (pathToUse.startsWith("/")) {
            pathToUse = pathToUse.substring(1);
        }
        this.path = pathToUse;
        this.classLoader = classLoader != null ? classLoader : ClassLoaderUtils.getDefaultClassLoader();
    }

    public ClassPathResource(String path, Class clazz) {
        this.path = PathUtils.toCanonicalPath(path);
        this.clazz = clazz;
    }

    protected ClassPathResource(String path, ClassLoader classLoader, Class clazz) {
        this.path = PathUtils.toCanonicalPath(path);
        this.classLoader = classLoader;
        this.clazz = clazz;
    }

    public final String getPath() {
        return this.path;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader != null ? this.classLoader : this.clazz.getClassLoader();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = null;
        is = this.clazz != null ? this.clazz.getResourceAsStream(this.path) : this.classLoader.getResourceAsStream(this.path);
        if (is == null) {
            throw new FileNotFoundException(StringFormater.format("'{}' cannot be opened because it does not exist", this.getResourceLocation()));
        }
        return is;
    }

    @Override
    public URL getURL() throws IOException {
        URL url = null;
        url = this.clazz != null ? this.clazz.getResource(this.path) : this.classLoader.getResource(this.path);
        if (url == null) {
            throw new FileNotFoundException(StringFormater.format("'{}' cannot be resolved to URL because it does not exist", this.getResourceLocation()));
        }
        return url;
    }

    @Override
    public File getFile() throws IOException {
        return ResourceUtils.getFile(this.getURL());
    }

    @Override
    protected File getFile2Check() throws IOException {
        URL url = this.getURL();
        if (ResourceUtils.isJarURL(url)) {
            URL actualUrl = ResourceUtils.extractJarFileURL(url);
            return ResourceUtils.getFile(actualUrl);
        }
        return ResourceUtils.getFile(url);
    }

    @Override
    public String getResourceName() {
        return PathUtils.getFileName(this.path);
    }

    @Override
    public String getResourceLocation() {
        return StringFormater.format("{}{}", "classpath:", this.path);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ClassPathResource) {
            ClassPathResource otherRes = (ClassPathResource)obj;
            return this.path.equals(otherRes.path) && Objects.deepEquals(this.classLoader, otherRes.classLoader) && Objects.deepEquals(this.clazz, otherRes.clazz);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("Not supported!");
    }
}

