/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.datayoo.moql.metadata;

import org.apache.commons.lang3.Validate;

import java.io.Serializable;

/**
 * 
 * @author Tang Tadin
 *
 */
public class LogicOperationMetadata extends OperationMetadata implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	protected OperationMetadata lOperand;	
	
	protected OperationMetadata rOperand;
	
	public LogicOperationMetadata(String operator, OperationMetadata lOperand, OperationMetadata rOperand) {
		super(OperatorType.BINARY, operator);
		Validate.notNull(lOperand, "Parameter 'lOperand' is null!");
		Validate.notNull(rOperand, "Parameter 'rOperand' is null!");

		this.lOperand = lOperand;
		this.rOperand = rOperand;
	}
	
	public LogicOperationMetadata(String operator, OperationMetadata operand) {
		super(OperatorType.UNARY, operator);
		Validate.notNull(operand, "Parameter 'operand' is null!");

		this.rOperand = operand;
	}

	/**
	 * @return the lOperand
	 */
	public OperationMetadata getLeftOperand() {
		return lOperand;
	}

	/**
	 * @return the rOperand
	 */
	public OperationMetadata getRightOperand() {
		return rOperand;
	}
	
	

}
