/*
 * Decompiled with CFR 0.152.
 */
package org.dataverse.unf;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.logging.Logger;
import org.dataverse.unf.UnfCons;

public class UtilsConverter
implements UnfCons {
    private static Logger mLog = Logger.getLogger(UtilsConverter.class.getName());

    public static String convertnioByteToStr(byte[] inbyte, String outset) {
        Charset original;
        Charset cset = original = Charset.defaultCharset();
        try {
            cset = Charset.forName(outset);
        }
        catch (UnsupportedCharsetException err0) {
            mLog.severe("CanonUnicode: " + err0.getMessage() + "...Using the machine default");
            err0.printStackTrace();
        }
        catch (IllegalCharsetNameException err1) {
            mLog.severe("CanonUnicode: " + err1.getMessage() + "...Using the machine default");
            err1.printStackTrace();
        }
        catch (IllegalArgumentException err2) {
            mLog.severe("CanonUnicode: " + err2.getMessage() + "...Using the machine default");
            err2.printStackTrace();
        }
        ByteBuffer bbuf = ByteBuffer.wrap(inbyte, 0, inbyte.length);
        CharBuffer cbuf = cset.canEncode() ? cset.decode(bbuf) : original.decode(bbuf);
        return cbuf.toString();
    }

    public static byte[] getBytes(char[] colch, String cset) {
        Charset original;
        Charset ccset = original = Charset.defaultCharset();
        if (cset != null && Charset.isSupported(cset)) {
            ccset = Charset.forName(cset);
        }
        CharBuffer cb = CharBuffer.wrap(colch);
        ByteBuffer buf = null;
        buf = ccset.canEncode() ? ccset.encode(cb) : original.encode(cb);
        return buf.array();
    }

    public byte[] getBytes1(char[] ch, String cset) {
        Charset original;
        Charset ccset = original = Charset.defaultCharset();
        if (cset != null && Charset.isSupported(cset)) {
            ccset = Charset.forName(cset);
        }
        return String.valueOf(ch).getBytes(ccset);
    }

    public static byte[] byteConverter(byte[] bin, String ... cset) throws UnsupportedEncodingException {
        Charset to;
        Charset original = Charset.defaultCharset();
        String strbin = null;
        if (cset.length > 2) {
            mLog.severe("canonUnicode: Provide only two values for encoding");
        } else {
            if (cset.length <= 0) {
                mLog.severe("canonUnicode: Not provided encoding for array of byte");
                return bin;
            }
            if (cset.length == 2 && cset[0].equals(cset[1])) {
                return bin;
            }
        }
        if (cset.length > 1) {
            if (Charset.isSupported(cset[1])) {
                Charset from = Charset.forName(cset[1]);
                if (from.canEncode()) {
                    strbin = new String(bin, cset[1]);
                } else {
                    mLog.severe("canonUnicode: Charset " + cset[1] + " no encode...Using default");
                    strbin = new String(bin, original);
                }
            } else {
                mLog.severe("canonUnicode: Charset " + cset[1] + " not supported...Using default");
                strbin = new String(bin, original);
            }
        }
        if (Charset.isSupported(cset[0])) {
            to = Charset.forName(cset[0]);
            if (!to.canEncode()) {
                to = original;
            }
        } else {
            mLog.severe("canonUnicode: Charset " + cset[0] + " not supported...Using default");
            to = original;
        }
        byte[] bout = strbin.getBytes(to);
        return bout;
    }

    public static byte[] byteConverter(byte[] bin, Charset ... cset) throws UnsupportedEncodingException {
        if (cset.length > 2) {
            mLog.severe("canonUnicode: Provide only two values for encoding");
        } else if (cset.length <= 0) {
            mLog.severe("canonUnicode: Not provided encoding for array of byte");
            return bin;
        }
        String[] csetstr = new String[2];
        if (cset.length <= 1) {
            String dest = cset[0].name();
            return UtilsConverter.byteConverter(bin, dest);
        }
        csetstr[0] = cset[0].name();
        csetstr[1] = cset[1].name();
        return UtilsConverter.byteConverter(bin, csetstr);
    }

    public static String getHexStrng(byte[] messageDigest) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < messageDigest.length; ++i) {
            hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
        }
        return hexString.toString();
    }

    public byte[] hexStrngToBytes(String str) {
        byte[] bts = new BigInteger(str, 16).toByteArray();
        return bts;
    }
}

