/*
 * Decompiled with CFR 0.152.
 */
package org.dataverse.unf;

public class UnfDateFormatter {
    private boolean isValidUnfDate;
    private StringBuffer unfFormatString;
    private boolean timeZoneSpecified;

    public UnfDateFormatter(String formatString) {
        this.getDateTimeRepresentation(formatString);
        if (!this.isValidUnfDate) {
            this.getTimeRepresentation(formatString);
        }
    }

    private void getDateTimeRepresentation(String formatString) {
        if (this.hasYear(formatString)) {
            this.unfFormatString = new StringBuffer();
            this.isValidUnfDate = true;
            this.unfFormatString.append("yyyy");
            if (this.hasMonth(formatString)) {
                this.unfFormatString.append("-MM");
                if (this.hasDay(formatString)) {
                    this.unfFormatString.append("-dd");
                    this.getTimeRepresentation(formatString);
                }
            } else if (formatString.indexOf(100) > -1) {
                this.isValidUnfDate = false;
            }
            if (!this.isValidUnfDate) {
                this.unfFormatString = null;
            }
        }
    }

    private void getTimeRepresentation(String formatString) {
        if (this.hasHour(formatString)) {
            if (this.isValidUnfDate) {
                this.unfFormatString.append("'T'");
            } else if (this.unfFormatString == null) {
                this.unfFormatString = new StringBuffer();
            }
            this.unfFormatString.append("HH");
            if (this.hasTimeZone(formatString)) {
                this.timeZoneSpecified = true;
            }
            if (this.hasMinute(formatString)) {
                this.unfFormatString.append(":mm");
                if (this.hasSecond(formatString)) {
                    this.unfFormatString.append(":ss");
                    if (this.hasMillisecond(formatString)) {
                        this.unfFormatString.append(".SSS");
                    }
                }
            }
            if (this.timeZoneSpecified) {
                this.unfFormatString.append("'Z'");
            }
        }
    }

    private boolean hasYear(String formatString) {
        return formatString.indexOf(121) > -1;
    }

    private boolean hasMonth(String formatString) {
        return formatString.indexOf(77) > -1;
    }

    private boolean hasDay(String formatString) {
        return formatString.indexOf(100) > -1;
    }

    private boolean hasHour(String formatString) {
        return formatString.indexOf(107) > -1 || formatString.indexOf(104) > -1 || formatString.indexOf(75) > -1 || formatString.indexOf(72) > -1;
    }

    private boolean hasMinute(String formatString) {
        return formatString.indexOf(109) > -1;
    }

    private boolean hasSecond(String formatString) {
        return formatString.indexOf(115) > -1;
    }

    private boolean hasMillisecond(String formatString) {
        return formatString.indexOf(83) > -1;
    }

    private boolean hasTimeZone(String formatString) {
        return formatString.indexOf(122) > -1 || formatString.indexOf(90) > -1;
    }

    private boolean hasEra(String formatString) {
        return formatString.indexOf(71) > -1;
    }

    private boolean hasWeekInYear(String formatString) {
        return formatString.indexOf(119) > -1;
    }

    private boolean hasDayInYear(String formatString) {
        return formatString.indexOf(68) > -1;
    }

    private boolean hasDayOfWeekInMonth(String formatString) {
        return formatString.indexOf(70) > -1;
    }

    private boolean hasDayOfWeek(String formatString) {
        return formatString.indexOf(69) > -1;
    }

    public StringBuffer getUnfFormatString() {
        return this.unfFormatString;
    }

    public void setUnfFormatString(StringBuffer unfFormatString) {
        this.unfFormatString = unfFormatString;
    }

    public boolean isTimeZoneSpecified() {
        return this.timeZoneSpecified;
    }

    public void setTimeZoneSpecified(boolean timeZoneSpecified) {
        this.timeZoneSpecified = timeZoneSpecified;
    }
}

