/*
 * Decompiled with CFR 0.152.
 */
package org.dataverse.unf;

import java.util.ArrayList;
import java.util.List;

public class UnfClass {
    private int cdigits = 128;
    private int ndigits = 7;
    private int hsize = 128;
    private List<Integer[]> fingerprints = new ArrayList<Integer[]>();
    private List<String> hexvalue = new ArrayList<String>();
    private List<String> b64 = new ArrayList<String>();
    private String extensions = "";

    public UnfClass() {
    }

    public UnfClass(int cd, int nd) {
        this.cdigits = cd;
        this.ndigits = nd;
        if (cd != 128) {
            this.addExtension("X" + cd);
        }
        if (nd != 7) {
            this.addExtension("N" + nd);
        }
    }

    public UnfClass(int cd, int nd, int hsz) {
        this.cdigits = cd;
        this.ndigits = nd;
        this.hsize = hsz;
        if (cd != 128) {
            this.addExtension("X" + cd);
        }
        if (nd != 7) {
            this.addExtension("N" + nd);
        }
        if (hsz != 128) {
            this.addExtension("H" + hsz);
        }
    }

    public int getCdigits() {
        return this.cdigits;
    }

    public void setCdigits(int d) {
        this.cdigits = d;
    }

    public int getNdigits() {
        return this.ndigits;
    }

    public void setNdigits(int d) {
        this.ndigits = d;
    }

    public List<String> getHexvalue() {
        return this.hexvalue;
    }

    public void setHexvalue(List<String> s) {
        this.hexvalue = s;
    }

    public List<String> getB64() {
        return this.b64;
    }

    public void setB64(List<String> b) {
        this.b64 = b;
    }

    public List<Integer[]> getFingerprints() {
        return this.fingerprints;
    }

    public void setFingerprints(List<Integer[]> fg) {
        this.fingerprints = fg;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String extensions) {
        this.extensions = extensions;
    }

    public void addExtension(String ext) {
        if (this.getExtensions().length() > 0) {
            this.setExtensions(this.getExtensions() + "," + ext);
        } else {
            this.setExtensions(this.getExtensions() + ext);
        }
    }

    public int getHsize() {
        return this.hsize;
    }

    public void setHsize(int hsize) {
        this.hsize = hsize;
    }
}

