/*
 * Decompiled with CFR 0.152.
 */
package org.dataverse.unf;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dataverse.unf.Base64Encoding;
import org.dataverse.unf.UnfCons;
import org.dataverse.unf.UnfDigestUtils;
import org.dataverse.unf.UtilsConverter;

public class UnfBoolean<T extends Number>
implements UnfCons {
    private static Logger mLog = Logger.getLogger(UnfBoolean.class.getName());
    private String orencoding = null;
    private String encoding = "UTF-8";
    private static boolean VCPP;
    private Locale currentlocale = Locale.getDefault();
    private String mdalgor = "SHA-256";
    private MessageDigest md = null;

    public UnfBoolean() {
        mLog.setLevel(Level.WARNING);
        if (this.orencoding == null) {
            this.orencoding = "UTF-8";
        }
        try {
            this.md = MessageDigest.getInstance(this.mdalgor);
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException(err.getMessage());
        }
    }

    public UnfBoolean(String algor) {
        mLog.setLevel(Level.WARNING);
        this.mdalgor = algor;
        try {
            this.md = MessageDigest.getInstance(algor);
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException(err.getMessage());
        }
    }

    public UnfBoolean(String dch, String or) {
        this();
        this.encoding = dch;
        this.orencoding = or;
    }

    public UnfBoolean(String algor, String dch, String or) {
        this(algor);
        this.encoding = dch;
        this.orencoding = or;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String fenc) {
        this.encoding = fenc;
    }

    public String getMdalgor() {
        return this.mdalgor;
    }

    public void setMdalgor(String aa) {
        this.mdalgor = aa;
        MessageDigest mdm = null;
        try {
            this.md = mdm = MessageDigest.getInstance(aa);
        }
        catch (NoSuchAlgorithmException err) {
            throw new RuntimeException(err.getMessage());
        }
    }

    public boolean getNullbyte() {
        return true;
    }

    public static int mysinf(Double x) {
        if (VCPP) {
            if (!x.isInfinite() || !x.isNaN()) {
                return 0;
            }
            if (x.isNaN()) {
                return 0;
            }
            if (x > 0.0) {
                return 1;
            }
            return -1;
        }
        Boolean b = x.isInfinite();
        if (b.booleanValue()) {
            return 1;
        }
        return 0;
    }

    public String RUNF5(Boolean[] v, List<Integer> result, Character[] base64, StringBuilder hex) throws UnsupportedEncodingException, IOException {
        int nv = v.length;
        double dub = 0.0;
        boolean miss = false;
        int k = 0;
        int[] v5bitsize = new int[]{128, 192, 256};
        for (k = 0; k < nv; ++k) {
            miss = v[k] == null;
            this.md = this.UNF5(v[k], this.md, miss);
        }
        byte[] hash = this.md.digest();
        this.md.reset();
        byte[] v5hash = this.truncateHash(hash, v5bitsize[0]);
        byte[] inthash = new byte[v5hash.length];
        for (k = 0; k < v5hash.length; ++k) {
            int h = v5hash[k] & 0xFF;
            inthash[k] = (byte)h;
            result.add(h + 0);
        }
        Integer[] res = result.toArray(new Integer[16]);
        mLog.finer("Base64 encoding in BIG-ENDIAN");
        String tobase64 = Base64Encoding.tobase64(inthash, false);
        String hexstr = UtilsConverter.getHexStrng(v5hash);
        hex.append(hexstr);
        mLog.finer("hex " + hex);
        if (hash.length > 16 && this.mdalgor.equals("MD5")) {
            mLog.finer("unfNumber: hash has more than 16 bytes.." + hash.length);
        }
        for (int n = 0; n < tobase64.length(); ++n) {
            base64[n] = new Character(tobase64.charAt(n));
        }
        return tobase64;
    }

    byte[] truncateHash(byte[] hash, int n) {
        int bits = n / 8;
        byte[] rhash = new byte[bits];
        for (int x = 0; x < bits; ++x) {
            rhash[x] = hash[x];
        }
        return rhash;
    }

    public MessageDigest UNF5(Boolean obj, MessageDigest previous, boolean miss) throws UnsupportedEncodingException, IOException {
        if (!miss) {
            Object tmps;
            Object object = tmps = obj == true ? "1" : "0";
            if (tmps == null) {
                mLog.severe("UNF3: Genround returns null");
                return previous;
            }
            mLog.finer("UNF3: Genround: " + (String)tmps);
            int sz = ((String)tmps).length();
            if (((String)tmps).charAt(sz - 1) != zeroscape) {
                tmps = (String)tmps + zeroscape;
            }
            String[] dec = new String[]{this.encoding, this.orencoding != null ? this.orencoding : Charset.defaultCharset().name()};
            byte[] bt = null;
            bt = this.orencoding != null ? ((String)tmps).getBytes(this.orencoding) : ((String)tmps).getBytes();
            String tmp = "";
            byte[] tmpu = null;
            tmpu = UtilsConverter.byteConverter(bt, dec);
            if (tmpu == null) {
                mLog.severe("UNF3: CanonalizeUnicode returns null");
                return previous;
            }
            byte[] bint = tmpu;
            bint = UnfDigestUtils.eliminateZeroPadding(tmpu, bt);
            Object tmp0 = "";
            for (int n = 0; n < bint.length; ++n) {
                tmp0 = (String)tmp0 + "\t" + bint[n];
            }
            mLog.finer("after " + (String)tmp0);
            previous.update(bint);
        }
        if (miss) {
            byte[] tpu = UtilsConverter.getBytes(missv, null);
            previous.update(tpu);
        }
        return previous;
    }
}

