/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.local.transforms.join;

import java.util.Collections;
import java.util.List;
import org.datavec.api.transform.join.Join;
import org.datavec.api.writable.Writable;
import org.datavec.local.transforms.functions.FlatMapFunctionAdapter;
import org.datavec.local.transforms.join.JoinedValue;

public class FilterAndFlattenJoinedValuesAdapter
implements FlatMapFunctionAdapter<JoinedValue, List<Writable>> {
    private final Join.JoinType joinType;

    public FilterAndFlattenJoinedValuesAdapter(Join.JoinType joinType) {
        this.joinType = joinType;
    }

    @Override
    public List<List<Writable>> call(JoinedValue joinedValue) throws Exception {
        boolean keep;
        switch (this.joinType) {
            case Inner: {
                keep = joinedValue.isHaveLeft() && joinedValue.isHaveRight();
                break;
            }
            case LeftOuter: {
                keep = joinedValue.isHaveLeft();
                break;
            }
            case RightOuter: {
                keep = joinedValue.isHaveRight();
                break;
            }
            case FullOuter: {
                keep = true;
                break;
            }
            default: {
                throw new RuntimeException("Unknown/not implemented join type: " + this.joinType);
            }
        }
        if (keep) {
            return Collections.singletonList(joinedValue.getValues());
        }
        return Collections.emptyList();
    }
}

