/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.recordreader.objdetect.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.PointerPointer;
import org.bytedeco.javacpp.hdf5;
import org.datavec.image.recordreader.objdetect.ImageObject;
import org.datavec.image.recordreader.objdetect.ImageObjectLabelProvider;

public class SvhnLabelProvider
implements ImageObjectLabelProvider {
    private static hdf5.DataType refType = new hdf5.DataType(hdf5.PredType.STD_REF_OBJ());
    private static hdf5.DataType charType = new hdf5.DataType(hdf5.PredType.NATIVE_CHAR());
    private static hdf5.DataType intType = new hdf5.DataType(hdf5.PredType.NATIVE_INT());
    private Map<String, List<ImageObject>> labelMap = new HashMap<String, List<ImageObject>>();

    public SvhnLabelProvider(File dir) throws IOException {
        hdf5.H5File file = new hdf5.H5File(dir.getPath() + "/digitStruct.mat", hdf5.H5F_ACC_RDONLY());
        hdf5.Group group = file.openGroup("digitStruct");
        hdf5.DataSet nameDataset = group.openDataSet("name");
        hdf5.DataSpace nameSpace = nameDataset.getSpace();
        hdf5.DataSet bboxDataset = group.openDataSet("bbox");
        hdf5.DataSpace bboxSpace = bboxDataset.getSpace();
        long[] dims = new long[2];
        bboxSpace.getSimpleExtentDims(dims);
        int n = (int)(dims[0] * dims[1]);
        int ptrSize = Loader.sizeof(Pointer.class);
        PointerPointer namePtr = new PointerPointer((long)n);
        PointerPointer bboxPtr = new PointerPointer((long)n);
        nameDataset.read((Pointer)namePtr, refType);
        bboxDataset.read((Pointer)bboxPtr, refType);
        BytePointer bytePtr = new BytePointer(256L);
        PointerPointer topPtr = new PointerPointer(256L);
        PointerPointer leftPtr = new PointerPointer(256L);
        PointerPointer heightPtr = new PointerPointer(256L);
        PointerPointer widthPtr = new PointerPointer(256L);
        PointerPointer labelPtr = new PointerPointer(256L);
        IntPointer intPtr = new IntPointer(256L);
        for (int i = 0; i < n; ++i) {
            boolean isFloat;
            hdf5.DataSet nameRef = new hdf5.DataSet((hdf5.H5Location)file, (Pointer)namePtr.position((long)(i * ptrSize)));
            nameRef.read(bytePtr, charType);
            String filename = bytePtr.getString();
            hdf5.Group bboxGroup = new hdf5.Group((hdf5.H5Location)file, (Pointer)bboxPtr.position((long)(i * ptrSize)));
            hdf5.DataSet topDataset = bboxGroup.openDataSet("top");
            hdf5.DataSet leftDataset = bboxGroup.openDataSet("left");
            hdf5.DataSet heightDataset = bboxGroup.openDataSet("height");
            hdf5.DataSet widthDataset = bboxGroup.openDataSet("width");
            hdf5.DataSet labelDataset = bboxGroup.openDataSet("label");
            hdf5.DataSpace topSpace = topDataset.getSpace();
            topSpace.getSimpleExtentDims(dims);
            int m = (int)(dims[0] * dims[1]);
            ArrayList<ImageObject> list = new ArrayList<ImageObject>(m);
            boolean bl = isFloat = topDataset.asAbstractDs().getTypeClass() == 1;
            if (!isFloat) {
                topDataset.read((Pointer)topPtr.position(0L), refType);
                leftDataset.read((Pointer)leftPtr.position(0L), refType);
                heightDataset.read((Pointer)heightPtr.position(0L), refType);
                widthDataset.read((Pointer)widthPtr.position(0L), refType);
                labelDataset.read((Pointer)labelPtr.position(0L), refType);
            }
            assert (!isFloat || m == 1);
            for (int j = 0; j < m; ++j) {
                hdf5.DataSet topSet = isFloat ? topDataset : new hdf5.DataSet((hdf5.H5Location)file, (Pointer)topPtr.position((long)(j * ptrSize)));
                topSet.read((Pointer)intPtr, intType);
                int top = intPtr.get();
                hdf5.DataSet leftSet = isFloat ? leftDataset : new hdf5.DataSet((hdf5.H5Location)file, (Pointer)leftPtr.position((long)(j * ptrSize)));
                leftSet.read((Pointer)intPtr, intType);
                int left = intPtr.get();
                hdf5.DataSet heightSet = isFloat ? heightDataset : new hdf5.DataSet((hdf5.H5Location)file, (Pointer)heightPtr.position((long)(j * ptrSize)));
                heightSet.read((Pointer)intPtr, intType);
                int height = intPtr.get();
                hdf5.DataSet widthSet = isFloat ? widthDataset : new hdf5.DataSet((hdf5.H5Location)file, (Pointer)widthPtr.position((long)(j * ptrSize)));
                widthSet.read((Pointer)intPtr, intType);
                int width = intPtr.get();
                hdf5.DataSet labelSet = isFloat ? labelDataset : new hdf5.DataSet((hdf5.H5Location)file, (Pointer)labelPtr.position((long)(j * ptrSize)));
                labelSet.read((Pointer)intPtr, intType);
                int label = intPtr.get();
                if (label == 10) {
                    label = 0;
                }
                list.add(new ImageObject(left, top, left + width, top + height, Integer.toString(label)));
                topSet.deallocate();
                leftSet.deallocate();
                heightSet.deallocate();
                widthSet.deallocate();
                labelSet.deallocate();
            }
            topSpace.deallocate();
            if (!isFloat) {
                topDataset.deallocate();
                leftDataset.deallocate();
                heightDataset.deallocate();
                widthDataset.deallocate();
                labelDataset.deallocate();
            }
            nameRef.deallocate();
            bboxGroup.deallocate();
            this.labelMap.put(filename, list);
        }
        nameSpace.deallocate();
        bboxSpace.deallocate();
        nameDataset.deallocate();
        bboxDataset.deallocate();
        group.deallocate();
        file.deallocate();
    }

    @Override
    public List<ImageObject> getImageObjectsForPath(String path) {
        File file = new File(path);
        String filename = file.getName();
        return this.labelMap.get(filename);
    }

    @Override
    public List<ImageObject> getImageObjectsForPath(URI uri) {
        return this.getImageObjectsForPath(uri.toString());
    }
}

