/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.image.loader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.datavec.api.io.filters.BalancedPathFilter;
import org.datavec.api.io.filters.PathFilter;
import org.datavec.api.io.labels.PathLabelGenerator;
import org.datavec.api.io.labels.PatternPathLabelGenerator;
import org.datavec.api.records.reader.RecordReader;
import org.datavec.api.split.FileSplit;
import org.datavec.api.split.InputSplit;
import org.datavec.image.data.Image;
import org.datavec.image.loader.BaseImageLoader;
import org.datavec.image.recordreader.ImageRecordReader;
import org.datavec.image.transform.ImageTransform;
import org.nd4j.linalg.api.ndarray.INDArray;

public class LFWLoader
extends BaseImageLoader
implements Serializable {
    public static final int NUM_IMAGES = 13233;
    public static final int NUM_LABELS = 5749;
    public static final int SUB_NUM_IMAGES = 1054;
    public static final int SUB_NUM_LABELS = 432;
    public static final int HEIGHT = 250;
    public static final int WIDTH = 250;
    public static final int CHANNELS = 3;
    public static final String DATA_URL = "http://vis-www.cs.umass.edu/lfw/lfw.tgz";
    public static final String LABEL_URL = "http://vis-www.cs.umass.edu/lfw/lfw-names.txt";
    public static final String SUBSET_URL = "http://vis-www.cs.umass.edu/lfw/lfw-a.tgz";
    protected static final String REGEX_PATTERN = ".[0-9]+";
    public static final PathLabelGenerator LABEL_PATTERN = new PatternPathLabelGenerator(".[0-9]+");
    public String dataFile = "lfw";
    public String labelFile = "lfw-names.txt";
    public String subsetFile = "lfw-a";
    public String localDir = "lfw";
    public String localSubDir = "lfw-a/lfw";
    protected File fullDir;
    protected boolean useSubset = false;
    InputSplit[] inputSplit;
    public static Map<String, String> lfwData = new HashMap<String, String>();
    public static Map<String, String> lfwLabel = new HashMap<String, String>();
    public static Map<String, String> lfwSubsetData = new HashMap<String, String>();

    public LFWLoader() {
        this(false);
    }

    public LFWLoader(boolean useSubset) {
        this(new long[]{250L, 250L, 3L}, null, useSubset);
    }

    public LFWLoader(int[] imgDim, boolean useSubset) {
        this(imgDim, (ImageTransform)null, useSubset);
    }

    public LFWLoader(long[] imgDim, boolean useSubset) {
        this(imgDim, null, useSubset);
    }

    public LFWLoader(int[] imgDim, ImageTransform imgTransform, boolean useSubset) {
        this.height = imgDim[0];
        this.width = imgDim[1];
        this.channels = imgDim[2];
        this.imageTransform = imgTransform;
        this.useSubset = useSubset;
        this.localDir = useSubset ? this.localSubDir : this.localDir;
        this.fullDir = new File(BASE_DIR, this.localDir);
        this.generateLfwMaps();
    }

    public LFWLoader(long[] imgDim, ImageTransform imgTransform, boolean useSubset) {
        this.height = imgDim[0];
        this.width = imgDim[1];
        this.channels = imgDim[2];
        this.imageTransform = imgTransform;
        this.useSubset = useSubset;
        this.localDir = useSubset ? this.localSubDir : this.localDir;
        this.fullDir = new File(BASE_DIR, this.localDir);
        this.generateLfwMaps();
    }

    public void generateLfwMaps() {
        if (this.useSubset) {
            lfwSubsetData.put("filesFilename", new File(SUBSET_URL).getName());
            lfwSubsetData.put("filesURL", SUBSET_URL);
            lfwSubsetData.put("filesFilenameUnzipped", this.subsetFile);
        } else {
            lfwData.put("filesFilename", new File(DATA_URL).getName());
            lfwData.put("filesURL", DATA_URL);
            lfwData.put("filesFilenameUnzipped", this.dataFile);
            lfwLabel.put("filesFilename", this.labelFile);
            lfwLabel.put("filesURL", LABEL_URL);
            lfwLabel.put("filesFilenameUnzipped", this.labelFile);
        }
    }

    public void load() {
        this.load(13233L, 13233L, 5749L, LABEL_PATTERN, 1.0, this.rng);
    }

    public void load(long batchSize, long numExamples, long numLabels, PathLabelGenerator labelGenerator, double splitTrainTest, Random rng) {
        if (!(this.imageFilesExist() || this.fullDir.exists() && this.fullDir.listFiles() != null && this.fullDir.listFiles().length != 0)) {
            this.fullDir.mkdir();
            if (this.useSubset) {
                log.info("Downloading {} subset...", (Object)this.localDir);
                LFWLoader.downloadAndUntar(lfwSubsetData, this.fullDir);
            } else {
                log.info("Downloading {}...", (Object)this.localDir);
                LFWLoader.downloadAndUntar(lfwData, this.fullDir);
                LFWLoader.downloadAndUntar(lfwLabel, this.fullDir);
            }
        }
        FileSplit fileSplit = new FileSplit(this.fullDir, ALLOWED_FORMATS, rng);
        BalancedPathFilter pathFilter = new BalancedPathFilter(rng, ALLOWED_FORMATS, labelGenerator, numExamples, numLabels, 0L, batchSize, null);
        this.inputSplit = fileSplit.sample((PathFilter)pathFilter, new double[]{(double)numExamples * splitTrainTest, (double)numExamples * (1.0 - splitTrainTest)});
    }

    public boolean imageFilesExist() {
        if (this.useSubset) {
            File f = new File(BASE_DIR, lfwSubsetData.get("filesFilenameUnzipped"));
            if (!f.exists()) {
                return false;
            }
        } else {
            File f = new File(BASE_DIR, lfwData.get("filesFilenameUnzipped"));
            if (!f.exists()) {
                return false;
            }
            f = new File(BASE_DIR, lfwLabel.get("filesFilenameUnzipped"));
            if (!f.exists()) {
                return false;
            }
        }
        return true;
    }

    public RecordReader getRecordReader(long numExamples) {
        return this.getRecordReader(numExamples, numExamples, new long[]{this.height, this.width, this.channels}, this.useSubset ? 432L : 5749L, LABEL_PATTERN, true, 1.0, new Random(System.currentTimeMillis()));
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, long numLabels, Random rng) {
        return this.getRecordReader(numExamples, batchSize, new long[]{this.height, this.width, this.channels}, numLabels, LABEL_PATTERN, true, 1.0, rng);
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, boolean train, double splitTrainTest) {
        return this.getRecordReader(numExamples, batchSize, new long[]{this.height, this.width, this.channels}, this.useSubset ? 432L : 5749L, LABEL_PATTERN, train, splitTrainTest, new Random(System.currentTimeMillis()));
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, int[] imgDim, boolean train, double splitTrainTest, Random rng) {
        return this.getRecordReader(numExamples, batchSize, imgDim, this.useSubset ? 432L : 5749L, LABEL_PATTERN, train, splitTrainTest, rng);
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, long[] imgDim, boolean train, double splitTrainTest, Random rng) {
        return this.getRecordReader(numExamples, batchSize, imgDim, this.useSubset ? 432L : 5749L, LABEL_PATTERN, train, splitTrainTest, rng);
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, PathLabelGenerator labelGenerator, boolean train, double splitTrainTest, Random rng) {
        return this.getRecordReader(numExamples, batchSize, new long[]{this.height, this.width, this.channels}, this.useSubset ? 432L : 5749L, labelGenerator, train, splitTrainTest, rng);
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, int[] imgDim, PathLabelGenerator labelGenerator, boolean train, double splitTrainTest, Random rng) {
        return this.getRecordReader(numExamples, batchSize, imgDim, this.useSubset ? 432L : 5749L, labelGenerator, train, splitTrainTest, rng);
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, long[] imgDim, PathLabelGenerator labelGenerator, boolean train, double splitTrainTest, Random rng) {
        return this.getRecordReader(numExamples, batchSize, imgDim, this.useSubset ? 432L : 5749L, labelGenerator, train, splitTrainTest, rng);
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, int[] imgDim, long numLabels, PathLabelGenerator labelGenerator, boolean train, double splitTrainTest, Random rng) {
        this.load(batchSize, numExamples, numLabels, labelGenerator, splitTrainTest, rng);
        ImageRecordReader recordReader = new ImageRecordReader(imgDim[0], imgDim[1], imgDim[2], labelGenerator, this.imageTransform);
        try {
            InputSplit data = train ? this.inputSplit[0] : this.inputSplit[1];
            recordReader.initialize(data);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return recordReader;
    }

    public RecordReader getRecordReader(long batchSize, long numExamples, long[] imgDim, long numLabels, PathLabelGenerator labelGenerator, boolean train, double splitTrainTest, Random rng) {
        this.load(batchSize, numExamples, numLabels, labelGenerator, splitTrainTest, rng);
        ImageRecordReader recordReader = new ImageRecordReader(imgDim[0], imgDim[1], imgDim[2], labelGenerator, this.imageTransform);
        try {
            InputSplit data = train ? this.inputSplit[0] : this.inputSplit[1];
            recordReader.initialize(data);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        return recordReader;
    }

    @Override
    public INDArray asRowVector(File f) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asRowVector(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asMatrix(File f) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray asMatrix(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Image asImageMatrix(File f) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Image asImageMatrix(InputStream inputStream) throws IOException {
        throw new UnsupportedOperationException();
    }
}

